/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.google.common.base.Joiner;
import java.util.HashMap;
import java.util.Map;

public enum Region {
    GovCloud("us-gov-west-1"),
    US_EAST_1("us-east-1"),
    US_EAST_2("us-east-2"),
    US_WEST_1("us-west-1"),
    US_WEST_2("us-west-2"),
    EU_WEST_1("eu-west-1"),
    EU_WEST_2("eu-west-2"),
    EU_WEST_3("eu-west-3"),
    EU_NORTH_1("eu-north-1"),
    EU_CENTRAL_1("eu-central-1"),
    AP_SOUTH_1("ap-south-1"),
    AP_SOUTHEAST_1("ap-southeast-1"),
    AP_SOUTHEAST_2("ap-southeast-2"),
    AP_NORTHEAST_1("ap-northeast-1"),
    AP_NORTHEAST_2("ap-northeast-2"),
    SA_EAST_1("sa-east-1"),
    CN_NORTH_1("cn-north-1"),
    CN_NORTHWEST_1("cn-northwest-1"),
    CA_CENTRAL_1("ca-central-1");

    private static Map<String, Region> regionMap;
    public final String name;

    private Region(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static Region fromName(String regionName) {
        Region region = regionMap.get(regionName);
        if (region == null) {
            throw new IllegalArgumentException(String.format("No region called '%s', expected one of {%s}", regionName, Joiner.on((String)", ").join(regionMap.keySet())));
        }
        return region;
    }

    static {
        regionMap = new HashMap<String, Region>();
        for (Region region : Region.values()) {
            regionMap.put(region.name, region);
        }
    }
}

