/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.internal.converter.Encoder;
import java.util.regex.Pattern;

public final class UserAlias {
    public final String alias;
    private static final int ALIAS_MIN_LENGTH = 1;
    private static final int ALIAS_MAX_LENGTH = 32;
    private static final String ALIAS_REGEX = "^[a-z][a-z0-9]*(\\.[a-z][a-z0-9]*)*$";
    private static Pattern pattern = Pattern.compile("^[a-z][a-z0-9]*(\\.[a-z][a-z0-9]*)*$");

    public UserAlias(String alias) {
        int length = Encoder.asUTF8(alias).length;
        if (length < 1) {
            throw new IllegalArgumentException(String.format("The user alias '%s' must be at least %d characters long", alias, 1));
        }
        if (length > 32) {
            throw new IllegalArgumentException(String.format("The user alias '%s' cannot be longer than %d characters", alias, 32));
        }
        if (!pattern.matcher(alias).find()) {
            throw new IllegalArgumentException(String.format("The user alias '%s' did not match the regular expression '%s'", alias, ALIAS_REGEX));
        }
        this.alias = alias;
    }

    public String toString() {
        return this.alias;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.alias});
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserAlias) {
            UserAlias other = (UserAlias)obj;
            return Objects.equal((Object)this.alias, (Object)other.alias);
        }
        return false;
    }
}

