/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types.arn;

import com.schibsted.security.strongbox.sdk.exceptions.InvalidResourceName;
import com.schibsted.security.strongbox.sdk.types.arn.ARN;

public class RoleARN
extends ARN {
    public RoleARN(String arn) {
        super(arn);
        if (!this.resourceType.isPresent() || !((String)this.resourceType.get()).equals("role")) {
            throw new InvalidResourceName(arn, "Role ARN's should have 'role' as resource type");
        }
        if (this.region.isPresent()) {
            throw new InvalidResourceName(arn, "Role ARN's should not have a region");
        }
        if (!this.service.equals("iam")) {
            throw new InvalidResourceName(arn, String.format("Role ARN's service needs to be 'iam', not '%s'", this.service));
        }
        if (this.numParts != 6) {
            throw new InvalidResourceName(arn, String.format("Role ARN's should have 6 parts separated by ':', not %d parts", this.numParts));
        }
    }

    public String getRoleName() {
        return this.resource;
    }
}

