/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk;

import com.schibsted.security.strongbox.sdk.exceptions.PotentiallyMaliciousDataException;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generated.Config;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.KVStream;
import com.schibsted.security.strongbox.sdk.types.NewSecretEntry;
import com.schibsted.security.strongbox.sdk.types.RawSecretEntry;
import com.schibsted.security.strongbox.sdk.types.SRN;
import com.schibsted.security.strongbox.sdk.types.SecretEntry;
import com.schibsted.security.strongbox.sdk.types.SecretIdentifier;
import com.schibsted.security.strongbox.sdk.types.SecretMetadata;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public interface SecretsGroup
extends AutoCloseable {
    public RawSecretEntry create(NewSecretEntry var1);

    public RawSecretEntry addVersion(NewSecretEntry var1);

    public RawSecretEntry update(SecretMetadata var1);

    public Set<SecretIdentifier> identifiers();

    public void delete(SecretIdentifier var1);

    public KVStream<RawSecretEntry> stream();

    public SecretEntry decrypt(RawSecretEntry var1, SecretIdentifier var2, long var3);

    public SecretEntry decryptEvenIfNotActive(RawSecretEntry var1, SecretIdentifier var2, long var3);

    public SRN srn(SecretIdentifier var1);

    default public Optional<SecretEntry> getLatestActiveVersion(SecretIdentifier secretIdentifier) {
        Optional entry = this.stream().filter(Config.name.eq(secretIdentifier)).filter(Config.active()).reverse().findFirst();
        return entry.isPresent() ? Optional.of(this.decrypt((RawSecretEntry)entry.get(), secretIdentifier, ((RawSecretEntry)entry.get()).version)) : Optional.empty();
    }

    default public Optional<SecretEntry> getActive(SecretIdentifier secretIdentifier, long targetVersion) {
        List entry = this.stream().filter(Config.name.eq(secretIdentifier).AND(Config.version.eq(targetVersion))).filter(Config.active()).toList();
        if (entry.size() > 1) {
            throw new PotentiallyMaliciousDataException(String.format("Internal corruption: more than one entry for secret '%s' version '%d'", secretIdentifier.name, targetVersion));
        }
        return entry.size() == 1 ? Optional.of(this.decrypt((RawSecretEntry)entry.get(0), secretIdentifier, targetVersion)) : Optional.empty();
    }

    default public List<SecretEntry> getAllActiveVersions(SecretIdentifier secretIdentifier) {
        return this.stream().filter(Config.name.eq(secretIdentifier)).filter(Config.active()).toJavaStream().map(e -> this.decrypt((RawSecretEntry)e, secretIdentifier, e.version)).collect(Collectors.toList());
    }

    default public List<SecretEntry> getLatestActiveVersionOfAllSecrets() {
        return this.stream().filter(Config.active()).reverse().uniquePrimaryKey().toJavaStream().map(e -> this.decrypt((RawSecretEntry)e, e.secretIdentifier, e.version)).collect(Collectors.toList());
    }

    default public List<SecretEntry> getAllActiveVersions() {
        return this.stream().filter(Config.active()).toJavaStream().map(e -> this.decrypt((RawSecretEntry)e, e.secretIdentifier, e.version)).collect(Collectors.toList());
    }

    @Override
    public void close();
}

