/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.impl;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import com.schibsted.security.strongbox.sdk.SecretsGroup;
import com.schibsted.security.strongbox.sdk.SecretsGroupManager;
import com.schibsted.security.strongbox.sdk.exceptions.AlreadyExistsException;
import com.schibsted.security.strongbox.sdk.exceptions.DoesNotExistException;
import com.schibsted.security.strongbox.sdk.exceptions.FailedToDeleteResourceException;
import com.schibsted.security.strongbox.sdk.exceptions.SecretsGroupException;
import com.schibsted.security.strongbox.sdk.exceptions.UnexpectedStateException;
import com.schibsted.security.strongbox.sdk.exceptions.UnsupportedTypeException;
import com.schibsted.security.strongbox.sdk.internal.access.IAMPolicyManager;
import com.schibsted.security.strongbox.sdk.internal.encryption.Encryptor;
import com.schibsted.security.strongbox.sdk.internal.encryption.FileEncryptionContext;
import com.schibsted.security.strongbox.sdk.internal.encryption.KMSEncryptor;
import com.schibsted.security.strongbox.sdk.internal.impl.DefaultSecretsGroup;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generated.DynamoDB;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generated.File;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generated.Store;
import com.schibsted.security.strongbox.sdk.internal.srn.SecretsGroupSRN;
import com.schibsted.security.strongbox.sdk.internal.types.config.UserConfig;
import com.schibsted.security.strongbox.sdk.internal.types.store.DynamoDBReference;
import com.schibsted.security.strongbox.sdk.internal.types.store.FileReference;
import com.schibsted.security.strongbox.sdk.internal.types.store.StorageReference;
import com.schibsted.security.strongbox.sdk.internal.types.store.StorageType;
import com.schibsted.security.strongbox.sdk.types.ClientConfiguration;
import com.schibsted.security.strongbox.sdk.types.EncryptionStrength;
import com.schibsted.security.strongbox.sdk.types.Principal;
import com.schibsted.security.strongbox.sdk.types.SRN;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupIdentifier;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSecretsGroupManager
implements SecretsGroupManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultSecretsGroupManager.class);
    private final AWSCredentialsProvider awsCredentials;
    private final IAMPolicyManager policyManager;
    private final UserConfig userConfig;
    private final EncryptionStrength encryptionStrength;
    private final ClientConfiguration clientConfiguration;
    private final ConcurrentHashMap<SecretsGroupIdentifier, ReadWriteLock> readWriteLocks = new ConcurrentHashMap();
    private final ConcurrentHashMap<SecretsGroupIdentifier, KMSEncryptor> encryptors = new ConcurrentHashMap();

    public DefaultSecretsGroupManager() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public DefaultSecretsGroupManager(AWSCredentialsProvider awsCredentials) {
        this(awsCredentials, new UserConfig(), EncryptionStrength.AES_128, DefaultSecretsGroupManager.getDefaultClientConfiguration());
    }

    public DefaultSecretsGroupManager(AWSCredentialsProvider awsCredentials, UserConfig userConfig) {
        this(awsCredentials, userConfig, EncryptionStrength.AES_128, DefaultSecretsGroupManager.getDefaultClientConfiguration());
    }

    public DefaultSecretsGroupManager(AWSCredentialsProvider awsCredentials, UserConfig userConfig, EncryptionStrength encryptionStrength) {
        this(awsCredentials, userConfig, encryptionStrength, DefaultSecretsGroupManager.getDefaultClientConfiguration());
    }

    public DefaultSecretsGroupManager(AWSCredentialsProvider awsCredentials, UserConfig userConfig, EncryptionStrength encryptionStrength, ClientConfiguration clientConfiguration) {
        this.awsCredentials = awsCredentials;
        this.clientConfiguration = clientConfiguration;
        this.policyManager = IAMPolicyManager.fromCredentials(awsCredentials, this.clientConfiguration);
        this.userConfig = userConfig;
        this.encryptionStrength = encryptionStrength;
    }

    private static ClientConfiguration getDefaultClientConfiguration() {
        return new ClientConfiguration();
    }

    public SRN srn(SecretsGroupIdentifier group) {
        return new SecretsGroupSRN(this.policyManager.getAccount(), group);
    }

    @Override
    public SecretsGroupInfo create(SecretsGroupIdentifier group) {
        return this.create(group, new DynamoDBReference());
    }

    public SecretsGroupInfo create(SecretsGroupIdentifier group, StorageReference storageReference) {
        return this.create(group, storageReference, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public SecretsGroupInfo create(SecretsGroupIdentifier group, StorageReference storageReference, boolean allowExistingPendingDeletedOrDisabledKey) {
        ConcurrentHashMap<SecretsGroupIdentifier, ReadWriteLock> concurrentHashMap = this.readWriteLocks;
        synchronized (concurrentHashMap) {
            ReadWriteLock readWriteLock = this.getReadWriteLock(group);
            readWriteLock.writeLock().lock();
            try {
                SecretsGroupInfo secretsGroupInfo;
                KMSEncryptor kmsEncryptor = this.getEncryptor(group);
                ReentrantReadWriteLock localReadWriteLock = new ReentrantReadWriteLock();
                this.verifyThatNonOfTheResourcesExistsOrThrow(group, kmsEncryptor, localReadWriteLock, allowExistingPendingDeletedOrDisabledKey);
                ExecutorService executor = Executors.newFixedThreadPool(6);
                try {
                    Future<Store> storeFuture = executor.submit(() -> {
                        Store store = this.createStore(group, storageReference, localReadWriteLock);
                        this.setLocalState(group, storageReference);
                        return store;
                    });
                    Future<Void> encryptorFuture = executor.submit(() -> {
                        kmsEncryptor.create(allowExistingPendingDeletedOrDisabledKey);
                        return null;
                    });
                    encryptorFuture.get();
                    Store store = storeFuture.get();
                    Future<String> adminArnFuture = executor.submit(() -> this.policyManager.createAdminPolicy(group, kmsEncryptor, store));
                    Future<String> readOnlyArnFuture = executor.submit(() -> this.policyManager.createReadOnlyPolicy(group, kmsEncryptor, store));
                    String adminArn = adminArnFuture.get();
                    String readOnlyArn = readOnlyArnFuture.get();
                    SecretsGroupSRN secretsGroupSRN = new SecretsGroupSRN(this.policyManager.getAccount(), group);
                    secretsGroupInfo = new SecretsGroupInfo(secretsGroupSRN, Optional.of(kmsEncryptor.getArn()), Optional.of(store.getArn()), Optional.of(adminArn), Optional.of(readOnlyArn), new ArrayList<Principal>(), new ArrayList<Principal>());
                }
                catch (InterruptedException | ExecutionException e) {
                    throw new SecretsGroupException(group, "Failed to create group: this might have left a partially constructed group, which can be deleted.", e);
                }
                finally {
                    executor.shutdownNow();
                }
                return secretsGroupInfo;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                readWriteLock.writeLock().unlock();
            }
        }
    }

    private ReadWriteLock getReadWriteLock(SecretsGroupIdentifier group) {
        ReentrantReadWriteLock newLock = new ReentrantReadWriteLock();
        ReadWriteLock existingLock = this.readWriteLocks.putIfAbsent(group, new ReentrantReadWriteLock());
        return existingLock != null ? existingLock : newLock;
    }

    private void verifyThatNonOfTheResourcesExistsOrThrow(SecretsGroupIdentifier group, KMSEncryptor encryptor, ReadWriteLock readWriteLock, boolean allowExistingPendingDeletedOrDisabledKey) {
        ExecutorService executor = Executors.newFixedThreadPool(4);
        try {
            Future<Optional> storageExistsFuture = executor.submit(() -> this.storageExists(group, readWriteLock));
            Future<Boolean> encryptorExistsFuture = executor.submit(() -> encryptor.exists(allowExistingPendingDeletedOrDisabledKey));
            Future<Boolean> adminPolicyExistsFuture = executor.submit(() -> this.policyManager.adminPolicyExists(group));
            Future<Boolean> readOnlyPolicyExistsFuture = executor.submit(() -> this.policyManager.readOnlyPolicyExists(group));
            Optional storageType = storageExistsFuture.get();
            if (storageType.isPresent()) {
                throw new AlreadyExistsException(String.format("There already exists a storage backend for the group '%s' of type '%s'", group, storageType.get()));
            }
            if (adminPolicyExistsFuture.get().booleanValue()) {
                throw new AlreadyExistsException(String.format("There already exists an admin policy for the group '%s'", group));
            }
            if (readOnlyPolicyExistsFuture.get().booleanValue()) {
                throw new AlreadyExistsException(String.format("There already exists a read only policy for the group '%s'", group));
            }
            if (encryptorExistsFuture.get().booleanValue()) {
                throw new AlreadyExistsException(String.format("There already exists an encryptor backend for the group '%s'. Please note that it takes %d days for a key to be deleted. If you intend to reuse the key, use the '--allow-key-reuse' flag.", group, encryptor.pendingDeletionWindowInDays()));
            }
        }
        catch (AlreadyExistsException e) {
            throw new SecretsGroupException(group, "The group already exists", e);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new SecretsGroupException(group, "Failed to verify if the group already exists", e);
        }
        finally {
            executor.shutdownNow();
        }
    }

    private Store getCurrentStore(SecretsGroupIdentifier group, ReadWriteLock readWriteLock) {
        if (this.userConfig.getLocalFilePath(group).isPresent()) {
            KMSEncryptor kmsEncryptor = this.getEncryptor(group);
            return new File(this.userConfig.getLocalFilePath(group).get(), kmsEncryptor, new FileEncryptionContext(group), readWriteLock);
        }
        try {
            DynamoDB dynamoDB = DynamoDB.fromCredentials(this.awsCredentials, this.clientConfiguration, group, readWriteLock);
            return dynamoDB;
        }
        catch (ResourceNotFoundException e) {
            throw new DoesNotExistException("No storage backend found!", e);
        }
    }

    private StorageReference getCurrentStorageReference(SecretsGroupIdentifier group) {
        if (this.userConfig.getLocalFilePath(group).isPresent()) {
            return new FileReference(this.userConfig.getLocalFilePath(group).get());
        }
        return new DynamoDBReference();
    }

    private Optional<StorageType> storageExists(SecretsGroupIdentifier group, ReadWriteLock readWriteLock) {
        if (this.userConfig.getLocalFilePath(group).isPresent()) {
            KMSEncryptor kmsEncryptor = this.getEncryptor(group);
            File file = new File(this.userConfig.getLocalFilePath(group).get(), kmsEncryptor, new FileEncryptionContext(group), readWriteLock);
            return file.exists() ? Optional.of(StorageType.FILE) : Optional.empty();
        }
        DynamoDB dynamoDB = DynamoDB.fromCredentials(this.awsCredentials, this.clientConfiguration, group, readWriteLock);
        return dynamoDB.exists() ? Optional.of(StorageType.DYNAMODB) : Optional.empty();
    }

    private Store createStore(SecretsGroupIdentifier group, StorageReference storageReference, ReadWriteLock readWriteLock) {
        if (storageReference instanceof DynamoDBReference) {
            DynamoDB store = DynamoDB.fromCredentials(this.awsCredentials, this.clientConfiguration, group, readWriteLock);
            store.create();
            return store;
        }
        if (storageReference instanceof FileReference) {
            FileReference fileReference = (FileReference)storageReference;
            KMSEncryptor kmsEncryptor = this.getEncryptor(group);
            File store = new File(fileReference.path, kmsEncryptor, new FileEncryptionContext(group), readWriteLock);
            store.create();
            return store;
        }
        throw new UnsupportedTypeException(storageReference.getClass().getName());
    }

    private KMSEncryptor getEncryptor(SecretsGroupIdentifier group) {
        return this.encryptors.computeIfAbsent(group, k -> KMSEncryptor.fromCredentials(this.awsCredentials, this.clientConfiguration, group, this.encryptionStrength));
    }

    public Encryptor encryptor(SecretsGroupIdentifier group) {
        return this.getEncryptor(group);
    }

    private void setLocalState(SecretsGroupIdentifier group, StorageReference storageReference) {
        if (storageReference instanceof FileReference) {
            FileReference fileReference = (FileReference)storageReference;
            java.io.File newPath = fileReference.path;
            this.userConfig.addLocalFilePath(group, newPath);
        }
    }

    private void removeLocalState(SecretsGroupIdentifier group, Store store) {
        if (store instanceof File) {
            this.userConfig.removeLocalFilePath(group);
        }
    }

    @Override
    public SecretsGroup get(SecretsGroupIdentifier group) {
        ReadWriteLock readWriteLock = this.getReadWriteLock(group);
        Store store = this.getCurrentStore(group, readWriteLock);
        KMSEncryptor encryptor = this.getEncryptor(group);
        return new DefaultSecretsGroup(this.getAccount(), group, store, encryptor, readWriteLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<SecretsGroupIdentifier> identifiers() {
        ConcurrentHashMap<SecretsGroupIdentifier, ReadWriteLock> concurrentHashMap = this.readWriteLocks;
        synchronized (concurrentHashMap) {
            IAMPolicyManager policyManager = IAMPolicyManager.fromCredentials(this.awsCredentials, this.clientConfiguration);
            return policyManager.getSecretsGroupIdentifiers();
        }
    }

    @Override
    public SecretsGroupInfo info(SecretsGroupIdentifier group) {
        ReadWriteLock readWriteLock = this.getReadWriteLock(group);
        readWriteLock.readLock().lock();
        try {
            ExecutorService executor = Executors.newFixedThreadPool(6);
            KMSEncryptor kmsEncryptor = this.getEncryptor(group);
            Future<Optional> kmsArnFuture = executor.submit(() -> {
                if (kmsEncryptor.exists()) {
                    return Optional.of(kmsEncryptor.getArn());
                }
                return Optional.empty();
            });
            Future<Optional> storeArnFuture = executor.submit(() -> {
                try {
                    Store store = this.getCurrentStore(group, readWriteLock);
                    if (store.exists()) {
                        return Optional.of(store.getArn());
                    }
                    return Optional.empty();
                }
                catch (DoesNotExistException e) {
                    return Optional.empty();
                }
            });
            Future<Optional> adminPolicyArnFuture = executor.submit(() -> {
                if (this.policyManager.adminPolicyExists(group)) {
                    return Optional.of(this.policyManager.getAdminPolicyArn(group));
                }
                return Optional.empty();
            });
            Future<Optional> readOnlyPolicyArnFuture = executor.submit(() -> {
                if (this.policyManager.readOnlyPolicyExists(group)) {
                    return Optional.of(this.policyManager.getReadOnlyArn(group));
                }
                return Optional.empty();
            });
            Future<List> adminFuture = executor.submit(() -> {
                try {
                    return this.policyManager.listAttachedAdmin(group);
                }
                catch (DoesNotExistException e) {
                    return new ArrayList();
                }
            });
            Future<List> readOnlyFuture = executor.submit(() -> {
                try {
                    return this.policyManager.listAttachedReadOnly(group);
                }
                catch (DoesNotExistException e) {
                    return new ArrayList();
                }
            });
            executor.shutdown();
            try {
                Optional kmsArn = kmsArnFuture.get();
                Optional storeArn = storeArnFuture.get();
                Optional adminPolicyArn = adminPolicyArnFuture.get();
                Optional readOnlyPolicyArn = readOnlyPolicyArnFuture.get();
                List admin = adminFuture.get();
                List readOnly = readOnlyFuture.get();
                SecretsGroupSRN secretsGroupSRN = new SecretsGroupSRN(this.policyManager.getAccount(), group);
                SecretsGroupInfo secretsGroupInfo = new SecretsGroupInfo(secretsGroupSRN, kmsArn, storeArn, adminPolicyArn, readOnlyPolicyArn, admin, readOnly);
                return secretsGroupInfo;
            }
            catch (InterruptedException | ExecutionException e) {
                throw new SecretsGroupException(group, "Error getting group information", e);
            }
        }
        finally {
            readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(SecretsGroupIdentifier group) {
        ConcurrentHashMap<SecretsGroupIdentifier, ReadWriteLock> concurrentHashMap = this.readWriteLocks;
        synchronized (concurrentHashMap) {
            ReadWriteLock readWriteLock = this.getReadWriteLock(group);
            readWriteLock.readLock().lock();
            try {
                log.info("About to delete Secrets Group: {}", (Object)group.name);
                ExecutorService executor = Executors.newFixedThreadPool(3);
                executor.submit(() -> {
                    try {
                        ReentrantReadWriteLock localReadWriteLock = new ReentrantReadWriteLock();
                        Store store = this.getCurrentStore(group, localReadWriteLock);
                        store.delete();
                        this.removeLocalState(group, store);
                        log.info("  Deleted Store");
                    }
                    catch (DoesNotExistException doesNotExistException) {
                        // empty catch block
                    }
                    return null;
                });
                executor.submit(() -> {
                    try {
                        this.policyManager.detachAllPrincipals(group);
                        log.info("  Detached all Principals from the IAM Policies");
                        this.policyManager.deleteAdminPolicy(group);
                        log.info("  Deleted Admin Policy");
                        this.policyManager.deleteReadonlyPolicy(group);
                        log.info("  Deleted Readonly Policy");
                    }
                    catch (DoesNotExistException doesNotExistException) {
                        // empty catch block
                    }
                    return null;
                });
                executor.submit(() -> {
                    try {
                        KMSEncryptor kmsEncryptor = this.getEncryptor(group);
                        kmsEncryptor.delete();
                        log.info(String.format("  Scheduled KMS key for deletion in %s days", kmsEncryptor.pendingDeletionWindowInDays()));
                    }
                    catch (DoesNotExistException | UnexpectedStateException runtimeException) {
                        // empty catch block
                    }
                    return null;
                });
                executor.shutdown();
                int timeoutValue = 2;
                TimeUnit timeoutUnit = TimeUnit.MINUTES;
                if (!executor.awaitTermination(timeoutValue, timeoutUnit)) {
                    throw new InterruptedException(String.format("Timeout of %d %s was reached when deleting resources for the group '%s'. This might have left the system in a dirty state.", timeoutValue, timeoutUnit.name(), group.name));
                }
            }
            catch (InterruptedException e) {
                throw new FailedToDeleteResourceException(String.format("Deletion of group '%s' was interrupted, this might have left the resources in a dirty state.", group.name), e);
            }
            finally {
                readWriteLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachAdmin(SecretsGroupIdentifier group, Principal principal) {
        ReadWriteLock readWriteLock = this.getReadWriteLock(group);
        readWriteLock.writeLock().lock();
        try {
            this.policyManager.attachAdmin(group, principal);
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachAdmin(SecretsGroupIdentifier group, Principal principal) {
        ReadWriteLock readWriteLock = this.getReadWriteLock(group);
        readWriteLock.writeLock().lock();
        try {
            this.policyManager.detachAdmin(group, principal);
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void detachReadOnly(SecretsGroupIdentifier group, Principal principal) {
        ReadWriteLock readWriteLock = this.getReadWriteLock(group);
        readWriteLock.writeLock().lock();
        try {
            this.policyManager.detachReadOnly(group, principal);
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void attachReadOnly(SecretsGroupIdentifier group, Principal principal) {
        ReadWriteLock readWriteLock = this.getReadWriteLock(group);
        readWriteLock.writeLock().lock();
        try {
            this.policyManager.attachReadOnly(group, principal);
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
    }

    private String getAccount() {
        return this.policyManager.getAccount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backup(SecretsGroupIdentifier group, Store backupStore, boolean failIfBackupStoreAlreadyExists) {
        ReadWriteLock readWriteLock = this.getReadWriteLock(group);
        readWriteLock.writeLock().lock();
        try {
            Store currentStore = this.getCurrentStore(group, readWriteLock);
            if (backupStore.exists()) {
                if (failIfBackupStoreAlreadyExists) {
                    throw new AlreadyExistsException("The store to backup to already exists");
                }
                backupStore.delete();
            }
            backupStore.create();
            currentStore.stream().forEach(backupStore::create);
            backupStore.close();
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restore(SecretsGroupIdentifier group, Store backupStore, boolean failIfStoreToRestoreAlreadyExists) {
        ReadWriteLock readWriteLock = this.getReadWriteLock(group);
        readWriteLock.writeLock().lock();
        try {
            Store currentStore = this.getCurrentStore(group, readWriteLock);
            if (currentStore.exists()) {
                if (failIfStoreToRestoreAlreadyExists) {
                    throw new AlreadyExistsException("The store to restore already exists");
                }
                currentStore.delete();
            }
            currentStore.create();
            backupStore.stream().forEach(currentStore::create);
            currentStore.close();
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecretsGroupInfo migrate(SecretsGroupIdentifier group, StorageReference newStorageReference) {
        ReadWriteLock readWriteLock = this.getReadWriteLock(group);
        readWriteLock.writeLock().lock();
        try {
            StorageReference currentStorageReference = this.getCurrentStorageReference(group);
            if (currentStorageReference.equals(newStorageReference)) {
                throw new IllegalStateException("You cannot migrate to the same backend!");
            }
            Store currentStore = this.getCurrentStore(group, readWriteLock);
            try (Store newStore = this.createStore(group, newStorageReference, readWriteLock);){
                currentStore.stream().forEach(newStore::create);
            }
            if (newStorageReference instanceof FileReference) {
                this.setLocalState(group, newStorageReference);
            } else {
                this.removeLocalState(group, currentStore);
            }
            currentStore.delete();
            SecretsGroupInfo secretsGroupInfo = this.info(group);
            return secretsGroupInfo;
        }
        finally {
            readWriteLock.writeLock().unlock();
        }
    }
}

