/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.impl;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.auth.STSAssumeRoleSessionCredentialsProvider;
import com.schibsted.security.strongbox.sdk.SecretsGroup;
import com.schibsted.security.strongbox.sdk.SimpleSecretsGroup;
import com.schibsted.security.strongbox.sdk.exceptions.EncodingException;
import com.schibsted.security.strongbox.sdk.impl.DefaultSecretsGroupManager;
import com.schibsted.security.strongbox.sdk.internal.SessionName;
import com.schibsted.security.strongbox.sdk.types.ByteSecretEntry;
import com.schibsted.security.strongbox.sdk.types.Encoding;
import com.schibsted.security.strongbox.sdk.types.SecretEntry;
import com.schibsted.security.strongbox.sdk.types.SecretIdentifier;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupIdentifier;
import com.schibsted.security.strongbox.sdk.types.StringSecretEntry;
import com.schibsted.security.strongbox.sdk.types.arn.RoleARN;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class DefaultSimpleSecretsGroup
implements SimpleSecretsGroup {
    private final SecretsGroup secretsGroup;

    DefaultSimpleSecretsGroup(SecretsGroup secretsGroup) {
        this.secretsGroup = secretsGroup;
    }

    public DefaultSimpleSecretsGroup(SecretsGroupIdentifier groupIdentifier) {
        this(groupIdentifier, (AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public DefaultSimpleSecretsGroup(SecretsGroupIdentifier groupIdentifier, RoleARN role) {
        STSAssumeRoleSessionCredentialsProvider assumedAWSCredentials = new STSAssumeRoleSessionCredentialsProvider.Builder(role.toArn(), SessionName.getSessionName("StrongboxSDK")).build();
        DefaultSecretsGroupManager secretsGroupManager = new DefaultSecretsGroupManager((AWSCredentialsProvider)assumedAWSCredentials);
        this.secretsGroup = secretsGroupManager.get(groupIdentifier);
    }

    public DefaultSimpleSecretsGroup(SecretsGroupIdentifier groupIdentifier, AWSCredentialsProvider credentialsProvider) {
        DefaultSecretsGroupManager secretsGroupManager = new DefaultSecretsGroupManager(credentialsProvider);
        this.secretsGroup = secretsGroupManager.get(groupIdentifier);
    }

    @Override
    public Optional<String> getStringSecret(SecretIdentifier secretIdentifier) {
        return this.asString(this.secretsGroup.getLatestActiveVersion(secretIdentifier));
    }

    @Override
    public Optional<String> getStringSecret(String secretIdentifier) {
        return this.getStringSecret(new SecretIdentifier(secretIdentifier));
    }

    @Override
    public Optional<String> getStringSecret(SecretIdentifier secretIdentifier, long version) {
        return this.asString(this.secretsGroup.getActive(secretIdentifier, version));
    }

    @Override
    public Optional<String> getStringSecret(String secretIdentifier, long version) {
        return this.getStringSecret(new SecretIdentifier(secretIdentifier), version);
    }

    @Override
    public List<StringSecretEntry> getAllStringSecrets() {
        return this.secretsGroup.getLatestActiveVersionOfAllSecrets().stream().filter(secretEntry -> secretEntry.secretValue.encoding == Encoding.UTF8).map(StringSecretEntry::of).collect(Collectors.toList());
    }

    @Override
    public Optional<byte[]> getBinarySecret(SecretIdentifier secretIdentifier) {
        return this.asBinary(this.secretsGroup.getLatestActiveVersion(secretIdentifier));
    }

    @Override
    public Optional<byte[]> getBinarySecret(String secretIdentifier) {
        return this.getBinarySecret(new SecretIdentifier(secretIdentifier));
    }

    @Override
    public Optional<byte[]> getBinarySecret(SecretIdentifier secretIdentifier, long version) {
        return this.asBinary(this.secretsGroup.getActive(secretIdentifier, version));
    }

    @Override
    public Optional<byte[]> getBinarySecret(String secretIdentifier, long version) {
        return this.getBinarySecret(new SecretIdentifier(secretIdentifier), version);
    }

    @Override
    public List<ByteSecretEntry> getAllBinarySecrets() {
        return this.secretsGroup.getLatestActiveVersionOfAllSecrets().stream().filter(secretEntry -> secretEntry.secretValue.encoding == Encoding.BINARY).map(ByteSecretEntry::of).collect(Collectors.toList());
    }

    private Optional<String> asString(Optional<SecretEntry> secretEntry) {
        this.verifyEncodingOrThrow(secretEntry, Encoding.UTF8);
        return secretEntry.map(e -> e.secretValue.asString());
    }

    private Optional<byte[]> asBinary(Optional<SecretEntry> secretEntry) {
        this.verifyEncodingOrThrow(secretEntry, Encoding.BINARY);
        return secretEntry.map(e -> e.secretValue.asByteArray());
    }

    private void verifyEncodingOrThrow(Optional<SecretEntry> secretEntry, Encoding expectedEncoding) {
        if (secretEntry.isPresent() && secretEntry.get().secretValue.encoding != expectedEncoding) {
            throw new EncodingException(String.format("Expected secret value encoding to be '%s' but was '%s'", new Object[]{expectedEncoding, secretEntry.get().secretValue.encoding}));
        }
    }
}

