/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal;

import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Protocol;
import com.schibsted.security.strongbox.sdk.exceptions.SecurityConfigurationException;
import com.schibsted.security.strongbox.sdk.types.ClientConfiguration;

public class ClientConfigurationHelper {
    public static com.amazonaws.ClientConfiguration transformAndVerifyOrThrow(ClientConfiguration clientConfiguration) {
        com.amazonaws.ClientConfiguration awsClientConfig = new ClientConfigurationFactory().getConfig();
        if (awsClientConfig.getProtocol() != Protocol.HTTPS) {
            throw new SecurityConfigurationException("Must use HTTPS protocol");
        }
        clientConfiguration.proxy.ifPresent(p -> {
            awsClientConfig.setProxyHost(p.proxyHost);
            awsClientConfig.setProxyPort(p.proxyPort);
            if (!p.nonProxyHosts.isEmpty()) {
                awsClientConfig.setNonProxyHosts(String.join((CharSequence)"|", p.nonProxyHosts));
            }
            p.proxyUsername.ifPresent(arg_0 -> ((com.amazonaws.ClientConfiguration)awsClientConfig).setProxyUsername(arg_0));
            p.proxyPassword.ifPresent(arg_0 -> ((com.amazonaws.ClientConfiguration)awsClientConfig).setProxyPassword(arg_0));
        });
        return ClientConfigurationHelper.verifyOrThrow(awsClientConfig);
    }

    public static com.amazonaws.ClientConfiguration verifyOrThrow(com.amazonaws.ClientConfiguration clientConfiguration) {
        if (clientConfiguration.getProtocol() != Protocol.HTTPS) {
            throw new SecurityConfigurationException("Must use HTTPS protocol");
        }
        return clientConfiguration;
    }
}

