/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal;

import com.schibsted.security.strongbox.sdk.internal.converter.Encoder;
import java.util.Optional;

public class InputValidation {
    public static final int COMMENT_BYTE_LIMIT = 1000;
    public static final String COMMENT_FIELD_NAME = "comment";

    private static Optional<String> verifySizeAndReturn(Optional<String> string, int maxLength, String name) {
        if (string.isPresent() && Encoder.asUTF8(string.get()).length > maxLength) {
            throw new IllegalArgumentException(String.format("%s must be less than %d bytes", name, maxLength));
        }
        return string;
    }

    public static Optional<String> verifyComment(Optional<String> comment) {
        return InputValidation.verifySizeAndReturn(comment, 1000, COMMENT_FIELD_NAME);
    }
}

