/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal;

import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.exceptions.InvalidResourceName;
import com.schibsted.security.strongbox.sdk.internal.AWSResourceNameSerialization;
import com.schibsted.security.strongbox.sdk.types.Region;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupIdentifier;

public final class RegionLocalResourceName {
    public final SecretsGroupIdentifier group;
    private static final String PREFIX = "strongbox";

    public RegionLocalResourceName(SecretsGroupIdentifier group) {
        this.group = group;
    }

    public String toString() {
        return String.format("%s_%s_%s", PREFIX, this.group.region.getName(), AWSResourceNameSerialization.encodeSecretsGroupName(this.group.name));
    }

    public static RegionLocalResourceName fromString(String wrappedAWSResourceName) {
        String[] parts = wrappedAWSResourceName.split("_");
        if (!parts[0].equals(PREFIX)) {
            throw new InvalidResourceName(wrappedAWSResourceName, "Regional local resource name should start with strongbox");
        }
        if (parts.length != 3) {
            throw new InvalidResourceName(wrappedAWSResourceName, "Regional local resource name should have exactly 3 parts");
        }
        Region region = Region.fromName(parts[1]);
        String name = AWSResourceNameSerialization.decodeSecretsGroupName(parts[2]);
        SecretsGroupIdentifier group = new SecretsGroupIdentifier(region, name);
        return new RegionLocalResourceName(group);
    }

    public boolean equals(Object obj) {
        if (obj instanceof RegionLocalResourceName) {
            RegionLocalResourceName other = (RegionLocalResourceName)obj;
            return Objects.equal((Object)this.group, (Object)other.group);
        }
        return false;
    }
}

