/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.config;

import com.amazonaws.profile.path.AwsProfileFileLocationProvider;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AWSCLIConfigFile {
    private static final Pattern sectionPattern = Pattern.compile("\\[([^\\[\\]]*)]");
    private static final Pattern propertyPattern = Pattern.compile("([^=]*)=([^=]*)");
    private final File file;

    public AWSCLIConfigFile(File file) {
        this.file = file;
    }

    public Config getConfig() {
        Config config;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(this.file));
        try {
            config = this.getConfig(bufferedReader);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Failed to load config from '%s': %s", this.file.getAbsolutePath(), e.getMessage()), e);
            }
        }
        bufferedReader.close();
        return config;
    }

    Config getConfig(BufferedReader reader) {
        try {
            String currentLine;
            HashMap<String, Section> sections = new HashMap<String, Section>();
            Optional<Object> currentSection = Optional.empty();
            int lineNumber = 1;
            while ((currentLine = reader.readLine()) != null) {
                if (currentLine.isEmpty() || currentLine.startsWith(";") || currentLine.startsWith("#")) continue;
                Optional<String> newSection = this.extractSection(currentLine);
                if (newSection.isPresent()) {
                    currentSection = newSection;
                } else {
                    Property property = this.extractProperty(currentLine, lineNumber);
                    Section sectionToUpdate = sections.computeIfAbsent(currentSection.orElse(""), Section::new);
                    sectionToUpdate.addProperty(property);
                }
                ++lineNumber;
            }
            return new Config(sections);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read config", e);
        }
    }

    Optional<String> extractSection(String line) {
        Matcher matcher = sectionPattern.matcher(line);
        if (matcher.find()) {
            return Optional.of(matcher.group(1).trim());
        }
        return Optional.empty();
    }

    Property extractProperty(String line, int lineNumber) {
        Matcher matcher = propertyPattern.matcher(line);
        if (!matcher.find()) {
            throw new IllegalStateException(String.format("Failed to interpret line #%d as 'key=value'. Please note that comment lines must start with '#'.", lineNumber));
        }
        return new Property(matcher.group(1).trim(), matcher.group(2).trim());
    }

    public static Optional<File> getCredentialProfilesFile() {
        return Optional.ofNullable(AwsProfileFileLocationProvider.DEFAULT_CREDENTIALS_LOCATION_PROVIDER.getLocation());
    }

    public static Optional<File> getConfigFile() {
        return Optional.ofNullable(AwsProfileFileLocationProvider.DEFAULT_CONFIG_LOCATION_PROVIDER.getLocation());
    }

    public static class Property {
        public final String key;
        public final String value;

        Property(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class Section {
        private final Map<String, String> properties = new HashMap<String, String>();
        public final String sectionName;

        Section(String sectionName) {
            this.sectionName = sectionName;
        }

        void addProperty(Property property) {
            this.properties.put(property.key, property.value);
        }

        public Optional<String> getProperty(String propertyName) {
            return Optional.ofNullable(this.properties.get(propertyName));
        }
    }

    public static class Config {
        private final Map<String, Section> sections;

        Config(Map<String, Section> sections) {
            this.sections = sections;
        }

        public Optional<Section> getSection(String sectionName) {
            return Optional.ofNullable(this.sections.get(sectionName));
        }
    }
}

