/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.config;

import com.schibsted.security.strongbox.sdk.internal.config.AWSCLIConfigFile;
import com.schibsted.security.strongbox.sdk.internal.config.AWSConfigPropertyKey;
import com.schibsted.security.strongbox.sdk.types.ProfileIdentifier;
import com.schibsted.security.strongbox.sdk.types.arn.RoleARN;
import java.util.Optional;

public class AWSConfig {
    private AWSCLIConfigFile.Config config;

    public AWSConfig(AWSCLIConfigFile.Config config) {
        this.config = config;
    }

    public Optional<String> getMFASerial(ProfileIdentifier profile) {
        return this.getProperty(profile, AWSConfigPropertyKey.MFA_SERIAL);
    }

    public Optional<ProfileIdentifier> getSourceProfile(ProfileIdentifier profile) {
        return this.getProperty(profile, AWSConfigPropertyKey.SOURCE_PROFILE).map(ProfileIdentifier::new);
    }

    public Optional<RoleARN> getRoleArn(ProfileIdentifier profile) {
        return this.getProperty(profile, AWSConfigPropertyKey.ROLE_ARN).map(RoleARN::new);
    }

    public Optional<String> getAWSAccessKeyId(ProfileIdentifier profile) {
        return this.getProperty(profile, AWSConfigPropertyKey.AWS_ACCESS_KEY_ID);
    }

    public Optional<String> getAWSSecretKey(ProfileIdentifier profile) {
        return this.getProperty(profile, AWSConfigPropertyKey.AWS_SECRET_ACCESS_KEY);
    }

    private Optional<String> getProperty(ProfileIdentifier profile, AWSConfigPropertyKey awsConfigField) {
        return this.getProperty(profile.name, awsConfigField.toString());
    }

    private Optional<String> getProperty(String profile, String property) {
        Optional<String> result = this.config.getSection(profile).flatMap(s -> s.getProperty(property));
        if (!result.isPresent()) {
            result = this.config.getSection("profile " + profile).flatMap(s -> s.getProperty(property));
        }
        return result;
    }
}

