/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.config;

import com.amazonaws.SdkClientException;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.util.EC2MetadataUtils;
import com.schibsted.security.strongbox.sdk.exceptions.FailedToResolveRegionException;
import com.schibsted.security.strongbox.sdk.internal.config.AWSCLIConfigFile;
import com.schibsted.security.strongbox.sdk.types.ProfileIdentifier;
import com.schibsted.security.strongbox.sdk.types.Region;
import java.io.File;
import java.util.Optional;

public class CustomRegionProviderChain {
    public Region resolveRegion() {
        return this.resolveRegion(Optional.empty(), new ProfileIdentifier("default"));
    }

    public Region resolveRegion(Optional<String> region, ProfileIdentifier profile) {
        Optional<Object> resolvedRegion = Optional.empty();
        if (region.isPresent()) {
            resolvedRegion = Optional.of(Region.fromName(region.get()));
        }
        if (!resolvedRegion.isPresent()) {
            resolvedRegion = this.getRegionFromEnvironment();
        }
        if (!resolvedRegion.isPresent()) {
            resolvedRegion = this.getRegionFromProfile(profile);
        }
        if (!resolvedRegion.isPresent()) {
            resolvedRegion = this.getRegionFromMetadata();
        }
        if (!resolvedRegion.isPresent()) {
            throw new FailedToResolveRegionException("A region must be specified");
        }
        return (Region)((Object)resolvedRegion.get());
    }

    private Optional<Region> getRegionFromEnvironment() {
        Region resolvedRegion = null;
        if (System.getenv("AWS_REGION") != null) {
            resolvedRegion = Region.fromName(System.getenv("AWS_REGION"));
        } else if (System.getenv("AWS_DEFAULT_REGION") != null) {
            resolvedRegion = Region.fromName(System.getenv("AWS_DEFAULT_REGION"));
        }
        return Optional.ofNullable(resolvedRegion);
    }

    private Optional<Region> getRegionFromProfile(ProfileIdentifier profile) {
        return this.getDefaultRegionFromConfigFile(profile.name);
    }

    private Optional<Region> getRegionFromMetadata() {
        try {
            Region resolvedRegion = null;
            if (EC2MetadataUtils.getInstanceInfo() != null) {
                resolvedRegion = EC2MetadataUtils.getInstanceInfo().getRegion() != null ? Region.fromName(EC2MetadataUtils.getInstanceInfo().getRegion()) : Region.fromName(new DefaultAwsRegionProviderChain().getRegion());
            }
            return Optional.ofNullable(resolvedRegion);
        }
        catch (SdkClientException e) {
            return Optional.empty();
        }
    }

    private Optional<Region> getDefaultRegionFromConfigFile(String profile) {
        Optional<Region> region = AWSCLIConfigFile.getCredentialProfilesFile().flatMap(file -> CustomRegionProviderChain.getRegionFromConfigFile(file, profile));
        if (!region.isPresent()) {
            region = AWSCLIConfigFile.getConfigFile().flatMap(file -> CustomRegionProviderChain.getRegionFromConfigFile(file, profile));
        }
        return region.map(Region::fromName);
    }

    private static Optional<String> getRegionFromConfigFile(File file, String profile) {
        AWSCLIConfigFile configFile = new AWSCLIConfigFile(file);
        AWSCLIConfigFile.Config config = configFile.getConfig();
        Optional<AWSCLIConfigFile.Section> profileSection = config.getSection(profile);
        if (!profileSection.isPresent()) {
            profileSection = config.getSection("profile " + profile);
        }
        return profileSection.flatMap(s -> s.getProperty("region"));
    }
}

