/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.config.credentials;

import com.amazonaws.auth.BasicSessionCredentials;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SessionCacheSchema {
    @JsonProperty(value="AssumedRoleUser")
    public final AssumedUserRole assumedUserRole;
    @JsonProperty(value="Credentials")
    public final Credentials credentials;

    public SessionCacheSchema(String arn, String assumedRoleId, BasicSessionCredentials credentials, ZonedDateTime expiration) {
        this.assumedUserRole = new AssumedUserRole(arn, assumedRoleId);
        this.credentials = new Credentials(credentials, expiration);
    }

    public SessionCacheSchema(@JsonProperty(value="AssumedRoleUser") AssumedUserRole assumedUserRole, @JsonProperty(value="Credentials") Credentials credentials) {
        this.assumedUserRole = assumedUserRole;
        this.credentials = credentials;
    }

    public static class Credentials {
        @JsonProperty(value="AccessKeyId")
        public final String accessKeyId;
        @JsonProperty(value="Expiration")
        public final String expiration;
        @JsonProperty(value="SecretAccessKey")
        public final String secretAccessKey;
        @JsonProperty(value="SessionToken")
        public final String sessionToken;

        public Credentials(@JsonProperty(value="AccessKeyId") String accessKeyId, @JsonProperty(value="Expiration") String expiration, @JsonProperty(value="SecretAccessKey") String secretAccessKey, @JsonProperty(value="SessionToken") String sessionToken) {
            this.accessKeyId = accessKeyId;
            this.expiration = expiration;
            this.secretAccessKey = secretAccessKey;
            this.sessionToken = sessionToken;
        }

        public Credentials(BasicSessionCredentials credentials, ZonedDateTime expiration) {
            this.accessKeyId = credentials.getAWSAccessKeyId();
            this.secretAccessKey = credentials.getAWSSecretKey();
            this.sessionToken = credentials.getSessionToken();
            this.expiration = expiration.format(DateTimeFormatter.ISO_INSTANT);
        }

        ZonedDateTime getExpiration() {
            return ZonedDateTime.parse(this.expiration, DateTimeFormatter.ISO_DATE_TIME);
        }
    }

    public static class AssumedUserRole {
        @JsonProperty(value="Arn")
        public final String arn;
        @JsonProperty(value="AssumedRoleId")
        public final String assumedRoleId;

        public AssumedUserRole(@JsonProperty(value="Arn") String arn, @JsonProperty(value="AssumedRoleId") String assumedRoleId) {
            this.arn = arn;
            this.assumedRoleId = assumedRoleId;
        }
    }
}

