/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.converter;

import com.schibsted.security.strongbox.sdk.internal.converter.Converter;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class Converters {
    private Map<Class, Converter> map = new HashMap<Class, Converter>();

    public Converters(Converter ... converters) {
        for (Converter converter : converters) {
            this.addConverter(converter.getType(), converter);
        }
    }

    public <T> void addConverter(Class<T> type, Converter<T> converter) {
        this.map.put(type, converter);
    }

    public <T> String to(T t) {
        if (t instanceof String) {
            return (String)t;
        }
        if (t instanceof Optional) {
            Optional optional = (Optional)t;
            if (optional.isPresent()) {
                Object o = optional.get();
                return this.map.get(o.getClass()).toString(o);
            }
            return null;
        }
        return this.map.get(t.getClass()).toString(t);
    }

    public <T> T from(String value, Class<T> type) {
        if (type.equals(String.class)) {
            return (T)value;
        }
        return this.map.get(type).fromString(value);
    }

    public <T> Object toObject(T t) {
        if (t instanceof Optional) {
            Optional optional = (Optional)t;
            if (optional.isPresent()) {
                Object o = optional.get();
                return this.map.get(o.getClass()).toObject(o);
            }
            return null;
        }
        return this.map.get(t.getClass()).toObject(t);
    }

    public <T> T fromObject(Object value, Class<T> type) {
        return this.map.get(type).fromObject(value);
    }

    public <T> Optional<T> fromOptionalObject(Object value, Class<T> type) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(this.map.get(type).fromObject(value));
    }

    public <T> Optional<T> fromOptional(String value, Class<T> type) {
        if (value == null) {
            return Optional.empty();
        }
        return Optional.of(this.map.get(type).fromString(value));
    }

    public <T> Class<?> getConvertedType(Class<?> targetType) {
        return this.map.get(targetType).getConvertedType();
    }
}

