/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.encryption;

import com.google.common.collect.ImmutableMap;
import com.schibsted.security.strongbox.sdk.internal.encryption.EncryptionContext;
import com.schibsted.security.strongbox.sdk.internal.encryption.Padding;
import com.schibsted.security.strongbox.sdk.types.SecretIdentifier;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupIdentifier;
import com.schibsted.security.strongbox.sdk.types.State;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Optional;

public class DefaultEncryptionContext
implements EncryptionContext {
    public final SecretsGroupIdentifier groupIdentifier;
    public final SecretIdentifier secretIdentifier;
    public final Long secretVersion;
    public final State state;
    public final Optional<ZonedDateTime> notBefore;
    public final Optional<ZonedDateTime> notAfter;

    public DefaultEncryptionContext(SecretsGroupIdentifier groupIdentifier, SecretIdentifier secretIdentifier, long secretVersion, State state, Optional<ZonedDateTime> notBefore, Optional<ZonedDateTime> notAfter) {
        this.groupIdentifier = groupIdentifier;
        this.secretIdentifier = secretIdentifier;
        this.secretVersion = secretVersion;
        this.state = state;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
    }

    @Override
    public Map<String, String> toMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"0", (Object)Padding.padWithSpaces(this.groupIdentifier.region.getName(), 14));
        builder.put((Object)"1", (Object)Padding.padWithSpaces(this.groupIdentifier.name, 64));
        builder.put((Object)"2", (Object)Padding.padWithSpaces(this.secretIdentifier.name, 128));
        builder.put((Object)"3", (Object)Padding.padWithZeros(this.secretVersion));
        builder.put((Object)"4", (Object)Padding.singleDigit(this.state.asByte()));
        builder.put((Object)"5", (Object)Padding.isPresent(this.notBefore));
        builder.put((Object)"6", (Object)Padding.asOptionalString(this.notBefore));
        builder.put((Object)"7", (Object)Padding.isPresent(this.notAfter));
        builder.put((Object)"8", (Object)Padding.asOptionalString(this.notAfter));
        return builder.build();
    }
}

