/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.encryption;

import java.util.HashMap;
import java.util.Map;

public enum KMSKeyState {
    ENABLED("Enabled"),
    DISABLED("Disabled"),
    PENDING_DELETION("PendingDeletion");

    private String name;
    private static Map<String, KMSKeyState> keyStateMap;

    private KMSKeyState(String name) {
        this.name = name;
    }

    public static KMSKeyState fromString(String keyState) {
        KMSKeyState state = keyStateMap.get(keyState);
        if (state == null) {
            throw new IllegalArgumentException("Unrecognized keyState '" + (Object)((Object)state) + "', expected one of " + keyStateMap.keySet());
        }
        return state;
    }

    public String toString() {
        return this.name;
    }

    static {
        keyStateMap = new HashMap<String, KMSKeyState>();
        for (KMSKeyState state : KMSKeyState.values()) {
            keyStateMap.put(state.name, state);
        }
    }
}

