/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.impl;

import com.schibsted.security.strongbox.sdk.SecretsGroup;
import com.schibsted.security.strongbox.sdk.exceptions.AlreadyExistsException;
import com.schibsted.security.strongbox.sdk.exceptions.DoesNotExistException;
import com.schibsted.security.strongbox.sdk.exceptions.PotentiallyMaliciousDataException;
import com.schibsted.security.strongbox.sdk.exceptions.StateCorruptionException;
import com.schibsted.security.strongbox.sdk.internal.converter.FormattedTimestamp;
import com.schibsted.security.strongbox.sdk.internal.encryption.BestEffortShredder;
import com.schibsted.security.strongbox.sdk.internal.encryption.DefaultEncryptionContext;
import com.schibsted.security.strongbox.sdk.internal.encryption.EncryptionContext;
import com.schibsted.security.strongbox.sdk.internal.encryption.EncryptionPayload;
import com.schibsted.security.strongbox.sdk.internal.encryption.Encryptor;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generated.Config;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generated.Store;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.KVStream;
import com.schibsted.security.strongbox.sdk.internal.srn.SecretSRN;
import com.schibsted.security.strongbox.sdk.types.NewSecretEntry;
import com.schibsted.security.strongbox.sdk.types.RawSecretEntry;
import com.schibsted.security.strongbox.sdk.types.SRN;
import com.schibsted.security.strongbox.sdk.types.SecretEntry;
import com.schibsted.security.strongbox.sdk.types.SecretIdentifier;
import com.schibsted.security.strongbox.sdk.types.SecretMetadata;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupIdentifier;
import com.schibsted.security.strongbox.sdk.types.State;
import com.schibsted.security.strongbox.sdk.types.UserAlias;
import java.time.ZonedDateTime;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;

public class DefaultSecretsGroup
implements SecretsGroup {
    private final Store store;
    private final Encryptor encryptor;
    private final SecretsGroupIdentifier groupIdentifier;
    private final String account;
    private final ReadWriteLock readWriteLock;

    public DefaultSecretsGroup(String account, SecretsGroupIdentifier groupIdentifier, Store store, Encryptor encryptor, ReadWriteLock readWriteLock) {
        this.store = store;
        this.encryptor = encryptor;
        this.groupIdentifier = groupIdentifier;
        this.account = account;
        this.readWriteLock = readWriteLock;
    }

    @Override
    public SRN srn(SecretIdentifier secretIdentifier) {
        return new SecretSRN(this.account, this.groupIdentifier, secretIdentifier);
    }

    @Override
    public RawSecretEntry create(NewSecretEntry newSecretEntry) {
        this.readWriteLock.writeLock().lock();
        try {
            RawSecretEntry entry = this.createEntry(newSecretEntry, 1L);
            this.store.create(entry);
            RawSecretEntry rawSecretEntry = entry;
            return rawSecretEntry;
        }
        catch (AlreadyExistsException e) {
            throw new AlreadyExistsException(String.format("A secret named '%s' already exists", newSecretEntry.secretIdentifier.name), e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public RawSecretEntry addVersion(NewSecretEntry newSecretEntry) {
        this.readWriteLock.writeLock().lock();
        try {
            Optional last = this.store.stream().filter(Config.name.eq(newSecretEntry.secretIdentifier)).reverse().findFirst();
            if (last.isPresent()) {
                long version = ((RawSecretEntry)last.get()).version + 1L;
                RawSecretEntry entry = this.createEntry(newSecretEntry, version);
                this.store.create(entry);
                ((RawSecretEntry)last.get()).bestEffortShred();
                RawSecretEntry rawSecretEntry = entry;
                return rawSecretEntry;
            }
            throw new DoesNotExistException(String.format("Secret with name '%s' does not exist", newSecretEntry.secretIdentifier.name));
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private RawSecretEntry createEntry(NewSecretEntry newSecretEntry, long version) {
        ZonedDateTime now = FormattedTimestamp.now();
        return this.createEntry(newSecretEntry, version, now, now, newSecretEntry.createdBy);
    }

    private RawSecretEntry createEntry(NewSecretEntry secret, long version, ZonedDateTime created, ZonedDateTime modified, Optional<UserAlias> modifiedBy) {
        byte[] encryptedPayload;
        DefaultEncryptionContext encryptionContext = new DefaultEncryptionContext(this.groupIdentifier, secret.secretIdentifier, version, secret.state, secret.notBefore, secret.notAfter);
        EncryptionPayload encryptionPayload = new EncryptionPayload(secret.secretValue, secret.userData, created, secret.createdBy, modified, modifiedBy, secret.comment);
        byte[] plaintext = encryptionPayload.toByteArray();
        if (plaintext == (encryptedPayload = this.encryptor.encrypt(plaintext, (EncryptionContext)encryptionContext))) {
            throw new StateCorruptionException("Internal error (file a bug): clearing the plaintext would corrupt the ciphertext!");
        }
        BestEffortShredder.shred(plaintext);
        return new RawSecretEntry(secret.secretIdentifier, version, secret.state, secret.notBefore, secret.notAfter, encryptedPayload);
    }

    @Override
    public SecretEntry decrypt(RawSecretEntry rawSecretEntry, SecretIdentifier expectedSecretIdentifier, long expectedVersion) {
        SecretEntry entry = this.decryptEvenIfNotActive(rawSecretEntry, expectedSecretIdentifier, expectedVersion);
        ZonedDateTime now = FormattedTimestamp.now();
        if (entry.notAfter.isPresent() && entry.notAfter.get().compareTo(now) < 0 || entry.notBefore.isPresent() && entry.notBefore.get().compareTo(now) > 0 || entry.state != State.ENABLED) {
            throw new IllegalArgumentException("The secret must be active to be decrypted with this method");
        }
        return entry;
    }

    @Override
    public SecretEntry decryptEvenIfNotActive(RawSecretEntry rawSecretEntry, SecretIdentifier expectedSecretIdentifier, long expectedVersion) {
        DefaultEncryptionContext encryptionContext = new DefaultEncryptionContext(this.groupIdentifier, expectedSecretIdentifier, expectedVersion, rawSecretEntry.state, rawSecretEntry.notBefore, rawSecretEntry.notAfter);
        byte[] decryptedPayload = this.encryptor.decrypt(rawSecretEntry.encryptedPayload, (EncryptionContext)encryptionContext);
        EncryptionPayload encryptionPayload = EncryptionPayload.fromByteArray(decryptedPayload);
        this.verifyNotTamperedWithOrThrow(rawSecretEntry, encryptionContext);
        SecretEntry secretEntry = new SecretEntry(encryptionPayload, rawSecretEntry);
        BestEffortShredder.shred(decryptedPayload);
        return secretEntry;
    }

    private void verifyNotTamperedWithOrThrow(RawSecretEntry rawSecretEntry, DefaultEncryptionContext encryptionContext) {
        if (!rawSecretEntry.secretIdentifier.equals(encryptionContext.secretIdentifier) || !rawSecretEntry.version.equals(encryptionContext.secretVersion)) {
            throw new PotentiallyMaliciousDataException("The metadata in the raw entry does not match the encrypted data!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RawSecretEntry update(SecretMetadata metadata) {
        this.readWriteLock.writeLock().lock();
        try {
            Optional existingEntry = this.stream().filter(Config.name.eq(metadata.secretIdentifier).AND(Config.version.eq(metadata.version))).findFirst();
            if (!existingEntry.isPresent()) {
                throw new DoesNotExistException(String.format("Secret with name=%s,version=%s does not exist", metadata.secretIdentifier.name, metadata.version));
            }
            SecretEntry current = this.decryptEvenIfNotActive((RawSecretEntry)existingEntry.get(), metadata.secretIdentifier, metadata.version);
            NewSecretEntry newSecretEntry = new NewSecretEntry(metadata.secretIdentifier, current.secretValue, metadata.state.orElse(current.state), current.createdBy, current.notBefore, current.notAfter, metadata.comment.orElse(current.comment), metadata.userData.orElse(current.userData));
            RawSecretEntry entry = this.createEntry(newSecretEntry, current.version, current.created, FormattedTimestamp.now(), metadata.modifiedBy);
            this.store.update(entry, (RawSecretEntry)existingEntry.get());
            ((RawSecretEntry)existingEntry.get()).bestEffortShred();
            current.bestEffortShred();
            newSecretEntry.bestEffortShred();
            RawSecretEntry rawSecretEntry = entry;
            return rawSecretEntry;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public KVStream<RawSecretEntry> stream() {
        return this.store.stream();
    }

    @Override
    public void delete(SecretIdentifier secretIdentifier) {
        this.store.delete(secretIdentifier);
    }

    @Override
    public Set<SecretIdentifier> identifiers() {
        return this.store.keySet();
    }

    @Override
    public void close() {
        this.readWriteLock.writeLock().lock();
        try {
            this.store.close();
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }
}

