/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.kv4j.generic.backend.dynamodb;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.schibsted.security.strongbox.sdk.exceptions.UnsupportedTypeException;
import com.schibsted.security.strongbox.sdk.internal.converter.Converters;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.RSEF;
import java.util.HashMap;
import java.util.Map;

public class FilterGenerator {
    public int count;

    FilterGenerator(int startCount) {
        this.count = startCount;
    }

    FilterGenerator() {
        this.count = 0;
    }

    public <Entry> Filter process(RSEF.ParsedAttributeCondition<Entry> attributeCondition, Converters converters) {
        if (attributeCondition instanceof RSEF.AndOperator) {
            RSEF.AndOperator current = (RSEF.AndOperator)attributeCondition;
            Filter left = this.process(current.left, converters);
            Filter right = this.process(current.right, converters);
            Map<String, String> expressionAttributeNames = FilterGenerator.merge(left.expressionAttributeNames, right.expressionAttributeNames);
            Map<String, AttributeValue> expressionAttributeValues = FilterGenerator.merge(left.expressionAttributeValues, right.expressionAttributeValues);
            String filterExpression = String.format("(%s) AND (%s)", left.filterExpression, right.filterExpression);
            return new Filter(expressionAttributeNames, expressionAttributeValues, filterExpression);
        }
        if (attributeCondition instanceof RSEF.OrOperator) {
            RSEF.OrOperator current = (RSEF.OrOperator)attributeCondition;
            Filter left = this.process(current.left, converters);
            Filter right = this.process(current.right, converters);
            Map<String, String> expressionAttributeNames = FilterGenerator.merge(left.expressionAttributeNames, right.expressionAttributeNames);
            Map<String, AttributeValue> expressionAttributeValues = FilterGenerator.merge(left.expressionAttributeValues, right.expressionAttributeValues);
            String filterExpression = String.format("(%s) OR (%s)", left.filterExpression, right.filterExpression);
            return new Filter(expressionAttributeNames, expressionAttributeValues, filterExpression);
        }
        if (attributeCondition instanceof RSEF.NotOperator) {
            RSEF.NotOperator current = (RSEF.NotOperator)attributeCondition;
            Filter left = this.process(current.left, converters);
            String filterExpression = String.format("NOT (%s)", left.filterExpression);
            return new Filter(left.expressionAttributeNames, left.expressionAttributeValues, filterExpression);
        }
        if (attributeCondition instanceof RSEF.ComparisonOperator) {
            RSEF.ComparisonOperator current = (RSEF.ComparisonOperator)attributeCondition;
            Filter left = this.createTerm(current.left, converters);
            Filter right = this.createTerm(current.right, converters);
            Map<String, String> expressionAttributeNames = FilterGenerator.merge(left.expressionAttributeNames, right.expressionAttributeNames);
            Map<String, AttributeValue> expressionAttributeValues = FilterGenerator.merge(left.expressionAttributeValues, right.expressionAttributeValues);
            String filterExpression = String.format("%s %s %s", left.filterExpression, FilterGenerator.getOperator(current.binaryOpType), right.filterExpression);
            return new Filter(expressionAttributeNames, expressionAttributeValues, filterExpression);
        }
        if (attributeCondition instanceof RSEF.ExistsOperator) {
            RSEF.ExistsOperator current = (RSEF.ExistsOperator)attributeCondition;
            Filter left = this.createTerm(current.reference, converters);
            String filterExpression = String.format("attribute_exists(%s)", left.filterExpression);
            return new Filter(left.expressionAttributeNames, filterExpression);
        }
        if (attributeCondition instanceof RSEF.NotExistsOperator) {
            RSEF.NotExistsOperator current = (RSEF.NotExistsOperator)attributeCondition;
            Filter left = this.createTerm(current.reference, converters);
            String filterExpression = String.format("attribute_not_exists(%s)", left.filterExpression);
            return new Filter(left.expressionAttributeNames, filterExpression);
        }
        throw new UnsupportedTypeException(attributeCondition.getClass().getName());
    }

    public <T> Filter createTerm(RSEF.TypedTerm<T> typedTerm, Converters converters) {
        if (typedTerm instanceof RSEF.TypedAttributeReference) {
            RSEF.TypedAttributeReference current = (RSEF.TypedAttributeReference)typedTerm;
            HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
            String paddedName = String.format("#%s", current.position.toString());
            expressionAttributeNames.put(paddedName, current.position.toString());
            return new Filter(expressionAttributeNames, paddedName);
        }
        if (typedTerm instanceof RSEF.TypedOptionalAttributeReference) {
            RSEF.TypedOptionalAttributeReference current = (RSEF.TypedOptionalAttributeReference)typedTerm;
            HashMap<String, String> expressionAttributeNames = new HashMap<String, String>();
            String paddedName = String.format("#%s", current.position.toString());
            expressionAttributeNames.put(paddedName, current.position.toString());
            return new Filter(expressionAttributeNames, paddedName);
        }
        if (typedTerm instanceof RSEF.TypedLiteral) {
            RSEF.TypedLiteral current = (RSEF.TypedLiteral)typedTerm;
            String placeHolderName = String.format(":%s", FilterGenerator.convertNumberToLetters(this.count++));
            Object value = converters.toObject(current.value);
            HashMap<String, AttributeValue> expressionAttributeValues = new HashMap<String, AttributeValue>();
            AttributeValue attributeValue = new AttributeValue();
            if (value instanceof Byte || value instanceof Long) {
                attributeValue.setN(value.toString());
            } else {
                attributeValue.setS((String)value);
            }
            expressionAttributeValues.put(placeHolderName, attributeValue);
            return new Filter(placeHolderName, expressionAttributeValues);
        }
        throw new UnsupportedTypeException(typedTerm.getClass().getName());
    }

    public static String getOperator(RSEF.BinaryOpType binaryOpType) {
        switch (binaryOpType) {
            case EQ: {
                return "=";
            }
            case GE: {
                return ">=";
            }
            case GT: {
                return ">";
            }
            case LE: {
                return "<=";
            }
            case LT: {
                return "<";
            }
            case NE: {
                return "<>";
            }
        }
        throw new UnsupportedTypeException(binaryOpType.name());
    }

    public static <A, B> Map<A, B> merge(Map<A, B> left, Map<A, B> right) {
        HashMap<A, B> result = new HashMap<A, B>();
        result.putAll(left);
        result.putAll(right);
        return result;
    }

    public static String convertNumberToLetters(int number) {
        int range = 26;
        StringBuilder sb = new StringBuilder();
        do {
            int last = number % range;
            sb.append(Character.toChars(97 + last));
        } while ((number /= range) != 0);
        return sb.reverse().toString();
    }

    public static class Filter {
        public final Map<String, String> expressionAttributeNames;
        public final Map<String, AttributeValue> expressionAttributeValues;
        public final String filterExpression;

        public Filter(Map<String, String> expressionAttributeNames, Map<String, AttributeValue> expressionAttributeValues, String filterExpression) {
            this.expressionAttributeNames = expressionAttributeNames;
            this.expressionAttributeValues = expressionAttributeValues;
            this.filterExpression = filterExpression;
        }

        public Filter(Map<String, String> expressionAttributeNames, String filterExpression) {
            this.expressionAttributeNames = expressionAttributeNames;
            this.expressionAttributeValues = new HashMap<String, AttributeValue>();
            this.filterExpression = filterExpression;
        }

        public Filter(String filterExpression, Map<String, AttributeValue> expressionAttributeValues) {
            this.expressionAttributeNames = new HashMap<String, String>();
            this.expressionAttributeValues = expressionAttributeValues;
            this.filterExpression = filterExpression;
        }
    }
}

