/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.kv4j.generic.backend.file;

import com.google.common.collect.Lists;
import com.schibsted.security.strongbox.sdk.exceptions.AlreadyExistsException;
import com.schibsted.security.strongbox.sdk.exceptions.DoesNotExistException;
import com.schibsted.security.strongbox.sdk.exceptions.FieldAccessException;
import com.schibsted.security.strongbox.sdk.exceptions.NoFieldMatchingAnnotationException;
import com.schibsted.security.strongbox.sdk.exceptions.ParseException;
import com.schibsted.security.strongbox.sdk.exceptions.SerializationException;
import com.schibsted.security.strongbox.sdk.exceptions.StateCorruptionException;
import com.schibsted.security.strongbox.sdk.exceptions.UnexpectedStateException;
import com.schibsted.security.strongbox.sdk.exceptions.UnsupportedTypeException;
import com.schibsted.security.strongbox.sdk.internal.converter.Converters;
import com.schibsted.security.strongbox.sdk.internal.converter.Encoder;
import com.schibsted.security.strongbox.sdk.internal.encryption.BestEffortShredder;
import com.schibsted.security.strongbox.sdk.internal.encryption.EncryptionContext;
import com.schibsted.security.strongbox.sdk.internal.encryption.Encryptor;
import com.schibsted.security.strongbox.sdk.internal.interfaces.ManagedResource;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.GenericStore;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.Attribute;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.PartitionKey;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.annotation.SortKey;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.KVStream;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.RSEF;
import com.schibsted.security.strongbox.sdk.internal.kv4j.generic.frontend.SecretEventStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class GenericFile<Entry, Primary, Secondary extends Comparable<? super Secondary>>
implements GenericStore<Entry, Primary>,
AutoCloseable,
ManagedResource {
    Map<Primary, Map<Secondary, Entry>> store = new HashMap<Primary, Map<Secondary, Entry>>();
    Converters converters;
    Class<Entry> clazz;
    File file;
    private final ReadWriteLock readWriteLock;
    private final byte SERIALIZATION_VERSION = 1;
    private final byte VERSION = 1;
    List<String> fieldNames = new ArrayList<String>();
    Map<String, Integer> padding = new HashMap<String, Integer>();
    private Encryptor encryptor;
    private EncryptionContext encryptionContext;

    public GenericFile(File path, Converters converters, Encryptor encryptor, EncryptionContext encryptionContext, Class<Entry> clazz, ReadWriteLock readWriteLock) {
        this.file = path;
        this.converters = converters;
        this.clazz = clazz;
        this.readWriteLock = readWriteLock;
        this.encryptor = encryptor;
        this.encryptionContext = encryptionContext;
        this.buildMappings();
        this.open();
    }

    private void buildMappings() {
        Field[] fields;
        for (Field field : fields = this.clazz.getDeclaredFields()) {
            Attribute[] attributes = (Attribute[])field.getAnnotationsByType(Attribute.class);
            PartitionKey[] partitionKey = (PartitionKey[])field.getAnnotationsByType(PartitionKey.class);
            SortKey[] sortKey = (SortKey[])field.getAnnotationsByType(SortKey.class);
            if (attributes.length > 0) {
                this.fieldNames.add(field.getName());
            }
            if (partitionKey.length > 0) {
                this.fieldNames.add(field.getName());
                this.padding.put(field.getName(), partitionKey[0].padding());
            }
            if (sortKey.length <= 0) continue;
            this.fieldNames.add(field.getName());
        }
    }

    public List<Entry> fromByteArray(byte[] payload) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(payload);
        byte version = byteBuffer.get();
        if (version != 1) {
            throw new IllegalArgumentException("The version needs to be 1");
        }
        long numEntries = byteBuffer.getLong();
        ArrayList<Entry> list = new ArrayList<Entry>();
        for (long index = 0L; index < numEntries; ++index) {
            byte schemaVersion = byteBuffer.get();
            if (schemaVersion != 1) {
                throw new IllegalArgumentException(String.format("The schema version should be %d but was %d", (byte)1, schemaVersion));
            }
            try {
                Entry result = this.clazz.newInstance();
                for (String fieldName : this.fieldNames) {
                    Field field = this.clazz.getField(fieldName);
                    Object fieldValue = this.getFieldValue(byteBuffer, fieldName);
                    field.set(result, fieldValue);
                }
                list.add(result);
                continue;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchFieldException e) {
                throw new RuntimeException("Failed create Entry", e);
            }
        }
        return list;
    }

    private Class<?> getType(String fieldName) {
        try {
            Field field = this.clazz.getField(fieldName);
            return field.getType();
        }
        catch (NoSuchFieldException e) {
            throw new FieldAccessException(fieldName, this.clazz.getName());
        }
    }

    private Class<?> getTypeOfOptional(String fieldName) {
        try {
            Field field = this.clazz.getField(fieldName);
            ParameterizedType type = (ParameterizedType)field.getGenericType();
            return (Class)type.getActualTypeArguments()[0];
        }
        catch (NoSuchFieldException e) {
            throw new FieldAccessException(fieldName, this.clazz.getName());
        }
    }

    private Object getFieldValue(ByteBuffer byteBuffer, String fieldName) {
        byte p;
        Class<?> clz = this.getConvertedType(fieldName);
        Object v = null;
        boolean present = true;
        if (this.isOptional(fieldName) && (p = byteBuffer.get()) == 0) {
            present = false;
        }
        if (clz.equals(String.class)) {
            byte[] value = this.readArray(byteBuffer);
            v = Encoder.fromUTF8(value);
        } else if (clz.equals(Long.class)) {
            v = byteBuffer.getLong();
        } else if (clz.equals(Byte.class)) {
            v = byteBuffer.get();
        } else if (clz.equals(byte[].class)) {
            v = this.readArray(byteBuffer);
        } else {
            throw new IllegalArgumentException(String.format("Unrecognized type '%s'", clz.getName()));
        }
        if (!present) {
            v = null;
        }
        if (this.isOptional(fieldName)) {
            return this.converters.fromOptionalObject(v, this.getTypeOfOptional(fieldName));
        }
        return this.converters.fromObject(v, this.getType(fieldName));
    }

    public byte[] toByteArray() {
        List entries = this.stream().toList();
        Size size = this.computeLength(entries);
        int headerSize = 13;
        ByteBuffer byteBuffer = ByteBuffer.allocate(headerSize + size.totalSize);
        byteBuffer.put((byte)1);
        byteBuffer.putLong(entries.size());
        for (Object entry : entries) {
            byteBuffer.put((byte)1);
            for (String fieldName : this.fieldNames) {
                Object value = this.getValue(entry, fieldName);
                Class<?> clz = this.getConvertedType(fieldName);
                int padding = this.getPadding(fieldName);
                if (this.isOptional(fieldName)) {
                    if (value == null) {
                        byteBuffer.put((byte)0);
                    } else {
                        byteBuffer.put((byte)1);
                    }
                }
                if (value == null) {
                    this.writeDummy(clz, byteBuffer, padding);
                    continue;
                }
                this.write(clz, value, byteBuffer, padding);
            }
        }
        byteBuffer.putInt(size.padding);
        byteBuffer.put(new byte[size.padding]);
        return byteBuffer.array();
    }

    private int getPadding(String fieldName) {
        Integer padding = this.padding.get(fieldName);
        if (padding != null) {
            return padding;
        }
        return 0;
    }

    private void write(Class<?> type, Object value, ByteBuffer byteBuffer, int padding) {
        if (type.equals(String.class)) {
            byte[] v = Encoder.asUTF8((String)value);
            this.writeArray(byteBuffer, v);
        } else if (type.equals(Byte.class)) {
            byteBuffer.put((Byte)value);
        } else if (type.equals(Long.class)) {
            byteBuffer.putLong((Long)value);
        } else if (type.equals(byte[].class)) {
            byte[] v = (byte[])value;
            this.writeArray(byteBuffer, v);
        }
    }

    private void writeDummy(Class<?> type, ByteBuffer byteBuffer, int padding) {
        if (type.equals(String.class)) {
            this.writeArray(byteBuffer, new byte[0]);
        } else if (type.equals(Byte.class)) {
            byteBuffer.put((byte)0);
        } else if (type.equals(Long.class)) {
            byteBuffer.putLong(0L);
        } else if (type.equals(byte[].class)) {
            this.writeArray(byteBuffer, new byte[0]);
        }
    }

    private void writeArray(ByteBuffer byteBuffer, byte[] value) {
        byteBuffer.putInt(value.length);
        byteBuffer.put(value);
    }

    private byte[] readArray(ByteBuffer byteBuffer) {
        int size = byteBuffer.getInt();
        byte[] value = new byte[size];
        byteBuffer.get(value);
        return value;
    }

    private Size computeLength(Entry entry, String fieldName) {
        int optional;
        int padding = this.getPadding(fieldName);
        Class<?> type = this.getConvertedType(fieldName);
        int size = this.getBaseSize(type, entry, fieldName);
        int n = optional = this.isOptional(fieldName) ? 1 : 0;
        if (padding > 0) {
            if (type.equals(String.class)) {
                return new Size(padding + 4 + optional, padding - size);
            }
            if (type.equals(Byte.class)) {
                return new Size(size + optional, 0);
            }
            if (type.equals(Long.class)) {
                return new Size(size + optional, 0);
            }
            if (type.equals(byte[].class)) {
                return new Size(padding + 4 + optional, padding - size);
            }
        } else {
            if (type.equals(String.class)) {
                return new Size(size + 4 + optional, 0);
            }
            if (type.equals(Byte.class)) {
                return new Size(size + optional, 0);
            }
            if (type.equals(Long.class)) {
                return new Size(size + optional, 0);
            }
            if (type.equals(byte[].class)) {
                return new Size(size + 4 + optional, 0);
            }
        }
        throw new RuntimeException("illegal state");
    }

    private int getBaseSize(Class<?> type, Entry entry, String fieldName) {
        Object value = this.getValue(entry, fieldName);
        if (value != null) {
            if (type.equals(String.class)) {
                byte[] v = Encoder.asUTF8((String)value);
                return v.length;
            }
            if (type.equals(Byte.class)) {
                return 1;
            }
            if (type.equals(Long.class)) {
                return 8;
            }
            if (type.equals(byte[].class)) {
                return ((byte[])value).length;
            }
        } else {
            if (type.equals(String.class)) {
                return 0;
            }
            if (type.equals(Byte.class)) {
                return 1;
            }
            if (type.equals(Long.class)) {
                return 8;
            }
            if (type.equals(byte[].class)) {
                return 0;
            }
        }
        throw new IllegalArgumentException("No suitable size");
    }

    private Size computeLength(List<Entry> entries) {
        int totalSize = 0;
        int padding = 0;
        for (Entry entry : entries) {
            ++totalSize;
            for (String fieldName : this.fieldNames) {
                Size entrySize = this.computeLength(entry, fieldName);
                totalSize += entrySize.totalSize;
                padding += entrySize.padding;
            }
        }
        return new Size(totalSize, padding);
    }

    private Object getValue(Entry entry, String fieldName) {
        try {
            Field field = this.getField(entry, fieldName);
            return this.converters.toObject(field.get(entry));
        }
        catch (IllegalAccessException e) {
            throw new FieldAccessException(fieldName, entry.getClass().getName(), e);
        }
    }

    private boolean isOptional(String fieldName) {
        try {
            Field field = this.clazz.getField(fieldName);
            return field.getType().equals(Optional.class);
        }
        catch (NoSuchFieldException e) {
            throw new FieldAccessException(fieldName, this.clazz.getName());
        }
    }

    private Class<?> getConvertedType(String fieldName) {
        try {
            Field field = this.clazz.getField(fieldName);
            if (field.getType().equals(Optional.class)) {
                ParameterizedType type = (ParameterizedType)field.getGenericType();
                return this.converters.getConvertedType((Class)type.getActualTypeArguments()[0]);
            }
            return this.converters.getConvertedType(field.getType());
        }
        catch (NoSuchFieldException e) {
            throw new FieldAccessException(fieldName, this.clazz.getName());
        }
    }

    private Field getField(Entry entry, String fieldName) {
        try {
            return entry.getClass().getField(fieldName);
        }
        catch (NoSuchFieldException e) {
            throw new FieldAccessException(fieldName, entry.getClass().getName(), e);
        }
    }

    @Override
    public String create() {
        this.readWriteLock.writeLock().lock();
        try {
            if (this.file.exists()) {
                throw new AlreadyExistsException(String.format("The file backend '%s' already exists", this.file.getAbsolutePath()));
            }
            this.close();
            String string = this.file.getAbsolutePath();
            return string;
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public void delete() {
        this.readWriteLock.writeLock().lock();
        try {
            if (!this.file.exists()) {
                throw new DoesNotExistException(String.format("The file backend '%s' does not exists", this.file.getAbsolutePath()));
            }
            this.store = new HashMap<Primary, Map<Secondary, Entry>>();
            if (this.file.exists() && !this.file.delete()) {
                throw new UnexpectedStateException(this.file.getPath(), "EXISTS", "DELETED", "File store deletion failed");
            }
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public Optional<String> awsAdminPolicy() {
        return Optional.empty();
    }

    @Override
    public Optional<String> awsReadOnlyPolicy() {
        return Optional.empty();
    }

    @Override
    public String getArn() {
        this.readWriteLock.readLock().lock();
        try {
            String string = this.file.getAbsolutePath();
            return string;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public boolean exists() {
        this.readWriteLock.readLock().lock();
        try {
            boolean bl = this.file.exists();
            return bl;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void create(Entry entry) {
        block5: {
            this.readWriteLock.writeLock().lock();
            try {
                Primary name = this.getPartitionKey(entry);
                Secondary version = this.getSortKey(entry);
                if (!this.store.containsKey(name)) {
                    this.store.put(name, new HashMap());
                }
                if (!this.store.get(name).containsKey(version)) {
                    this.store.get(name).put(version, entry);
                    break block5;
                }
                throw new AlreadyExistsException(String.format("File store entry already exists for name=%s,version=%s", name, version));
            }
            finally {
                this.readWriteLock.writeLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Entry entry, Entry existingEntry) {
        this.readWriteLock.writeLock().lock();
        try {
            Primary name = this.getPartitionKey(entry);
            Secondary version = this.getSortKey(entry);
            if (!this.store.containsKey(name) || this.store.get(name).containsKey(version)) {
                throw new DoesNotExistException(String.format("File store entry does not exist for: name=%s,version=%s,file=%s ", name, version, this.file.getPath()));
            }
            this.store.get(name).put(version, entry);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    private void open() {
        try {
            if (this.file.exists()) {
                byte[] ciphertext = Files.readAllBytes(this.file.toPath());
                List<Entry> list = this.fromByteArray(this.encryptor.decrypt(this.verifyAndRemoveVersion(ciphertext), this.encryptionContext));
                list.forEach(this::create);
            }
        }
        catch (IOException e) {
            throw new ParseException("Failed to deserialize file: " + this.file.getPath(), e);
        }
    }

    @Override
    public void close() {
        this.readWriteLock.writeLock().lock();
        try {
            byte[] plaintext = this.toByteArray();
            byte[] ciphertext = this.encryptor.encrypt(plaintext, this.encryptionContext);
            if (plaintext == ciphertext) {
                throw new StateCorruptionException("Internal error (file a bug): clearing the plaintext would corrupt the ciphertext!");
            }
            BestEffortShredder.shred(plaintext);
            Files.write(this.file.toPath(), this.prependVersion(ciphertext), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new SerializationException(String.format("Failed to serialize to file: '%s'", this.file.getPath()), e);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    public byte[] prependVersion(byte[] data) {
        byte[] version = new byte[]{1};
        byte[] versioned = new byte[data.length + 1];
        System.arraycopy(version, 0, versioned, 0, version.length);
        System.arraycopy(data, 0, versioned, version.length, data.length);
        return versioned;
    }

    public byte[] verifyAndRemoveVersion(byte[] data) {
        if (data[0] != 1) {
            throw new IllegalArgumentException(String.format("Version must be %d", (byte)1));
        }
        return Arrays.copyOfRange(data, 1, data.length);
    }

    @Override
    public void delete(Primary secretIdentifier) {
        this.readWriteLock.writeLock().lock();
        try {
            this.store.remove(secretIdentifier);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    @Override
    public Set<Primary> keySet() {
        this.readWriteLock.readLock().lock();
        try {
            Set<Primary> set = this.store.keySet();
            return set;
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
    }

    @Override
    public KVStream<Entry> stream() {
        return new KVStream(new FileExecutor(this.readWriteLock));
    }

    private Primary getPartitionKey(Entry entry) {
        Field[] fields;
        for (Field field : fields = entry.getClass().getDeclaredFields()) {
            try {
                PartitionKey[] partitionKey = (PartitionKey[])field.getAnnotationsByType(PartitionKey.class);
                if (partitionKey.length <= 0) continue;
                return (Primary)field.get(entry);
            }
            catch (IllegalAccessException e) {
                throw new FieldAccessException(field.getName(), entry.getClass().getName(), e);
            }
        }
        throw new NoFieldMatchingAnnotationException(PartitionKey.class.getName(), entry.getClass().getName());
    }

    private Secondary getSortKey(Entry entry) {
        Field[] fields;
        for (Field field : fields = entry.getClass().getDeclaredFields()) {
            try {
                SortKey[] sortKey = (SortKey[])field.getAnnotationsByType(SortKey.class);
                if (sortKey.length <= 0) continue;
                return (Secondary)((Comparable)field.get(entry));
            }
            catch (IllegalAccessException e) {
                throw new FieldAccessException(field.getName(), entry.getClass().getName(), e);
            }
        }
        throw new NoFieldMatchingAnnotationException(SortKey.class.getName(), entry.getClass().getName());
    }

    private class FileExecutor
    implements SecretEventStream.Executor<Entry> {
        private final ReadWriteLock readWriteLock;

        public FileExecutor(ReadWriteLock readWriteLock) {
            this.readWriteLock = readWriteLock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Stream<Entry> toJavaStream(SecretEventStream.Filter<Entry> filter) {
            this.readWriteLock.readLock().lock();
            try {
                Stream<Object> all;
                Stream stream = all = filter.keyCondition.isPresent() ? this.get(filter.parsedKeyCondition.get()) : this.all();
                if (filter.parsedAttributeCondition.isPresent()) {
                    RSEF.ParsedAttributeCondition condition = filter.parsedAttributeCondition.get();
                    all = all.filter(condition::evaluate);
                }
                if (filter.reverse) {
                    all = Lists.reverse((List)all.collect(Collectors.toCollection(LinkedList::new))).stream();
                }
                Stream stream2 = all;
                return stream2;
            }
            finally {
                this.readWriteLock.readLock().unlock();
            }
        }

        private Stream<Entry> all() {
            return GenericFile.this.store.values().stream().flatMap(e -> e.values().stream());
        }

        Stream<Entry> get(RSEF.ParsedKeyCondition<Entry> keyCondition) {
            if (keyCondition instanceof RSEF.KeyAND) {
                RSEF.KeyAND current = (RSEF.KeyAND)keyCondition;
                RSEF.PartitionKeyEqualityOperator e = current.left;
                Map f = GenericFile.this.store.get(e.right.value);
                RSEF.SortKeyComparisonOperator sortKeyComparisonOperator = current.right;
                return f.values().stream().filter(sortKeyComparisonOperator::evaluate);
            }
            if (keyCondition instanceof RSEF.PartitionKeyEqualityOperator) {
                RSEF.PartitionKeyEqualityOperator current = (RSEF.PartitionKeyEqualityOperator)keyCondition;
                return GenericFile.this.store.get(current.right.value).values().stream();
            }
            throw new UnsupportedTypeException(keyCondition.getClass().getName());
        }
    }

    public static class Size {
        public int totalSize;
        public int padding;

        public Size(int totalSize, int padding) {
            this.totalSize = totalSize;
            this.padding = padding;
        }
    }
}

