/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.internal.srn;

import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.types.SRN;
import com.schibsted.security.strongbox.sdk.types.SecretsGroupIdentifier;

public class SecretsGroupSRN
extends SRN {
    public final String account;
    public final SecretsGroupIdentifier groupIdentifier;
    private static final String RESOURCE_PREFIX = "group";

    public SecretsGroupSRN(String account, SecretsGroupIdentifier groupIdentifier) {
        this.account = account;
        this.groupIdentifier = groupIdentifier;
    }

    @Override
    public String toSrn() {
        return String.format("srn:aws:strongbox:%s:%s:%s/%s", this.groupIdentifier.region.getName(), this.account, RESOURCE_PREFIX, this.groupIdentifier.name.replace('.', '/'));
    }

    public String toString() {
        return this.toSrn();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.account, this.groupIdentifier});
    }

    public boolean equals(Object obj) {
        if (obj instanceof SecretsGroupSRN) {
            SecretsGroupSRN other = (SecretsGroupSRN)obj;
            return Objects.equal((Object)this.account, (Object)other.account) && Objects.equal((Object)this.groupIdentifier, (Object)other.groupIdentifier);
        }
        return false;
    }
}

