/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import java.util.HashMap;
import java.util.Map;

public enum Encoding {
    BINARY("binary", 0),
    UTF8("utf8", 1);

    static Map<String, Encoding> nameMap;
    static Map<Byte, Encoding> valueMap;
    private final byte value;
    private final String name;

    private Encoding(String name, byte value) {
        this.value = value;
        this.name = name;
    }

    public byte asByte() {
        return this.value;
    }

    public String toString() {
        return this.name;
    }

    public Encoding fromString(String encoding) {
        return nameMap.get(encoding);
    }

    public static Encoding fromByte(byte value) {
        return valueMap.get(value);
    }

    static {
        nameMap = new HashMap<String, Encoding>();
        valueMap = new HashMap<Byte, Encoding>();
        for (Encoding encoding : Encoding.values()) {
            valueMap.put(encoding.value, encoding);
            nameMap.put(encoding.name, encoding);
        }
    }
}

