/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.schibsted.security.strongbox.sdk.internal.encryption.BestEffortShred;
import com.schibsted.security.strongbox.sdk.types.Comment;
import com.schibsted.security.strongbox.sdk.types.SecretIdentifier;
import com.schibsted.security.strongbox.sdk.types.SecretValue;
import com.schibsted.security.strongbox.sdk.types.State;
import com.schibsted.security.strongbox.sdk.types.UserAlias;
import com.schibsted.security.strongbox.sdk.types.UserData;
import java.time.ZonedDateTime;
import java.util.Optional;

public final class NewSecretEntry
implements BestEffortShred {
    public final SecretIdentifier secretIdentifier;
    public final SecretValue secretValue;
    public final Optional<UserData> userData;
    public final State state;
    public final Optional<ZonedDateTime> notBefore;
    public final Optional<ZonedDateTime> notAfter;
    public final Optional<UserAlias> createdBy;
    public final Optional<Comment> comment;

    public NewSecretEntry(SecretIdentifier secretIdentifier, SecretValue secretValue, State state, Optional<UserAlias> createdBy, Optional<ZonedDateTime> notBefore, Optional<ZonedDateTime> notAfter, Optional<Comment> comment, Optional<UserData> userData) {
        this.secretIdentifier = secretIdentifier;
        this.secretValue = secretValue;
        this.userData = userData;
        this.state = state;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.createdBy = createdBy;
        this.comment = comment;
    }

    public NewSecretEntry(SecretIdentifier secretIdentifier, SecretValue secretValue, State state, Optional<ZonedDateTime> notBefore, Optional<ZonedDateTime> notAfter, Optional<Comment> comment) {
        this(secretIdentifier, secretValue, state, Optional.empty(), notBefore, notAfter, comment, Optional.empty());
    }

    public NewSecretEntry(SecretIdentifier secretIdentifier, SecretValue secretValue, State state) {
        this(secretIdentifier, secretValue, state, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    @Override
    public void bestEffortShred() {
        this.secretValue.bestEffortShred();
        this.userData.ifPresent(UserData::bestEffortShred);
    }
}

