/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.exceptions.InvalidResourceName;
import com.schibsted.security.strongbox.sdk.types.PrincipalType;

public final class Principal {
    public final PrincipalType type;
    public final String name;

    public Principal(PrincipalType type, String principalName) {
        this.type = type;
        this.name = principalName;
    }

    public static Principal fromArn(String arn, String account) {
        String[] parts = arn.split(":");
        if (!(parts.length == 6 && parts[0].equals("arn") && parts[1].equals("aws") && parts[2].equals("iam"))) {
            throw new InvalidResourceName(arn, "A principal ARN should start with 'arn:aws:iam' and have 6 parts");
        }
        if (!account.equals(parts[4])) {
            throw new IllegalArgumentException("The account in the ARN does not match account of the Principal trying to perform the action.");
        }
        String last = parts[5];
        String[] elements = last.split("/");
        if (elements.length != 2) {
            throw new InvalidResourceName(arn, "Resource name part of principal ARN should contain exactly one '/'. Only principal ARNs forgroups, users or roles can be used.");
        }
        String type = elements[0];
        String name = elements[1];
        return new Principal(PrincipalType.fromString(type), name);
    }

    public String toString() {
        return String.format("%s [%s]", this.name, this.type.toString());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.type});
    }

    public boolean equals(Object obj) {
        if (obj instanceof Principal) {
            Principal other = (Principal)obj;
            return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)((Object)this.type), (Object)((Object)other.type));
        }
        return false;
    }
}

