/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.google.common.base.MoreObjects;
import com.schibsted.security.strongbox.sdk.internal.encryption.BestEffortShred;
import com.schibsted.security.strongbox.sdk.internal.encryption.EncryptionPayload;
import com.schibsted.security.strongbox.sdk.types.Comment;
import com.schibsted.security.strongbox.sdk.types.RawSecretEntry;
import com.schibsted.security.strongbox.sdk.types.SecretIdentifier;
import com.schibsted.security.strongbox.sdk.types.SecretValue;
import com.schibsted.security.strongbox.sdk.types.State;
import com.schibsted.security.strongbox.sdk.types.UserAlias;
import com.schibsted.security.strongbox.sdk.types.UserData;
import java.time.ZonedDateTime;
import java.util.Optional;

public class SecretEntry
implements BestEffortShred {
    public final SecretIdentifier secretIdentifier;
    public final long version;
    public final SecretValue secretValue;
    public final ZonedDateTime created;
    public final ZonedDateTime modified;
    public final Optional<UserAlias> createdBy;
    public final Optional<UserAlias> modifiedBy;
    public final State state;
    public final Optional<ZonedDateTime> notBefore;
    public final Optional<ZonedDateTime> notAfter;
    public final Optional<Comment> comment;
    public final Optional<UserData> userData;

    public SecretEntry(EncryptionPayload encryptionPayload, RawSecretEntry rawSecretEntry) {
        this.secretIdentifier = rawSecretEntry.secretIdentifier;
        this.version = rawSecretEntry.version;
        this.state = rawSecretEntry.state;
        this.notBefore = rawSecretEntry.notBefore;
        this.notAfter = rawSecretEntry.notAfter;
        this.secretValue = encryptionPayload.value;
        this.userData = encryptionPayload.userData;
        this.created = encryptionPayload.created;
        this.modified = encryptionPayload.modified;
        this.createdBy = encryptionPayload.createdBy;
        this.modifiedBy = encryptionPayload.modifiedBy;
        this.comment = encryptionPayload.comment;
    }

    protected SecretEntry(SecretIdentifier secretIdentifier, long version, SecretValue secretValue, ZonedDateTime created, ZonedDateTime modified, Optional<UserAlias> createdBy, Optional<UserAlias> modifiedBy, State state, Optional<ZonedDateTime> notBefore, Optional<ZonedDateTime> notAfter, Optional<Comment> comment, Optional<UserData> userData) {
        this.secretIdentifier = secretIdentifier;
        this.version = version;
        this.secretValue = secretValue;
        this.created = created;
        this.modified = modified;
        this.createdBy = createdBy;
        this.modifiedBy = modifiedBy;
        this.state = state;
        this.notBefore = notBefore;
        this.notAfter = notAfter;
        this.comment = comment;
        this.userData = userData;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("secretIdentifier", (Object)this.secretIdentifier).add("version", this.version).add("secretValue", (Object)this.secretValue).add("created", (Object)this.created).add("modified", (Object)this.modified).add("state", (Object)this.state).add("notBefore", this.notBefore).add("notAfter", this.notAfter).add("comment", this.comment).add("userData", this.userData).toString();
    }

    @Override
    public void bestEffortShred() {
        this.secretValue.bestEffortShred();
        this.userData.ifPresent(UserData::bestEffortShred);
        this.comment.ifPresent(Comment::bestEffortShred);
    }
}

