/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.internal.json.SecretIdentifierDeserializer;
import com.schibsted.security.strongbox.sdk.internal.json.SecretIdentifierSerializer;
import java.util.regex.Pattern;

@JsonSerialize(using=SecretIdentifierSerializer.class)
@JsonDeserialize(using=SecretIdentifierDeserializer.class)
public final class SecretIdentifier {
    public final String name;
    private static final int NAME_MIN_LENGTH = 1;
    private static final int NAME_MAX_LENGTH = 128;
    private static final String NAME_REGEX = "^[a-zA-Z0-9]*([_\\-.][a-zA-Z0-9]+)*$";
    private static Pattern pattern = Pattern.compile("^[a-zA-Z0-9]*([_\\-.][a-zA-Z0-9]+)*$");

    @JsonCreator
    public SecretIdentifier(@JsonProperty(value="name") String name) {
        if (name.length() < 1) {
            throw new IllegalArgumentException(String.format("The secret name '%s' must be at least %d characters long", name, 1));
        }
        if (name.length() > 128) {
            throw new IllegalArgumentException(String.format("The secret name '%s' cannot be longer than %d characters", name, 128));
        }
        if (!pattern.matcher(name).find()) {
            throw new IllegalArgumentException(String.format("The secret name '%s' did not match the regular expression '%s'", name, NAME_REGEX));
        }
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name});
    }

    public boolean equals(Object obj) {
        if (obj instanceof SecretIdentifier) {
            SecretIdentifier other = (SecretIdentifier)obj;
            return Objects.equal((Object)this.name, (Object)other.name);
        }
        return false;
    }
}

