/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import java.util.HashMap;
import java.util.Map;

public enum SecretType {
    OPAQUE("opaque", 0);

    static Map<String, SecretType> nameMap;
    static Map<Byte, SecretType> valueMap;
    private final byte value;
    private final String name;

    private SecretType(String name, byte value) {
        this.name = name;
        this.value = value;
    }

    public String toString() {
        return this.name;
    }

    public byte asByte() {
        return this.value;
    }

    public static SecretType fromByte(byte value) {
        return valueMap.get(value);
    }

    static {
        nameMap = new HashMap<String, SecretType>();
        valueMap = new HashMap<Byte, SecretType>();
        for (SecretType type : SecretType.values()) {
            valueMap.put(type.value, type);
            nameMap.put(type.name, type);
        }
    }
}

