/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.internal.encryption.BestEffortShred;
import com.schibsted.security.strongbox.sdk.internal.encryption.BestEffortShredder;
import java.util.Arrays;

public final class UserData
implements BestEffortShred {
    private static final int MIN_LENGTH = 1;
    private static final int MAX_LENGTH = 50000;
    private byte[] userData;

    public UserData(byte[] userData) {
        if (userData.length < 1) {
            throw new IllegalArgumentException(String.format("UserData must be at least %d bytes", 1));
        }
        if (userData.length > 50000) {
            throw new IllegalArgumentException(String.format("UserData can at most be %d bytes", 50000));
        }
        this.userData = userData;
    }

    public byte[] asByteArray() {
        return this.userData;
    }

    public void clear() {
        Arrays.fill(this.userData, (byte)0);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.userData});
    }

    public boolean equals(Object obj) {
        if (obj instanceof UserData) {
            UserData other = (UserData)obj;
            return Arrays.equals(this.userData, other.asByteArray());
        }
        return false;
    }

    @Override
    public void bestEffortShred() {
        BestEffortShredder.shred(this.userData);
    }
}

