/*
 * Decompiled with CFR 0.152.
 */
package com.schibsted.security.strongbox.sdk.types.arn;

import com.google.common.base.Objects;
import com.schibsted.security.strongbox.sdk.exceptions.InvalidResourceName;
import com.schibsted.security.strongbox.sdk.types.Region;
import java.util.Optional;

public class ARN {
    protected final String partition;
    protected final String service;
    protected final long account;
    protected final Optional<Region> region;
    protected final Optional<String> resourceType;
    protected final String resource;
    protected final int numParts;
    protected final String arn;

    public ARN(String arn) {
        this.arn = arn;
        String[] parts = arn.split(":");
        this.numParts = parts.length;
        if (this.numParts == 7) {
            this.resourceType = Optional.of(parts[5]);
            this.resource = parts[6];
        } else if (this.numParts == 6) {
            if (parts[5].contains("/")) {
                int divider = parts[5].indexOf("/");
                this.resourceType = Optional.of(parts[5].substring(0, divider));
                this.resource = parts[5].substring(divider + 1);
            } else {
                this.resource = parts[5];
                this.resourceType = Optional.empty();
            }
        } else {
            throw new InvalidResourceName(arn, "An ARN should have 6 or 7 parts");
        }
        if (!parts[0].equals("arn")) {
            throw new InvalidResourceName(arn, "An ARN should start with 'arn'");
        }
        this.partition = parts[1];
        this.service = parts[2];
        this.region = !parts[3].isEmpty() ? Optional.of(Region.fromName(parts[3])) : Optional.empty();
        this.account = Long.valueOf(parts[4]);
    }

    public String toArn() {
        return this.arn;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.arn});
    }

    public boolean equals(Object obj) {
        if (obj instanceof ARN) {
            ARN other = (ARN)obj;
            return Objects.equal((Object)this.arn, (Object)other.arn);
        }
        return false;
    }
}

