/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.DBCollection;
import com.sequoiadb.base.SDBMessage;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.base.SequoiadbConstants;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.net.IConnection;
import com.sequoiadb.util.SDBMessageHelper;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class CollectionSpace {
    private String name;
    private Sequoiadb sequoiadb;

    public String getName() {
        return this.name;
    }

    public Sequoiadb getSequoiadb() {
        return this.sequoiadb;
    }

    CollectionSpace(Sequoiadb sequoiadb, String name) {
        this.name = name;
        this.sequoiadb = sequoiadb;
    }

    public DBCollection getCollection(String collectionName) throws BaseException {
        if (this.isCollectionExist(collectionName)) {
            return new DBCollection(this.sequoiadb, this, collectionName.trim());
        }
        return null;
    }

    public boolean isCollectionExist(String colName) throws BaseException {
        String commandString = "$test collection";
        String collectionFullName = this.name + "." + colName;
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)collectionFullName);
        SDBMessage rtn = this.adminCommand(commandString, obj, null, null, null);
        int flags = rtn.getFlags();
        if (flags == 0) {
            return true;
        }
        if (flags == new BaseException("SDB_DMS_NOTEXIST", new Object[0]).getErrorCode()) {
            return false;
        }
        throw new BaseException(flags, new Object[0]);
    }

    public List<String> getCollectionNames() throws BaseException {
        ArrayList<String> colNames = this.sequoiadb.getCollectionNames();
        if (colNames == null || colNames.size() == 0) {
            return null;
        }
        ArrayList<String> collectionNames = new ArrayList<String>();
        for (String col : colNames) {
            if (!col.startsWith(this.name + ".")) continue;
            collectionNames.add(col);
        }
        return collectionNames;
    }

    public DBCollection createCollection(String collectionName) throws BaseException {
        if (this.isCollectionExist(collectionName)) {
            throw new BaseException("SDB_DMS_EXIST", collectionName);
        }
        String commandString = "$create collection";
        String collectionFullName = this.name + "." + collectionName;
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)collectionFullName);
        SDBMessage rtn = this.adminCommand(commandString, obj, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, collectionName);
        }
        return this.getCollection(collectionName);
    }

    public DBCollection createCollection(String collectionName, BSONObject options) {
        SDBMessage rtn;
        int flags;
        String commandString = "$create collection";
        String collectionFullName = this.name + "." + collectionName;
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)collectionFullName);
        if (options != null) {
            obj.putAll(options);
        }
        if ((flags = (rtn = this.adminCommand(commandString, obj, null, null, null)).getFlags()) != 0) {
            throw new BaseException(flags, collectionFullName, options);
        }
        return this.getCollection(collectionName);
    }

    public void drop() throws BaseException {
        this.sequoiadb.dropCollectionSpace(this.name);
    }

    public void dropCollection(String collectionName) throws BaseException {
        if (!this.isCollectionExist(collectionName)) {
            throw new BaseException("SDB_DMS_NOTEXIST", collectionName);
        }
        String commandString = "$drop collection";
        String collectionFullName = this.name + "." + collectionName;
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)collectionFullName);
        SDBMessage rtn = this.adminCommand(commandString, obj, null, null, null);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, collectionName);
        }
    }

    private SDBMessage adminCommand(String commandString, BSONObject arg1, BSONObject arg2, BSONObject arg3, BSONObject arg4) throws BaseException {
        IConnection connection = this.sequoiadb.getConnection();
        BasicBSONObject dummyObj = new BasicBSONObject();
        SDBMessage sdbMessage = new SDBMessage();
        sdbMessage.setMatcher(arg1);
        sdbMessage.setCollectionFullName(commandString);
        sdbMessage.setFlags(0);
        sdbMessage.setNodeID(SequoiadbConstants.ZERO_NODEID);
        sdbMessage.setRequestID(this.sequoiadb.getNextRequstID());
        sdbMessage.setSkipRowsCount(-1L);
        sdbMessage.setReturnRowsCount(-1L);
        sdbMessage.setSelector(dummyObj);
        sdbMessage.setOrderBy(dummyObj);
        sdbMessage.setHint(dummyObj);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.OP_QUERY);
        byte[] request = SDBMessageHelper.buildQueryRequest(sdbMessage, this.sequoiadb.endianConvert);
        connection.sendMessage(request);
        ByteBuffer byteBuffer = connection.receiveMessage(this.sequoiadb.endianConvert);
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        SDBMessageHelper.checkMessage(sdbMessage, rtnSDBMessage);
        return rtnSDBMessage;
    }
}

