/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.CollectionSpace;
import com.sequoiadb.base.DBCursor;
import com.sequoiadb.base.DBLob;
import com.sequoiadb.base.DBLobConcrete;
import com.sequoiadb.base.DBQuery;
import com.sequoiadb.base.SDBMessage;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.base.SequoiadbConstants;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.net.IConnection;
import com.sequoiadb.util.SDBMessageHelper;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.mina.core.buffer.IoBuffer;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.ObjectId;
import org.bson.util.JSON;

public class DBCollection {
    private String name;
    private Sequoiadb sequoiadb;
    private CollectionSpace collectionSpace;
    private IConnection connection;
    private String csName;
    private String collectionFullName;
    private Set<String> mainKeys;
    private IoBuffer insert_buffer;
    private static final int DEF_BUFFER_LENGTH = 65536;
    private static final int DEF_BULK_BUFFER_LENGTH = 0x200000;
    public static final int FLG_INSERT_CONTONDUP = 1;

    public IConnection getConnection() {
        return this.connection;
    }

    public void setConnection(IConnection connection) {
        this.connection = connection;
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.collectionFullName;
    }

    public String getCSName() {
        return this.csName;
    }

    public Sequoiadb getSequoiadb() {
        return this.sequoiadb;
    }

    public CollectionSpace getCollectionSpace() {
        return this.collectionSpace;
    }

    public void setMainKeys(String[] keys) throws BaseException {
        if (keys == null) {
            throw new BaseException("SDB_INVALIDARG", (Object[])keys);
        }
        this.mainKeys.clear();
        if (keys.length == 0) {
            return;
        }
        for (String k : keys) {
            this.mainKeys.add(k);
        }
    }

    DBCollection(Sequoiadb sequoiadb, CollectionSpace cs, String name) {
        this.name = name;
        this.sequoiadb = sequoiadb;
        this.collectionSpace = cs;
        this.csName = cs.getName();
        this.collectionFullName = this.csName + "." + name;
        this.connection = sequoiadb.getConnection();
        this.insert_buffer = null;
        this.mainKeys = new HashSet<String>();
    }

    public Object insert(BSONObject insertor) throws BaseException {
        if (insertor == null) {
            throw new BaseException("SDB_INVALIDARG", new Object[0]);
        }
        if (this.insert_buffer == null) {
            this.insert_buffer = IoBuffer.allocate(65536);
            this.insert_buffer.setAutoExpand(true);
            if (this.sequoiadb.endianConvert) {
                this.insert_buffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.insert_buffer.order(ByteOrder.BIG_ENDIAN);
            }
        } else {
            this.insert_buffer.clear();
        }
        Object tmp = insertor.get("_id");
        if (tmp == null) {
            ObjectId objId = ObjectId.get();
            insertor.put("_id", objId);
            tmp = objId;
        }
        int message_length = SDBMessageHelper.buildInsertRequest(this.insert_buffer, this.sequoiadb.getNextRequstID(), this.collectionFullName, insertor);
        this.connection.sendMessage(this.insert_buffer.array(), message_length);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.sequoiadb.endianConvert);
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        if (rtnSDBMessage.getOperationCode() != SequoiadbConstants.Operation.OP_INSERT_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{rtnSDBMessage.getOperationCode()});
        }
        int flags = rtnSDBMessage.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, insertor.toString());
        }
        return tmp;
    }

    public Object insert(String insertor) throws BaseException {
        BSONObject in = null;
        if (insertor != null) {
            in = (BSONObject)JSON.parse(insertor);
        }
        return this.insert(in);
    }

    public <T> void save(T type) throws BaseException {
        BSONObject obj;
        try {
            obj = BasicBSONObject.typeToBson(type);
        }
        catch (Exception e) {
            throw new BaseException("SDB_INVALIDARG", type, e);
        }
        BasicBSONObject matcher = new BasicBSONObject();
        BasicBSONObject modifer = new BasicBSONObject();
        if (this.mainKeys.isEmpty()) {
            Object id = obj.get("_id");
            if (id == null || id instanceof ObjectId && ((ObjectId)id).isNew()) {
                if (id != null && id instanceof ObjectId) {
                    ((ObjectId)id).notNew();
                }
                this.insert(obj);
            } else {
                matcher.put("_id", id);
                modifer.put("$set", (Object)obj);
                this.upsert(matcher, modifer, null);
            }
        } else {
            for (String key : this.mainKeys) {
                if (obj.containsField(key)) {
                    matcher.put(key, obj.get(key));
                    continue;
                }
                matcher.put(key, (Object)null);
            }
            modifer.put("$set", (Object)obj);
            this.upsert(matcher, modifer, null);
        }
    }

    public <T> void save(List<T> type) throws BaseException {
        if (type == null || type.size() == 0) {
            throw new BaseException("SDB_INVALIDARG", type);
        }
        ArrayList<BSONObject> objs = new ArrayList<BSONObject>();
        try {
            Iterator<T> it = type.iterator();
            while (it != null && it.hasNext()) {
                objs.add(BasicBSONObject.typeToBson(it.next()));
            }
        }
        catch (Exception e) {
            throw new BaseException("SDB_INVALIDARG", type, e);
        }
        BasicBSONObject matcher = new BasicBSONObject();
        BasicBSONObject modifer = new BasicBSONObject();
        BSONObject obj = null;
        Iterator ite = objs.iterator();
        if (this.mainKeys.isEmpty()) {
            while (ite != null && ite.hasNext()) {
                obj = (BSONObject)ite.next();
                Object id = obj.get("_id");
                if (id == null || id instanceof ObjectId && ((ObjectId)id).isNew()) {
                    if (id != null && id instanceof ObjectId) {
                        ((ObjectId)id).notNew();
                    }
                    this.insert(obj);
                    continue;
                }
                matcher.put("_id", id);
                modifer.put("$set", (Object)obj);
                this.upsert(matcher, modifer, null);
            }
        } else {
            while (ite != null && ite.hasNext()) {
                obj = (BSONObject)ite.next();
                for (String key : this.mainKeys) {
                    if (obj.containsField(key)) {
                        matcher.put(key, obj.get(key));
                        continue;
                    }
                    matcher.put(key, (Object)null);
                }
                modifer.put("$set", (Object)obj);
                this.upsert(matcher, modifer, null);
            }
        }
    }

    public void bulkInsert(List<BSONObject> insertor, int flag) throws BaseException {
        if (flag != 0 && flag != 1) {
            throw new BaseException("SDB_INVALIDARG", new Object[0]);
        }
        if (insertor == null || insertor.size() == 0) {
            throw new BaseException("SDB_INVALIDARG", new Object[0]);
        }
        if (this.insert_buffer == null) {
            this.insert_buffer = IoBuffer.allocate(0x200000);
            this.insert_buffer.setAutoExpand(true);
            if (this.sequoiadb.endianConvert) {
                this.insert_buffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.insert_buffer.order(ByteOrder.BIG_ENDIAN);
            }
        } else {
            this.insert_buffer.clear();
        }
        int messageLength = SDBMessageHelper.buildBulkInsertRequest(this.insert_buffer, this.sequoiadb.getNextRequstID(), this.collectionFullName, insertor, flag);
        this.connection.sendMessage(this.insert_buffer.array(), messageLength);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.sequoiadb.endianConvert);
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        if (rtnSDBMessage.getOperationCode() != SequoiadbConstants.Operation.OP_INSERT_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{rtnSDBMessage.getOperationCode()});
        }
        int flags = rtnSDBMessage.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, insertor);
        }
    }

    public void delete(BSONObject matcher) throws BaseException {
        this.delete(matcher, null);
    }

    public void delete(String matcher) throws BaseException {
        BSONObject ma = null;
        if (matcher != null) {
            ma = (BSONObject)JSON.parse(matcher);
        }
        this.delete(ma, null);
    }

    public void delete(String matcher, String hint) throws BaseException {
        BSONObject ma = null;
        BSONObject hi = null;
        if (matcher != null) {
            ma = (BSONObject)JSON.parse(matcher);
        }
        if (hint != null) {
            hi = (BSONObject)JSON.parse(hint);
        }
        this.delete(ma, hi);
    }

    public void delete(BSONObject matcher, BSONObject hint) throws BaseException {
        BasicBSONObject dummy = new BasicBSONObject();
        if (matcher == null) {
            matcher = dummy;
        }
        if (hint == null) {
            hint = dummy;
        }
        SDBMessage sdbMessage = new SDBMessage();
        sdbMessage.setVersion(1);
        sdbMessage.setW((short)0);
        sdbMessage.setPadding((short)0);
        sdbMessage.setFlags(0);
        sdbMessage.setNodeID(SequoiadbConstants.ZERO_NODEID);
        sdbMessage.setCollectionFullName(this.collectionFullName);
        sdbMessage.setRequestID(this.sequoiadb.getNextRequstID());
        sdbMessage.setMatcher(matcher);
        sdbMessage.setHint(hint);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.OP_DELETE);
        byte[] request = SDBMessageHelper.buildDeleteRequest(sdbMessage, this.sequoiadb.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.sequoiadb.endianConvert);
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        SDBMessageHelper.checkMessage(sdbMessage, rtnSDBMessage);
        int flags = rtnSDBMessage.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, matcher, hint);
        }
    }

    public void update(DBQuery query) throws BaseException {
        this._update(0, query.getMatcher(), query.getModifier(), query.getHint());
    }

    public void update(BSONObject matcher, BSONObject modifier, BSONObject hint) throws BaseException {
        this._update(0, matcher, modifier, hint);
    }

    public void update(String matcher, String modifier, String hint) throws BaseException {
        BSONObject ma = null;
        BSONObject mo = null;
        BSONObject hi = null;
        if (matcher != null) {
            ma = (BSONObject)JSON.parse(matcher);
        }
        if (modifier != null) {
            mo = (BSONObject)JSON.parse(modifier);
        }
        if (hint != null) {
            hi = (BSONObject)JSON.parse(hint);
        }
        this._update(0, ma, mo, hi);
    }

    public void upsert(BSONObject matcher, BSONObject modifier, BSONObject hint) throws BaseException {
        this._update(1, matcher, modifier, hint);
    }

    public DBCursor explain(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, long skipRows, long returnRows, int flag, BSONObject options) throws BaseException {
        flag |= 0x400;
        BasicBSONObject innerHint = new BasicBSONObject();
        if (null != hint) {
            innerHint.put("Hint", (Object)hint);
        }
        if (null != options) {
            innerHint.put("Options", (Object)options);
        }
        return this.query(matcher, selector, orderBy, innerHint, skipRows, returnRows, flag);
    }

    public DBCursor query() throws BaseException {
        return this.query("", "", "", "", 0L, -1L);
    }

    public DBCursor query(DBQuery matcher) throws BaseException {
        if (matcher == null) {
            return this.query();
        }
        return this.query(matcher.getMatcher(), matcher.getSelector(), matcher.getOrderBy(), matcher.getHint(), matcher.getSkipRowsCount(), matcher.getReturnRowsCount(), matcher.getFlag());
    }

    public DBCursor query(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint) throws BaseException {
        return this.query(matcher, selector, orderBy, hint, 0L, -1L, 0);
    }

    public DBCursor query(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, int flag) throws BaseException {
        return this.query(matcher, selector, orderBy, hint, 0L, -1L, flag);
    }

    public DBCursor query(String matcher, String selector, String orderBy, String hint) throws BaseException {
        return this.query(matcher, selector, orderBy, hint, 0);
    }

    public DBCursor query(String matcher, String selector, String orderBy, String hint, int flag) throws BaseException {
        BSONObject ma = null;
        BSONObject se = null;
        BSONObject or = null;
        BSONObject hi = null;
        if (matcher != null) {
            ma = (BSONObject)JSON.parse(matcher);
        }
        if (selector != null) {
            se = (BSONObject)JSON.parse(selector);
        }
        if (orderBy != null && !orderBy.equals("")) {
            or = (BSONObject)JSON.parse(orderBy);
        }
        if (hint != null) {
            hi = (BSONObject)JSON.parse(hint);
        }
        return this.query(ma, se, or, hi, 0L, -1L, flag);
    }

    public DBCursor query(String matcher, String selector, String orderBy, String hint, long skipRows, long returnRows) throws BaseException {
        BSONObject ma = null;
        BSONObject se = null;
        BSONObject or = null;
        BSONObject hi = null;
        if (matcher != null) {
            ma = (BSONObject)JSON.parse(matcher);
        }
        if (selector != null) {
            se = (BSONObject)JSON.parse(selector);
        }
        if (orderBy != null) {
            or = (BSONObject)JSON.parse(orderBy);
        }
        if (hint != null) {
            hi = (BSONObject)JSON.parse(hint);
        }
        return this.query(ma, se, or, hi, skipRows, returnRows, 0);
    }

    public DBCursor query(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, long skipRows, long returnRows) throws BaseException {
        return this.query(matcher, selector, orderBy, hint, skipRows, returnRows, 0);
    }

    public DBCursor query(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, long skipRows, long returnRows, int flag) throws BaseException {
        BasicBSONObject dummy = new BasicBSONObject();
        if (matcher == null) {
            matcher = dummy;
        }
        if (selector == null) {
            selector = dummy;
        }
        if (orderBy == null) {
            orderBy = dummy;
        }
        if (hint == null) {
            hint = dummy;
        }
        if (returnRows == 0L) {
            returnRows = -1L;
        }
        if (returnRows == 1L) {
            flag |= 0x200;
        }
        SDBMessage rtnSDBMessage = this.adminCommand(this.collectionFullName, matcher, selector, orderBy, hint, skipRows, returnRows, flag);
        DBCursor cursor = null;
        int flags = rtnSDBMessage.getFlags();
        if (flags != 0) {
            if (flags == SequoiadbConstants.SDB_DMS_EOC) {
                return null;
            }
            throw new BaseException(flags, matcher, selector, orderBy, hint, skipRows, returnRows);
        }
        cursor = new DBCursor(rtnSDBMessage, this);
        return cursor;
    }

    public BSONObject queryOne(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, int flag) throws BaseException {
        flag |= 0x200;
        DBCursor cursor = null;
        cursor = this.query(matcher, selector, orderBy, hint, 0L, 1L, flag);
        return cursor.getNext();
    }

    public BSONObject queryOne() throws BaseException {
        BasicBSONObject empty = new BasicBSONObject();
        return this.queryOne(empty, empty, empty, empty, 0);
    }

    public DBCursor getIndexes() throws BaseException {
        String commandString = "$get indexes";
        BasicBSONObject dummyObj = new BasicBSONObject();
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Collection", (Object)this.collectionFullName);
        SDBMessage rtn = this.adminCommand(commandString, dummyObj, dummyObj, dummyObj, obj, -1L, -1L, 0);
        int flags = rtn.getFlags();
        DBCursor cursor = null;
        if (flags != 0) {
            if (flags == SequoiadbConstants.SDB_DMS_EOC) {
                return cursor;
            }
            throw new BaseException(flags, new Object[0]);
        }
        cursor = new DBCursor(rtn, this.sequoiadb);
        return cursor;
    }

    public DBCursor getIndex(String name) throws BaseException {
        if (name == null) {
            return this.getIndexes();
        }
        String commandString = "$get indexes";
        BasicBSONObject dummyObj = new BasicBSONObject();
        BasicBSONObject condition = new BasicBSONObject();
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Collection", (Object)this.collectionFullName);
        condition.put("IndexDef.name", (Object)name);
        SDBMessage rtn = this.adminCommand(commandString, condition, dummyObj, dummyObj, obj, -1L, -1L, 0);
        int flags = rtn.getFlags();
        if (flags != 0) {
            if (flags == SequoiadbConstants.SDB_DMS_EOC) {
                return null;
            }
            throw new BaseException(flags, new Object[0]);
        }
        return new DBCursor(rtn, this);
    }

    public void createIndex(String name, BSONObject key, boolean isUnique, boolean enforced) throws BaseException {
        String commandString = "$create index";
        BasicBSONObject obj = new BasicBSONObject();
        BasicBSONObject dummyObj = new BasicBSONObject();
        BasicBSONObject createObj = new BasicBSONObject();
        obj.put("key", (Object)key);
        obj.put("name", (Object)name);
        obj.put("unique", (Object)isUnique);
        obj.put("enforced", (Object)enforced);
        createObj.put("Collection", (Object)this.collectionFullName);
        createObj.put("Index", (Object)obj);
        SDBMessage rtn = this.adminCommand(commandString, createObj, dummyObj, dummyObj, dummyObj, -1L, -1L, 0);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, name, key, isUnique);
        }
    }

    public void createIndex(String name, String key, boolean isUnique, boolean enforced) throws BaseException {
        BSONObject k = null;
        if (key != null) {
            k = (BSONObject)JSON.parse(key);
        }
        this.createIndex(name, k, isUnique, enforced);
    }

    public void dropIndex(String name) throws BaseException {
        String commandString = "$drop index";
        BasicBSONObject dummyObj = new BasicBSONObject();
        BasicBSONObject dropObj = new BasicBSONObject();
        BasicBSONObject index = new BasicBSONObject();
        index.put("", (Object)name);
        dropObj.put("Collection", (Object)this.collectionFullName);
        dropObj.put("Index", (Object)index);
        SDBMessage rtn = this.adminCommand(commandString, dropObj, dummyObj, dummyObj, dummyObj, -1L, -1L, 0);
        int flags = rtn.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, name);
        }
    }

    public long getCount() throws BaseException {
        return this.getCount("");
    }

    public long getCount(String matcher) throws BaseException {
        BSONObject con = null;
        if (matcher != null) {
            con = (BSONObject)JSON.parse(matcher);
        }
        return this.getCount(con);
    }

    public long getCount(BSONObject matcher) throws BaseException {
        String commandString = "$get count";
        BasicBSONObject dummyObj = new BasicBSONObject();
        BasicBSONObject newobj = new BasicBSONObject();
        newobj.put("Collection", (Object)this.collectionFullName);
        SDBMessage rtnSDBMessage = this.adminCommand(commandString, matcher, dummyObj, dummyObj, newobj, -1L, -1L, 0);
        int flags = rtnSDBMessage.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, matcher);
        }
        List<BSONObject> rtn = this.getMoreCommand(rtnSDBMessage);
        return Long.valueOf(rtn.get(0).get("Total").toString());
    }

    public long getCount(BSONObject condition, BSONObject hint) throws BaseException {
        SDBMessage rtnSDBMessage;
        int flags;
        String commandString = "$get count";
        BasicBSONObject dummyObj = new BasicBSONObject();
        BasicBSONObject newobj = new BasicBSONObject();
        newobj.put("Collection", (Object)this.collectionFullName);
        if (null != hint) {
            try {
                newobj.put("Hint", (Object)hint);
            }
            catch (Exception e) {
                throw new BaseException("SDB_SYS", new Object[]{e});
            }
        }
        if ((flags = (rtnSDBMessage = this.adminCommand(commandString, condition, dummyObj, dummyObj, newobj, -1L, -1L, 0)).getFlags()) != 0) {
            throw new BaseException(flags, condition, hint);
        }
        List<BSONObject> rtn = this.getMoreCommand(rtnSDBMessage);
        return Long.valueOf(rtn.get(0).get("Total").toString());
    }

    public void split(String sourceGroupName, String destGroupName, BSONObject splitCondition, BSONObject splitEndCondition) throws BaseException {
        BasicBSONObject dummy;
        String commandString;
        SDBMessage rtnSDBMessage;
        int flags;
        if (null == sourceGroupName || sourceGroupName.equals("") || null == destGroupName || destGroupName.equals("") || null == splitCondition) {
            throw new BaseException("SDB_INVALIDARG", sourceGroupName, destGroupName, splitCondition);
        }
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)this.collectionFullName);
        obj.put("Source", (Object)sourceGroupName);
        obj.put("Target", (Object)destGroupName);
        obj.put("SplitQuery", (Object)splitCondition);
        if (null != splitEndCondition) {
            obj.put("SplitEndQuery", (Object)splitEndCondition);
        }
        if ((flags = (rtnSDBMessage = this.adminCommand(commandString = "$split", obj, dummy = new BasicBSONObject(), dummy, dummy, -1L, -1L, 0)).getFlags()) != 0) {
            throw new BaseException(flags, sourceGroupName, destGroupName, splitCondition, splitEndCondition);
        }
    }

    public void split(String sourceGroupName, String destGroupName, double percent) throws BaseException {
        if (null == sourceGroupName || sourceGroupName.equals("") || null == destGroupName || destGroupName.equals("") || percent <= 0.0 || percent > 100.0) {
            throw new BaseException("SDB_INVALIDARG", sourceGroupName, destGroupName, percent);
        }
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)this.collectionFullName);
        obj.put("Source", (Object)sourceGroupName);
        obj.put("Target", (Object)destGroupName);
        obj.put("SplitPercent", (Object)percent);
        String commandString = "$split";
        BasicBSONObject dummy = new BasicBSONObject();
        SDBMessage rtnSDBMessage = this.adminCommand(commandString, obj, dummy, dummy, dummy, -1L, -1L, 0);
        int flags = rtnSDBMessage.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, sourceGroupName, destGroupName, percent);
        }
    }

    public long splitAsync(String sourceGroupName, String destGroupName, BSONObject splitCondition, BSONObject splitEndCondition) throws BaseException {
        if (null == sourceGroupName || sourceGroupName.equals("") || null == destGroupName || destGroupName.equals("") || null == splitCondition) {
            throw new BaseException("SDB_INVALIDARG", sourceGroupName, destGroupName, splitCondition, splitEndCondition);
        }
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)this.collectionFullName);
        obj.put("Source", (Object)sourceGroupName);
        obj.put("Target", (Object)destGroupName);
        obj.put("SplitQuery", (Object)splitCondition);
        if (null != splitEndCondition) {
            obj.put("SplitEndQuery", (Object)splitEndCondition);
        }
        obj.put("Async", (Object)true);
        String commandString = "$split";
        BasicBSONObject dummy = new BasicBSONObject();
        SDBMessage rtnSDBMessage = this.adminCommand(commandString, obj, dummy, dummy, dummy, -1L, -1L, 0);
        int flags = rtnSDBMessage.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, sourceGroupName, destGroupName, splitCondition, splitEndCondition);
        }
        DBCursor cursor = new DBCursor(rtnSDBMessage, this);
        if (!cursor.hasNext()) {
            throw new BaseException("SDB_CAT_TASK_NOTFOUND", new Object[0]);
        }
        BSONObject result = cursor.getNext();
        boolean flag = result.containsField("TaskID");
        if (!flag) {
            throw new BaseException("SDB_CAT_TASK_NOTFOUND", new Object[0]);
        }
        long taskid = (Long)result.get("TaskID");
        return taskid;
    }

    public long splitAsync(String sourceGroupName, String destGroupName, double percent) throws BaseException {
        if (null == sourceGroupName || sourceGroupName.equals("") || null == destGroupName || destGroupName.equals("") || percent <= 0.0 || percent > 100.0) {
            throw new BaseException("SDB_INVALIDARG", sourceGroupName, destGroupName, percent);
        }
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)this.collectionFullName);
        obj.put("Source", (Object)sourceGroupName);
        obj.put("Target", (Object)destGroupName);
        obj.put("SplitPercent", (Object)percent);
        obj.put("Async", (Object)true);
        String commandString = "$split";
        BasicBSONObject dummy = new BasicBSONObject();
        SDBMessage rtnSDBMessage = this.adminCommand(commandString, obj, dummy, dummy, dummy, 0L, -1L, 0);
        int flags = rtnSDBMessage.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, sourceGroupName, destGroupName, percent);
        }
        DBCursor cursor = new DBCursor(rtnSDBMessage, this);
        if (!cursor.hasNext()) {
            throw new BaseException("SDB_CAT_TASK_NOTFOUND", new Object[0]);
        }
        BSONObject result = cursor.getNext();
        boolean flag = result.containsField("TaskID");
        if (!flag) {
            throw new BaseException("SDB_CAT_TASK_NOTFOUND", new Object[0]);
        }
        long taskid = (Long)result.get("TaskID");
        return taskid;
    }

    public DBCursor aggregate(List<BSONObject> obj) throws BaseException {
        if (obj == null || obj.size() == 0) {
            throw new BaseException("SDB_INVALIDARG", new Object[0]);
        }
        if (this.insert_buffer == null) {
            this.insert_buffer = IoBuffer.allocate(65536);
            this.insert_buffer.setAutoExpand(true);
            if (this.sequoiadb.endianConvert) {
                this.insert_buffer.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                this.insert_buffer.order(ByteOrder.BIG_ENDIAN);
            }
        } else {
            this.insert_buffer.clear();
        }
        int messageLength = SDBMessageHelper.buildAggrRequest(this.insert_buffer, this.sequoiadb.getNextRequstID(), this.collectionFullName, obj);
        this.connection.sendMessage(this.insert_buffer.array(), messageLength);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.sequoiadb.endianConvert);
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        if (rtnSDBMessage.getOperationCode() != SequoiadbConstants.Operation.OP_AGGREGATE_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{rtnSDBMessage.getOperationCode()});
        }
        DBCursor cursor = null;
        int flags = rtnSDBMessage.getFlags();
        if (flags != 0) {
            if (flags == SequoiadbConstants.SDB_DMS_EOC) {
                return cursor;
            }
            throw new BaseException(flags, obj);
        }
        cursor = new DBCursor(rtnSDBMessage, this);
        return cursor;
    }

    public DBCursor getQueryMeta(BSONObject query, BSONObject orderBy, BSONObject hint, long skipRows, long returnRows, int flag) throws BaseException {
        BasicBSONObject dummy = new BasicBSONObject();
        if (query == null) {
            query = dummy;
        }
        if (orderBy == null) {
            orderBy = dummy;
        }
        if (hint == null) {
            hint = dummy;
        }
        if (returnRows == 0L) {
            returnRows = -1L;
        }
        BasicBSONObject hint1 = new BasicBSONObject();
        hint1.put("Collection", (Object)this.collectionFullName);
        String command = "$get querymeta";
        SDBMessage rtnSDBMessage = this.adminCommand(command, query, hint, orderBy, hint1, skipRows, returnRows, flag);
        DBCursor cursor = null;
        int flags = rtnSDBMessage.getFlags();
        if (flags != 0) {
            if (flags == SequoiadbConstants.SDB_DMS_EOC) {
                return cursor;
            }
            throw new BaseException(flags, query, hint, orderBy, hint1, skipRows, returnRows);
        }
        cursor = new DBCursor(rtnSDBMessage, this);
        return cursor;
    }

    public void attachCollection(String subClFullName, BSONObject options) throws BaseException {
        if (null == subClFullName || subClFullName.equals("") || null == options || null == this.collectionFullName || this.collectionFullName.equals("")) {
            throw new BaseException("SDB_INVALIDARG", subClFullName, options, this.collectionFullName);
        }
        String command = "$link collection";
        BasicBSONObject newobj = new BasicBSONObject();
        newobj.put("Name", (Object)this.collectionFullName);
        newobj.put("SubCLName", (Object)subClFullName);
        for (String key : options.keySet()) {
            newobj.put(key, options.get(key));
        }
        SDBMessage rtnSDBMessage = this.adminCommand(command, newobj, null, null, null, 0L, -1L, 0);
        int flags = rtnSDBMessage.getFlags();
        if (0 != flags) {
            throw new BaseException(flags, subClFullName, options);
        }
    }

    public void detachCollection(String subClFullName) throws BaseException {
        if (null == subClFullName || subClFullName.equals("") || null == this.collectionFullName || this.collectionFullName.equals("")) {
            throw new BaseException("SDB_INVALIDARG", subClFullName);
        }
        String command = "$unlink collection";
        BasicBSONObject newobj = new BasicBSONObject();
        newobj.put("Name", (Object)this.collectionFullName);
        newobj.put("SubCLName", (Object)subClFullName);
        SDBMessage rtnSDBMessage = this.adminCommand(command, newobj, null, null, null, 0L, -1L, 0);
        int flags = rtnSDBMessage.getFlags();
        if (0 != flags) {
            throw new BaseException(flags, subClFullName);
        }
    }

    public void alterCollection(BSONObject options) throws BaseException {
        if (null == options) {
            throw new BaseException("SDB_INVALIDARG", options);
        }
        String command = "$alter collection";
        BasicBSONObject newobj = new BasicBSONObject();
        newobj.put("Name", (Object)this.collectionFullName);
        newobj.put("Options", (Object)options);
        SDBMessage rtnSDBMessage = this.adminCommand(command, newobj, null, null, null, 0L, -1L, 0);
        int flags = rtnSDBMessage.getFlags();
        if (0 != flags) {
            throw new BaseException(flags, options);
        }
    }

    private SDBMessage adminCommand(String commandString, BSONObject query, BSONObject selector, BSONObject orderBy, BSONObject hint, long skipRows, long returnRows, int flag) throws BaseException {
        SDBMessage sdbMessage = new SDBMessage();
        BasicBSONObject dummy = new BasicBSONObject();
        if (query == null) {
            query = dummy;
        }
        if (selector == null) {
            selector = dummy;
        }
        if (orderBy == null) {
            orderBy = dummy;
        }
        if (hint == null) {
            hint = dummy;
        }
        sdbMessage.setCollectionFullName(commandString);
        sdbMessage.setVersion(1);
        sdbMessage.setW((short)0);
        sdbMessage.setPadding((short)0);
        sdbMessage.setFlags(flag);
        sdbMessage.setNodeID(SequoiadbConstants.ZERO_NODEID);
        sdbMessage.setRequestID(this.sequoiadb.getNextRequstID());
        sdbMessage.setSkipRowsCount(skipRows);
        sdbMessage.setReturnRowsCount(returnRows);
        sdbMessage.setMatcher(query);
        sdbMessage.setSelector(selector);
        sdbMessage.setOrderBy(orderBy);
        sdbMessage.setHint(hint);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.OP_QUERY);
        byte[] request = SDBMessageHelper.buildQueryRequest(sdbMessage, this.sequoiadb.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.sequoiadb.endianConvert);
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        SDBMessageHelper.checkMessage(sdbMessage, rtnSDBMessage);
        return rtnSDBMessage;
    }

    private List<BSONObject> getMoreCommand(SDBMessage rtnSDBMessage) throws BaseException {
        long reqId = rtnSDBMessage.getRequestID();
        List<Long> contextIds = rtnSDBMessage.getContextIDList();
        ArrayList<BSONObject> fullList = new ArrayList<BSONObject>();
        boolean hasMore = true;
        while (hasMore) {
            SDBMessage sdbMessage = new SDBMessage();
            sdbMessage.setNodeID(SequoiadbConstants.ZERO_NODEID);
            sdbMessage.setContextIDList(contextIds);
            sdbMessage.setRequestID(reqId);
            sdbMessage.setNumReturned(-1);
            sdbMessage.setOperationCode(SequoiadbConstants.Operation.OP_GETMORE);
            byte[] request = SDBMessageHelper.buildGetMoreRequest(sdbMessage, this.sequoiadb.endianConvert);
            this.connection.sendMessage(request);
            ByteBuffer byteBuffer = this.connection.receiveMessage(this.sequoiadb.endianConvert);
            rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
            SDBMessageHelper.checkMessage(sdbMessage, rtnSDBMessage);
            int flags = rtnSDBMessage.getFlags();
            if (flags != 0) {
                if (flags == SequoiadbConstants.SDB_DMS_EOC) {
                    hasMore = false;
                    continue;
                }
                throw new BaseException(flags, new Object[0]);
            }
            reqId = rtnSDBMessage.getRequestID();
            List<BSONObject> objList = rtnSDBMessage.getObjectList();
            fullList.addAll(objList);
        }
        return fullList;
    }

    private void _update(int flag, BSONObject matcher, BSONObject modifier, BSONObject hint) throws BaseException {
        BasicBSONObject dummy = new BasicBSONObject();
        if (matcher == null) {
            matcher = dummy;
        }
        if (modifier == null) {
            modifier = dummy;
        }
        if (hint == null) {
            hint = dummy;
        }
        SDBMessage sdbMessage = new SDBMessage();
        sdbMessage.setVersion(1);
        sdbMessage.setW((short)0);
        sdbMessage.setPadding((short)0);
        sdbMessage.setFlags(flag);
        sdbMessage.setNodeID(SequoiadbConstants.ZERO_NODEID);
        sdbMessage.setCollectionFullName(this.collectionFullName);
        sdbMessage.setRequestID(this.sequoiadb.getNextRequstID());
        sdbMessage.setMatcher(matcher);
        sdbMessage.setModifier(modifier);
        sdbMessage.setHint(hint);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.OP_UPDATE);
        byte[] request = SDBMessageHelper.buildUpdateRequest(sdbMessage, this.sequoiadb.endianConvert);
        this.connection.sendMessage(request);
        ByteBuffer byteBuffer = this.connection.receiveMessage(this.sequoiadb.endianConvert);
        SDBMessage rtnSDBMessage = SDBMessageHelper.msgExtractReply(byteBuffer);
        SDBMessageHelper.checkMessage(sdbMessage, rtnSDBMessage);
        int flags = rtnSDBMessage.getFlags();
        if (flags != 0) {
            throw new BaseException(flags, matcher, modifier, hint);
        }
    }

    public DBCursor listLobs() throws BaseException {
        String commandString = "$list lobs";
        BasicBSONObject dummyObj = new BasicBSONObject();
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Collection", (Object)this.collectionFullName);
        SDBMessage rtn = this.adminCommand(commandString, obj, dummyObj, dummyObj, dummyObj, -1L, -1L, 0);
        int flags = rtn.getFlags();
        DBCursor cursor = null;
        if (flags != 0) {
            if (flags == SequoiadbConstants.SDB_DMS_EOC) {
                return cursor;
            }
            throw new BaseException(flags, new Object[0]);
        }
        cursor = new DBCursor(rtn, this.sequoiadb);
        return cursor;
    }

    public DBLob createLob() throws BaseException {
        return this.createLob(null);
    }

    public DBLob createLob(ObjectId id) throws BaseException {
        DBLobConcrete lob = new DBLobConcrete(this);
        lob.open(id, 1);
        return lob;
    }

    public DBLob openLob(ObjectId id) throws BaseException {
        DBLobConcrete lob = new DBLobConcrete(this);
        lob.open(id, 4);
        return lob;
    }

    public void removeLob(ObjectId lobID) throws BaseException {
        BasicBSONObject removeObj = new BasicBSONObject();
        removeObj.put("Collection", (Object)this.collectionFullName);
        removeObj.put("Oid", (Object)lobID);
        byte[] request = SDBMessageHelper.generateRemoveLobRequest(removeObj, this.sequoiadb.getNextRequstID(), this.sequoiadb.endianConvert);
        this.connection.sendMessage(request, request.length);
        ByteBuffer res = this.connection.receiveMessage(this.sequoiadb.endianConvert);
        SDBMessage resMessage = SDBMessageHelper.msgExtractLobRemoveReply(res);
        if (resMessage.getOperationCode() != SequoiadbConstants.Operation.MSG_BS_LOB_REMOVE_RES) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", new Object[]{resMessage.getOperationCode()});
        }
        int flag = resMessage.getFlags();
        if (0 != flag) {
            throw new BaseException(flag, removeObj);
        }
    }
}

