/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.net;

import com.sequoiadb.exception.BaseException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class ServerAddress {
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 11810;
    private InetSocketAddress hostAddress;
    private String host;
    private int port;

    public InetSocketAddress getHostAddress() {
        return this.hostAddress;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public ServerAddress() {
        this(new InetSocketAddress(DEFAULT_HOST, 11810));
    }

    public ServerAddress(String host, int port) throws UnknownHostException {
        this.hostAddress = new InetSocketAddress(InetAddress.getByName(host).toString().split("/")[1], port);
        this.host = host;
        this.port = port;
    }

    public ServerAddress(String host) throws UnknownHostException {
        if (host.indexOf(":") > 0) {
            String[] tmp = host.split(":");
            this.host = tmp[0].trim();
            try {
                this.host = InetAddress.getByName(this.host).toString().split("/")[1];
            }
            catch (Exception e) {
                throw new BaseException("SDB_INVALIDARG", new Object[]{e});
            }
            this.port = Integer.parseInt(tmp[1].trim());
        } else {
            this.host = host;
            this.port = 11810;
        }
        this.hostAddress = new InetSocketAddress(this.host, this.port);
    }

    public ServerAddress(InetAddress addr) {
        this(new InetSocketAddress(addr, 11810));
    }

    public ServerAddress(InetAddress addr, int port) {
        this(new InetSocketAddress(addr, port));
    }

    public ServerAddress(InetSocketAddress addr) {
        this.hostAddress = addr;
        this.host = addr.getHostName();
        this.port = addr.getPort();
    }
}

