/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.bson.io.OutputBuffer;

public class ByteOutputBuffer
extends OutputBuffer {
    private ByteBuffer byteBuffer = null;

    public ByteOutputBuffer(ByteBuffer bufferImpl) {
        this.byteBuffer = bufferImpl;
    }

    @Override
    public void write(byte[] b) {
        this.byteBuffer.put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.byteBuffer.put(b, off, len);
    }

    @Override
    public void write(int b) {
        this.byteBuffer.put((byte)(0xFF & b));
    }

    @Override
    public void writeInt(int x) {
        this.byteBuffer.putInt(x);
    }

    private static final int swapInt32(int i) {
        return (i & 0xFF) << 24 | (i >> 8 & 0xFF) << 16 | (i >> 16 & 0xFF) << 8 | i >> 24 & 0xFF;
    }

    @Override
    public void writeIntBE(int x) {
        int xBE = ByteOutputBuffer.swapInt32(x);
        this.byteBuffer.putInt(xBE);
    }

    @Override
    public void writeInt(int pos, int x) {
        int save = this.getPosition();
        this.setPosition(pos);
        this.writeInt(x);
        this.setPosition(save);
    }

    @Override
    public void writeLong(long x) {
        this.byteBuffer.putLong(x);
    }

    @Override
    public void writeDouble(double x) {
        this.byteBuffer.putDouble(x);
    }

    @Override
    public int getPosition() {
        return this.byteBuffer.position();
    }

    @Override
    public void setPosition(int position) {
        this.byteBuffer.position(position);
    }

    @Override
    public void seekEnd() {
        this.byteBuffer.position(this.byteBuffer.capacity());
    }

    @Override
    public void seekStart() {
        this.byteBuffer.position(0);
    }

    @Override
    public int size() {
        return this.byteBuffer.capacity();
    }

    @Override
    public int pipe(OutputStream out) throws IOException {
        out.write(this.byteBuffer.array());
        return this.byteBuffer.capacity();
    }
}

