/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import org.apache.mina.core.buffer.IoBuffer;
import org.bson.io.OutputBuffer;

public class ByteOutputBuffer1
extends OutputBuffer {
    private IoBuffer ioBuffer = null;

    public ByteOutputBuffer1(IoBuffer bufferImpl) {
        this.ioBuffer = bufferImpl;
    }

    @Override
    public void write(byte[] b) {
        this.ioBuffer.put(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.ioBuffer.put(b, off, len);
    }

    @Override
    public void write(int b) {
        this.ioBuffer.put((byte)(0xFF & b));
    }

    @Override
    public void writeInt(int x) {
        this.ioBuffer.putInt(x);
    }

    private static final int swapInt32(int i) {
        return (i & 0xFF) << 24 | (i >> 8 & 0xFF) << 16 | (i >> 16 & 0xFF) << 8 | i >> 24 & 0xFF;
    }

    @Override
    public void writeIntBE(int x) {
        ByteOrder order = this.ioBuffer.order();
        int xBE = ByteOrder.LITTLE_ENDIAN == order ? ByteOutputBuffer1.swapInt32(x) : x;
        this.ioBuffer.putInt(xBE);
    }

    @Override
    public void writeInt(int pos, int x) {
        int save = this.getPosition();
        this.setPosition(pos);
        this.writeInt(x);
        this.setPosition(save);
    }

    @Override
    public void writeLong(long x) {
        this.ioBuffer.putLong(x);
    }

    @Override
    public void writeDouble(double x) {
        this.ioBuffer.putDouble(x);
    }

    @Override
    public int getPosition() {
        return this.ioBuffer.position();
    }

    @Override
    public void setPosition(int position) {
        this.ioBuffer.position(position);
    }

    @Override
    public void seekEnd() {
        this.ioBuffer.position(this.ioBuffer.capacity());
    }

    @Override
    public void seekStart() {
        this.ioBuffer.position(0);
    }

    @Override
    public int size() {
        return this.ioBuffer.capacity();
    }

    @Override
    public int pipe(OutputStream out) throws IOException {
        out.write(this.ioBuffer.array());
        return this.ioBuffer.capacity();
    }
}

