/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.util;

import com.google.gson.Gson;
import com.google.gson.internal.Primitives;
import com.sequoiadb.base.SDBMessage;
import com.sequoiadb.base.SequoiadbConstants;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.util.ByteOutputBuffer1;
import com.sequoiadb.util.Helper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.mina.core.buffer.IoBuffer;
import org.bson.BSONCallback;
import org.bson.BSONObject;
import org.bson.BasicBSONCallback;
import org.bson.BasicBSONDecoder;
import org.bson.BasicBSONEncoder;
import org.bson.BasicBSONObject;
import org.bson.io.BasicOutputBuffer;

public class SDBMessageHelper {
    private static final int MESSAGE_SYSINFOREQUEST_LENGTH = 12;
    private static final int MESSAGE_HEADER_LENGTH = 28;
    private static final int MESSAGE_OPQUERY_LENGTH = 61;
    public static final int MESSAGE_OPINSERT_LENGTH = 45;
    private static final int MESSAGE_OPDELETE_LENGTH = 45;
    private static final int MESSAGE_OPUPDATE_LENGTH = 45;
    private static final int MESSAGE_OPGETMORE_LENGTH = 40;
    private static final int MESSAGE_OPKILLCONTEXT_LENGTH = 36;
    public static final int MESSAGE_OPLOB_LENGTH = 52;
    public static final int MESSAGE_LOBTUPLE_LENGTH = 16;
    private static final Byte BTYE_FILL = 0;

    public static byte[] buildSysInfoRequest() {
        ByteBuffer buf = ByteBuffer.allocate(12);
        buf.putInt(-1);
        buf.putInt(-66052);
        buf.putInt(12);
        return buf.array();
    }

    public static byte[] buildQueryRequest(SDBMessage sdbMessage, boolean endianConvert) throws BaseException {
        try {
            String collectionName = sdbMessage.getCollectionFullName();
            int version = sdbMessage.getVersion();
            short w = sdbMessage.getW();
            short padding = sdbMessage.getPadding();
            int flags = sdbMessage.getFlags();
            long requestID = sdbMessage.getRequestID();
            int opCode = sdbMessage.getOperationCode().getOperationCode();
            long skipRowsCount = sdbMessage.getSkipRowsCount();
            long returnRowsCount = sdbMessage.getReturnRowsCount();
            byte[] collByteArray = collectionName.getBytes("UTF-8");
            int collectionNameLength = collByteArray.length;
            byte[] query = SDBMessageHelper.bsonObjectToByteArray(sdbMessage.getMatcher());
            byte[] fieldSelector = SDBMessageHelper.bsonObjectToByteArray(sdbMessage.getSelector());
            byte[] orderBy = SDBMessageHelper.bsonObjectToByteArray(sdbMessage.getOrderBy());
            byte[] hint = SDBMessageHelper.bsonObjectToByteArray(sdbMessage.getHint());
            byte[] nodeID = sdbMessage.getNodeID();
            if (!endianConvert) {
                SDBMessageHelper.bsonEndianConvert(query, 0, query.length, true);
                SDBMessageHelper.bsonEndianConvert(fieldSelector, 0, fieldSelector.length, true);
                SDBMessageHelper.bsonEndianConvert(orderBy, 0, orderBy.length, true);
                SDBMessageHelper.bsonEndianConvert(hint, 0, hint.length, true);
            }
            int messageLength = Helper.roundToMultipleXLength(61 + collectionNameLength, 4) + Helper.roundToMultipleXLength(query.length, 4) + Helper.roundToMultipleXLength(fieldSelector.length, 4) + Helper.roundToMultipleXLength(orderBy.length, 4) + Helper.roundToMultipleXLength(hint.length, 4);
            ArrayList<byte[]> fieldList = new ArrayList<byte[]>();
            fieldList.add(SDBMessageHelper.assembleHeader(messageLength, requestID, nodeID, opCode, endianConvert));
            ByteBuffer buf = ByteBuffer.allocate(32);
            if (endianConvert) {
                buf.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                buf.order(ByteOrder.BIG_ENDIAN);
            }
            buf.putInt(version);
            buf.putShort(w);
            buf.putShort(padding);
            buf.putInt(flags);
            buf.putInt(collectionNameLength);
            buf.putLong(skipRowsCount);
            buf.putLong(returnRowsCount);
            fieldList.add(buf.array());
            byte[] newCollectionName = new byte[collectionNameLength + 1];
            for (int i = 0; i < collectionNameLength; ++i) {
                newCollectionName[i] = collByteArray[i];
            }
            fieldList.add(Helper.roundToMultipleX(newCollectionName, 4));
            fieldList.add(Helper.roundToMultipleX(query, 4));
            fieldList.add(Helper.roundToMultipleX(fieldSelector, 4));
            fieldList.add(Helper.roundToMultipleX(orderBy, 4));
            fieldList.add(Helper.roundToMultipleX(hint, 4));
            byte[] msgInByteArray = Helper.concatByteArray(fieldList);
            return msgInByteArray;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new BaseException("SDB_INVALIDARG", new Object[]{e});
        }
    }

    public static byte[] buildAuthMsg(String userName, String password, long reqID, byte type, boolean endianConvert) {
        String md5 = null;
        if (password != null) {
            md5 = SDBMessageHelper.getMD5FromStr(password);
        }
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("User", (Object)userName);
        obj.put("Passwd", (Object)md5);
        byte[] info = SDBMessageHelper.bsonObjectToByteArray(obj);
        if (!endianConvert) {
            SDBMessageHelper.bsonEndianConvert(info, 0, info.length, true);
        }
        int messageLength = 28 + Helper.roundToMultipleXLength(info.length, 4);
        ArrayList<byte[]> fieldList = new ArrayList<byte[]>();
        int opCode = 0;
        switch (type) {
            case 0: {
                opCode = SequoiadbConstants.Operation.MSG_AUTH_VERIFY.getOperationCode();
                break;
            }
            case 1: {
                opCode = SequoiadbConstants.Operation.MSG_AUTH_CRTUSR.getOperationCode();
                break;
            }
            case 2: {
                opCode = SequoiadbConstants.Operation.MSG_AUTH_DELUSR.getOperationCode();
                break;
            }
            default: {
                throw new BaseException("SDB_INVALIDARG", new Object[0]);
            }
        }
        fieldList.add(SDBMessageHelper.assembleHeader(messageLength, reqID, SequoiadbConstants.ZERO_NODEID, opCode, endianConvert));
        fieldList.add(Helper.roundToMultipleX(info, 4));
        byte[] msgInByteArray = Helper.concatByteArray(fieldList);
        return msgInByteArray;
    }

    public static byte[] buildTransactionRequest(SequoiadbConstants.Operation opCode, long reqID, boolean endianConvert) {
        int messageLength = 28;
        byte[] msg = SDBMessageHelper.assembleHeader(messageLength, reqID, SequoiadbConstants.ZERO_NODEID, opCode.getOperationCode(), endianConvert);
        return msg;
    }

    public static int buildBulkInsertRequest(IoBuffer bulk_buffer, long reqID, String collectionFullName, List<BSONObject> insertor, int flag) throws BaseException {
        try {
            int i;
            int messageLength = 44;
            int startPos = bulk_buffer.position();
            bulk_buffer.putInt(-1);
            bulk_buffer.putInt(SequoiadbConstants.Operation.OP_INSERT.getOperationCode());
            bulk_buffer.put(SequoiadbConstants.ZERO_NODEID);
            bulk_buffer.putLong(reqID);
            bulk_buffer.putInt(0);
            bulk_buffer.putShort((short)0);
            bulk_buffer.putShort((short)0);
            bulk_buffer.putInt(flag);
            byte[] collByteArray = collectionFullName.getBytes("UTF-8");
            bulk_buffer.putInt(collByteArray.length);
            byte[] newCollectionName = new byte[collByteArray.length + 1];
            for (i = 0; i < collByteArray.length; ++i) {
                newCollectionName[i] = collByteArray[i];
            }
            messageLength += Helper.roundToMultipleXLength(newCollectionName.length, 4);
            bulk_buffer.put(Helper.roundToMultipleX(newCollectionName, 4));
            for (i = 0; i < insertor.size(); ++i) {
                int record_length = SDBMessageHelper.bsonObjectToByteBuffer(bulk_buffer, insertor.get(i));
                int length = Helper.roundToMultipleXLength(record_length, 4);
                int j = 0;
                while (record_length + j < length) {
                    bulk_buffer.put(BTYE_FILL);
                    ++j;
                }
                messageLength += length;
            }
            bulk_buffer.position(startPos);
            bulk_buffer.putInt(messageLength);
            return messageLength;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new BaseException("SDB_INVALIDARG", new Object[]{e});
        }
    }

    public static int buildInsertRequest(IoBuffer bulk_buffer, long reqID, String collectionFullName, BSONObject insertor) throws BaseException {
        try {
            int messageLength = 44;
            int startPos = bulk_buffer.position();
            bulk_buffer.putInt(-1);
            bulk_buffer.putInt(SequoiadbConstants.Operation.OP_INSERT.getOperationCode());
            bulk_buffer.put(SequoiadbConstants.ZERO_NODEID);
            bulk_buffer.putLong(reqID);
            bulk_buffer.putInt(0);
            bulk_buffer.putShort((short)0);
            bulk_buffer.putShort((short)0);
            bulk_buffer.putInt(0);
            byte[] collByteArray = collectionFullName.getBytes("UTF-8");
            bulk_buffer.putInt(collByteArray.length);
            byte[] newCollectionName = new byte[collByteArray.length + 1];
            for (int i = 0; i < collByteArray.length; ++i) {
                newCollectionName[i] = collByteArray[i];
            }
            messageLength += Helper.roundToMultipleXLength(newCollectionName.length, 4);
            bulk_buffer.put(Helper.roundToMultipleX(newCollectionName, 4));
            int record_length = SDBMessageHelper.bsonObjectToByteBuffer(bulk_buffer, insertor);
            int length = Helper.roundToMultipleXLength(record_length, 4);
            int j = 0;
            while (record_length + j < length) {
                bulk_buffer.put(BTYE_FILL);
                ++j;
            }
            bulk_buffer.position(startPos);
            bulk_buffer.putInt(messageLength += length);
            return messageLength;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new BaseException("SDB_INVALIDARG", new Object[]{e});
        }
    }

    public static byte[] buildDeleteRequest(SDBMessage sdbMessage, boolean endianConvert) throws BaseException {
        try {
            String collectionName = sdbMessage.getCollectionFullName();
            int version = sdbMessage.getVersion();
            short w = sdbMessage.getW();
            short padding = sdbMessage.getPadding();
            int flags = sdbMessage.getFlags();
            long requestID = sdbMessage.getRequestID();
            byte[] nodeID = sdbMessage.getNodeID();
            int opCode = sdbMessage.getOperationCode().getOperationCode();
            byte[] collByteArray = collectionName.getBytes("UTF-8");
            int collectionNameLength = collByteArray.length;
            byte[] matcher = SDBMessageHelper.bsonObjectToByteArray(sdbMessage.getMatcher());
            byte[] hint = SDBMessageHelper.bsonObjectToByteArray(sdbMessage.getHint());
            if (!endianConvert) {
                SDBMessageHelper.bsonEndianConvert(matcher, 0, matcher.length, true);
                SDBMessageHelper.bsonEndianConvert(hint, 0, hint.length, true);
            }
            int messageLength = Helper.roundToMultipleXLength(45 + collectionNameLength, 4) + Helper.roundToMultipleXLength(matcher.length, 4) + Helper.roundToMultipleXLength(hint.length, 4);
            ArrayList<byte[]> fieldList = new ArrayList<byte[]>();
            fieldList.add(SDBMessageHelper.assembleHeader(messageLength, requestID, nodeID, opCode, endianConvert));
            ByteBuffer buf = ByteBuffer.allocate(16);
            if (endianConvert) {
                buf.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                buf.order(ByteOrder.BIG_ENDIAN);
            }
            buf.putInt(version);
            buf.putShort(w);
            buf.putShort(padding);
            buf.putInt(flags);
            buf.putInt(collectionNameLength);
            fieldList.add(buf.array());
            byte[] newCollectionName = new byte[collectionNameLength + 1];
            for (int i = 0; i < collectionNameLength; ++i) {
                newCollectionName[i] = collByteArray[i];
            }
            fieldList.add(Helper.roundToMultipleX(newCollectionName, 4));
            fieldList.add(Helper.roundToMultipleX(matcher, 4));
            fieldList.add(Helper.roundToMultipleX(hint, 4));
            byte[] msgInByteArray = Helper.concatByteArray(fieldList);
            return msgInByteArray;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new BaseException("SDB_INVALIDARG", new Object[]{e});
        }
    }

    public static byte[] buildUpdateRequest(SDBMessage sdbMessage, boolean endianConvert) throws BaseException {
        try {
            String collectionName = sdbMessage.getCollectionFullName();
            int version = sdbMessage.getVersion();
            short w = sdbMessage.getW();
            short padding = sdbMessage.getPadding();
            int flags = sdbMessage.getFlags();
            long requestID = sdbMessage.getRequestID();
            byte[] nodeID = sdbMessage.getNodeID();
            int opCode = sdbMessage.getOperationCode().getOperationCode();
            byte[] collByteArray = collectionName.getBytes("UTF-8");
            int collectionNameLength = collByteArray.length;
            byte[] matcher = SDBMessageHelper.bsonObjectToByteArray(sdbMessage.getMatcher());
            byte[] hint = SDBMessageHelper.bsonObjectToByteArray(sdbMessage.getHint());
            byte[] modifier = SDBMessageHelper.bsonObjectToByteArray(sdbMessage.getModifier());
            if (!endianConvert) {
                SDBMessageHelper.bsonEndianConvert(matcher, 0, matcher.length, true);
                SDBMessageHelper.bsonEndianConvert(hint, 0, hint.length, true);
                SDBMessageHelper.bsonEndianConvert(modifier, 0, modifier.length, true);
            }
            int messageLength = Helper.roundToMultipleXLength(45 + collectionNameLength, 4) + Helper.roundToMultipleXLength(matcher.length, 4) + Helper.roundToMultipleXLength(modifier.length, 4) + Helper.roundToMultipleXLength(hint.length, 4);
            ArrayList<byte[]> fieldList = new ArrayList<byte[]>();
            fieldList.add(SDBMessageHelper.assembleHeader(messageLength, requestID, nodeID, opCode, endianConvert));
            ByteBuffer buf = ByteBuffer.allocate(16);
            if (endianConvert) {
                buf.order(ByteOrder.LITTLE_ENDIAN);
            } else {
                buf.order(ByteOrder.BIG_ENDIAN);
            }
            buf.putInt(version);
            buf.putShort(w);
            buf.putShort(padding);
            buf.putInt(flags);
            buf.putInt(collectionNameLength);
            fieldList.add(buf.array());
            byte[] newCollectionName = new byte[collectionNameLength + 1];
            for (int i = 0; i < collectionNameLength; ++i) {
                newCollectionName[i] = collByteArray[i];
            }
            fieldList.add(Helper.roundToMultipleX(newCollectionName, 4));
            fieldList.add(Helper.roundToMultipleX(matcher, 4));
            fieldList.add(Helper.roundToMultipleX(modifier, 4));
            fieldList.add(Helper.roundToMultipleX(hint, 4));
            byte[] msgInByteArray = Helper.concatByteArray(fieldList);
            return msgInByteArray;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new BaseException("SDB_INVALIDARG", new Object[]{e});
        }
    }

    public static byte[] buildDisconnectRequest(boolean endianConvert) throws BaseException {
        long requestID = 0L;
        byte[] nodeID = SequoiadbConstants.ZERO_NODEID;
        int messageLength = Helper.roundToMultipleXLength(28, 4);
        ArrayList<byte[]> fieldList = new ArrayList<byte[]>();
        fieldList.add(SDBMessageHelper.assembleHeader(messageLength, requestID, nodeID, SequoiadbConstants.Operation.OP_DISCONNECT.getOperationCode(), endianConvert));
        byte[] msgInByteArray = Helper.concatByteArray(fieldList);
        return msgInByteArray;
    }

    public static byte[] buildSqlMsg(SDBMessage sdb, String sql, boolean endianConvert) throws BaseException {
        try {
            long requestID = sdb.getRequestID();
            byte[] nodeID = sdb.getNodeID();
            byte[] sqlBytes = sql.getBytes("UTF-8");
            int sqlLength = sqlBytes.length;
            byte[] newSqlBytes = new byte[sqlLength + 1];
            int messageLength = Helper.roundToMultipleXLength(28 + sqlLength + 1, 4);
            ArrayList<byte[]> fieldList = new ArrayList<byte[]>();
            fieldList.add(SDBMessageHelper.assembleHeader(messageLength, requestID, nodeID, SequoiadbConstants.Operation.MSG_BS_SQL_REQ.getOperationCode(), endianConvert));
            for (int i = 0; i < sqlLength; ++i) {
                newSqlBytes[i] = sqlBytes[i];
            }
            fieldList.add(Helper.roundToMultipleX(newSqlBytes, 4));
            byte[] msgInByteArray = Helper.concatByteArray(fieldList);
            return msgInByteArray;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new BaseException("SDB_INVALIDARG", new Object[]{e});
        }
    }

    public static int buildAggrRequest(IoBuffer bulk_buffer, long reqID, String collectionFullName, List<BSONObject> insertor) throws BaseException {
        try {
            int i;
            int messageLength = 44;
            int startPos = bulk_buffer.position();
            bulk_buffer.putInt(-1);
            bulk_buffer.putInt(SequoiadbConstants.Operation.OP_AGGREGATE.getOperationCode());
            bulk_buffer.put(SequoiadbConstants.ZERO_NODEID);
            bulk_buffer.putLong(reqID);
            bulk_buffer.putInt(0);
            bulk_buffer.putShort((short)0);
            bulk_buffer.putShort((short)0);
            bulk_buffer.putInt(0);
            byte[] collByteArray = collectionFullName.getBytes("UTF-8");
            bulk_buffer.putInt(collByteArray.length);
            byte[] newCollectionName = new byte[collByteArray.length + 1];
            for (i = 0; i < collByteArray.length; ++i) {
                newCollectionName[i] = collByteArray[i];
            }
            messageLength += Helper.roundToMultipleXLength(newCollectionName.length, 4);
            bulk_buffer.put(Helper.roundToMultipleX(newCollectionName, 4));
            for (i = 0; i < insertor.size(); ++i) {
                int record_length = SDBMessageHelper.bsonObjectToByteBuffer(bulk_buffer, insertor.get(i));
                int length = Helper.roundToMultipleXLength(record_length, 4);
                int j = 0;
                while (record_length + j < length) {
                    bulk_buffer.put(BTYE_FILL);
                    ++j;
                }
                messageLength += length;
            }
            bulk_buffer.position(startPos);
            bulk_buffer.putInt(messageLength);
            return messageLength;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            throw new BaseException("SDB_INVALIDARG", new Object[]{e});
        }
    }

    private static byte[] assembleHeader(int messageLength, long requestID, byte[] nodeID, int operationCode, boolean endianConvert) {
        ByteBuffer buf = ByteBuffer.allocate(28);
        if (endianConvert) {
            buf.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            buf.order(ByteOrder.BIG_ENDIAN);
        }
        buf.putInt(messageLength);
        buf.putInt(operationCode);
        buf.put(nodeID);
        buf.putLong(requestID);
        return buf.array();
    }

    public static SDBMessage msgExtractReply(ByteBuffer byteBuffer) throws BaseException {
        SDBMessage sdbMessage = new SDBMessage();
        int MessageLength = byteBuffer.getInt();
        if (MessageLength < 28) {
            throw new BaseException("SDB_INVALIDSIZE", MessageLength);
        }
        sdbMessage.setRequestLength(MessageLength);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.getByValue(byteBuffer.getInt()));
        byte[] nodeID = new byte[12];
        byteBuffer.get(nodeID, 0, 12);
        sdbMessage.setNodeID(nodeID);
        sdbMessage.setRequestID(byteBuffer.getLong());
        ArrayList<Long> contextIDList = new ArrayList<Long>();
        contextIDList.add(byteBuffer.getLong());
        sdbMessage.setContextIDList(contextIDList);
        sdbMessage.setFlags(byteBuffer.getInt());
        sdbMessage.setStartFrom(byteBuffer.getInt());
        int numReturned = byteBuffer.getInt();
        sdbMessage.setNumReturned(numReturned);
        if (numReturned > 0) {
            List<BSONObject> objList = SDBMessageHelper.extractBSONObject(byteBuffer);
            sdbMessage.setObjectList(objList);
        } else {
            sdbMessage.setObjectList(null);
        }
        return sdbMessage;
    }

    public static void addLobMsgHeader(ByteBuffer buff, int totalLen, int opCode, byte[] nodeID, long requestID) {
        buff.putInt(totalLen);
        buff.putInt(opCode);
        buff.put(nodeID);
        buff.putLong(requestID);
    }

    public static void addLobOpMsg(ByteBuffer buff, int version, short w, short padding, int flags, long contextID, int bsonLen) {
        buff.putInt(version);
        buff.putShort(w);
        buff.putShort(padding);
        buff.putInt(flags);
        buff.putLong(contextID);
        buff.putInt(bsonLen);
    }

    public static byte[] generateRemoveLobRequest(BSONObject removeObj, long reqID, boolean endianConvert) {
        byte[] bRevemoObj = SDBMessageHelper.bsonObjectToByteArray(removeObj);
        int totalLen = 52 + Helper.roundToMultipleXLength(bRevemoObj.length, 4);
        if (!endianConvert) {
            SDBMessageHelper.bsonEndianConvert(bRevemoObj, 0, bRevemoObj.length, true);
        }
        ByteBuffer buff = ByteBuffer.allocate(52);
        if (endianConvert) {
            buff.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            buff.order(ByteOrder.BIG_ENDIAN);
        }
        SDBMessageHelper.addLobMsgHeader(buff, totalLen, SequoiadbConstants.Operation.MSG_BS_LOB_REMOVE_REQ.getOperationCode(), SequoiadbConstants.ZERO_NODEID, reqID);
        SDBMessageHelper.addLobOpMsg(buff, 0, (short)1, (short)0, 0, -1L, bRevemoObj.length);
        ArrayList<byte[]> buffList = new ArrayList<byte[]>();
        buffList.add(buff.array());
        buffList.add(Helper.roundToMultipleX(bRevemoObj, 4));
        return Helper.concatByteArray(buffList);
    }

    public static SDBMessage msgExtractLobOpenReply(ByteBuffer byteBuffer) throws BaseException {
        SDBMessage sdbMessage = new SDBMessage();
        int MessageLength = byteBuffer.getInt();
        if (MessageLength < 28) {
            throw new BaseException("SDB_INVALIDSIZE", MessageLength);
        }
        sdbMessage.setRequestLength(MessageLength);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.getByValue(byteBuffer.getInt()));
        byte[] nodeID = new byte[12];
        byteBuffer.get(nodeID, 0, 12);
        sdbMessage.setNodeID(nodeID);
        sdbMessage.setRequestID(byteBuffer.getLong());
        ArrayList<Long> contextIDList = new ArrayList<Long>();
        contextIDList.add(byteBuffer.getLong());
        sdbMessage.setContextIDList(contextIDList);
        sdbMessage.setFlags(byteBuffer.getInt());
        sdbMessage.setStartFrom(byteBuffer.getInt());
        int numReturned = byteBuffer.getInt();
        sdbMessage.setNumReturned(numReturned);
        List<BSONObject> objList = SDBMessageHelper.extractBSONObject(byteBuffer);
        sdbMessage.setObjectList(objList);
        return sdbMessage;
    }

    public static SDBMessage msgExtractLobRemoveReply(ByteBuffer byteBuffer) throws BaseException {
        return SDBMessageHelper.msgExtractLobOpenReply(byteBuffer);
    }

    public static SDBMessage msgExtractLobReadReply(ByteBuffer byteBuffer) throws BaseException {
        SDBMessage sdbMessage = new SDBMessage();
        int MessageLength = byteBuffer.getInt();
        if (MessageLength < 28) {
            throw new BaseException("SDB_INVALIDSIZE", MessageLength);
        }
        sdbMessage.setRequestLength(MessageLength);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.getByValue(byteBuffer.getInt()));
        byte[] nodeID = new byte[12];
        byteBuffer.get(nodeID, 0, 12);
        sdbMessage.setNodeID(nodeID);
        sdbMessage.setRequestID(byteBuffer.getLong());
        ArrayList<Long> contextIDList = new ArrayList<Long>();
        contextIDList.add(byteBuffer.getLong());
        sdbMessage.setContextIDList(contextIDList);
        sdbMessage.setFlags(byteBuffer.getInt());
        sdbMessage.setStartFrom(byteBuffer.getInt());
        int numReturned = byteBuffer.getInt();
        sdbMessage.setNumReturned(numReturned);
        sdbMessage.setObjectList(null);
        if (sdbMessage.getFlags() == 0) {
            sdbMessage.setLobLen(byteBuffer.getInt());
            sdbMessage.setLobSequence(byteBuffer.getInt());
            sdbMessage.setLobOffset(byteBuffer.getLong());
            byte[] buff = new byte[sdbMessage.getLobLen()];
            byteBuffer.get(buff);
            sdbMessage.setLobBuff(buff);
        }
        return sdbMessage;
    }

    public static SDBMessage msgExtractEvalReply(ByteBuffer byteBuffer) throws BaseException {
        SDBMessage sdbMessage = new SDBMessage();
        int MessageLength = byteBuffer.getInt();
        if (MessageLength < 28) {
            throw new BaseException("SDB_INVALIDSIZE", MessageLength);
        }
        sdbMessage.setRequestLength(MessageLength);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.getByValue(byteBuffer.getInt()));
        byte[] nodeID = new byte[12];
        byteBuffer.get(nodeID, 0, 12);
        sdbMessage.setNodeID(nodeID);
        sdbMessage.setRequestID(byteBuffer.getLong());
        ArrayList<Long> contextIDList = new ArrayList<Long>();
        contextIDList.add(byteBuffer.getLong());
        sdbMessage.setContextIDList(contextIDList);
        sdbMessage.setFlags(byteBuffer.getInt());
        sdbMessage.setStartFrom(byteBuffer.getInt());
        int returnType = byteBuffer.getInt();
        sdbMessage.setNumReturned(returnType);
        if (sdbMessage.getFlags() != 0) {
            List<BSONObject> objList = SDBMessageHelper.extractBSONObject(byteBuffer);
            sdbMessage.setObjectList(objList);
        } else {
            sdbMessage.setObjectList(null);
        }
        return sdbMessage;
    }

    public static SDBMessage msgExtractReplyRaw(ByteBuffer byteBuffer) throws BaseException {
        SDBMessage sdbMessage = new SDBMessage();
        int MessageLength = byteBuffer.getInt();
        sdbMessage.setRequestLength(MessageLength);
        sdbMessage.setOperationCode(SequoiadbConstants.Operation.getByValue(byteBuffer.getInt()));
        byte[] nodeID = new byte[12];
        byteBuffer.get(nodeID, 0, 12);
        sdbMessage.setNodeID(nodeID);
        sdbMessage.setRequestID(byteBuffer.getLong());
        ArrayList<Long> contextIDList = new ArrayList<Long>();
        contextIDList.add(byteBuffer.getLong());
        sdbMessage.setContextIDList(contextIDList);
        sdbMessage.setFlags(byteBuffer.getInt());
        sdbMessage.setStartFrom(byteBuffer.getInt());
        int numReturned = byteBuffer.getInt();
        sdbMessage.setNumReturned(numReturned);
        if (numReturned > 0) {
            List<byte[]> objList = SDBMessageHelper.extractRawObject(byteBuffer);
            sdbMessage.setObjectListRaw(objList);
        } else {
            sdbMessage.setObjectListRaw(null);
        }
        return sdbMessage;
    }

    public static byte[] buildGetMoreRequest(SDBMessage sdbMessage, boolean endianConvert) throws BaseException {
        long requestID = sdbMessage.getRequestID();
        long contextId = sdbMessage.getContextIDList().get(0);
        int numReturned = sdbMessage.getNumReturned();
        byte[] nodeID = sdbMessage.getNodeID();
        int opCode = sdbMessage.getOperationCode().getOperationCode();
        int messageLength = 40;
        ArrayList<byte[]> fieldList = new ArrayList<byte[]>();
        fieldList.add(SDBMessageHelper.assembleHeader(messageLength, requestID, SequoiadbConstants.ZERO_NODEID, opCode, endianConvert));
        ByteBuffer buf = ByteBuffer.allocate(12);
        if (endianConvert) {
            buf.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            buf.order(ByteOrder.BIG_ENDIAN);
        }
        buf.putLong(contextId);
        buf.putInt(numReturned);
        fieldList.add(buf.array());
        byte[] msgInByteArray = Helper.concatByteArray(fieldList);
        return msgInByteArray;
    }

    public static byte[] buildKillCursorMsg(long reqId, long[] contextIds, boolean endianConvert) {
        int messageLength = 36 + 8 * contextIds.length;
        ArrayList<byte[]> fieldList = new ArrayList<byte[]>();
        fieldList.add(SDBMessageHelper.assembleHeader(messageLength, reqId, SequoiadbConstants.ZERO_NODEID, SequoiadbConstants.Operation.OP_KILL_CONTEXT.getOperationCode(), endianConvert));
        ByteBuffer buf = ByteBuffer.allocate(8 + 8 * contextIds.length);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.putInt(0);
        buf.putInt(contextIds.length);
        for (long temp : contextIds) {
            buf.putLong(temp);
        }
        fieldList.add(buf.array());
        byte[] msgInByteArray = Helper.concatByteArray(fieldList);
        return msgInByteArray;
    }

    private static List<byte[]> extractRawObject(ByteBuffer byteBuffer) throws BaseException {
        ArrayList<byte[]> rawList = new ArrayList<byte[]>();
        int nextBsonPos = byteBuffer.position();
        while (nextBsonPos < byteBuffer.limit()) {
            byteBuffer.position(nextBsonPos);
            int startPos = byteBuffer.position();
            int objLen = byteBuffer.getInt();
            byteBuffer.position(startPos);
            int objAllotLen = Helper.roundToMultipleXLength(objLen, 4);
            if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
                SDBMessageHelper.bsonEndianConvert(byteBuffer.array(), byteBuffer.position(), objLen, false);
            }
            byte[] bsonObj = new byte[objLen];
            byteBuffer.get(bsonObj, 0, objLen);
            rawList.add(bsonObj);
            nextBsonPos = byteBuffer.position() + (objAllotLen - objLen);
        }
        return rawList;
    }

    private static List<BSONObject> extractBSONObject(ByteBuffer byteBuffer) throws BaseException {
        ArrayList<BSONObject> objList = new ArrayList<BSONObject>();
        int nextBsonPos = byteBuffer.position();
        while (nextBsonPos < byteBuffer.limit()) {
            byteBuffer.position(nextBsonPos);
            int startPos = byteBuffer.position();
            int objLen = byteBuffer.getInt();
            byteBuffer.position(startPos);
            int objAllotLen = Helper.roundToMultipleXLength(objLen, 4);
            if (byteBuffer.order() == ByteOrder.BIG_ENDIAN) {
                SDBMessageHelper.bsonEndianConvert(byteBuffer.array(), byteBuffer.position(), objLen, false);
            }
            objList.add(SDBMessageHelper.byteArrayToBSONObject(byteBuffer));
            nextBsonPos = byteBuffer.position() + objAllotLen;
        }
        return objList;
    }

    public static int bsonObjectToByteBuffer(IoBuffer byteBuffer, BSONObject obj) {
        BasicBSONEncoder e = new BasicBSONEncoder();
        ByteOutputBuffer1 buf = new ByteOutputBuffer1(byteBuffer);
        e.set(buf);
        int length = e.putObject(obj);
        e.done();
        return length;
    }

    public static byte[] bsonObjectToByteArray(BSONObject obj) {
        BasicBSONEncoder e = new BasicBSONEncoder();
        BasicOutputBuffer buf = new BasicOutputBuffer();
        e.set(buf);
        e.putObject(obj);
        e.done();
        return buf.toByteArray();
    }

    public static BSONObject byteArrayToBSONObject(ByteBuffer byteBuffer) throws BaseException {
        if (byteBuffer == null || !byteBuffer.hasRemaining()) {
            return null;
        }
        BasicBSONDecoder d = new BasicBSONDecoder();
        BasicBSONCallback cb = new BasicBSONCallback();
        try {
            int s = d.decode(new ByteArrayInputStream(byteBuffer.array(), byteBuffer.position(), byteBuffer.remaining()), (BSONCallback)cb);
            BSONObject o1 = (BSONObject)cb.get();
            return o1;
        }
        catch (IOException e) {
            throw new BaseException("SDB_INVALIDARG", new Object[]{e});
        }
    }

    public static BSONObject fromObject(Object object) throws BaseException {
        Gson gson = new Gson();
        String jString = gson.toJson(object);
        return SDBMessageHelper.fromJson(jString);
    }

    public static <T> T fromBson(BSONObject bObj, Class<T> classOfT) {
        bObj.removeField("_id");
        Gson gson = new Gson();
        Object object = gson.fromJson(bObj.toString(), (Type)classOfT);
        return Primitives.wrap(classOfT).cast(object);
    }

    public static BSONObject fromJson(String jsonString) throws BaseException {
        String fullString = "{\"bsonMap\":" + jsonString + "}";
        Gson gson = new Gson();
        ConvertHelpObject obj = gson.fromJson(fullString, ConvertHelpObject.class);
        LinkedHashMap<String, Object> bsonMap = obj.getBsonMap();
        BasicBSONObject o1 = new BasicBSONObject();
        o1.putAll(bsonMap);
        return o1;
    }

    public static byte[] appendInsertMsg(byte[] msg, BSONObject append, boolean endianConvert) {
        List<byte[]> tmp = Helper.splitByteArray(msg, 4);
        byte[] msgLength = tmp.get(0);
        byte[] remaining = tmp.get(1);
        byte[] insertor = SDBMessageHelper.bsonObjectToByteArray(append);
        if (!endianConvert) {
            SDBMessageHelper.bsonEndianConvert(insertor, 0, insertor.length, true);
        }
        int length = Helper.byteToInt(msgLength, endianConvert);
        int messageLength = length + Helper.roundToMultipleXLength(insertor.length, 4);
        ByteBuffer buf = ByteBuffer.allocate(messageLength);
        if (endianConvert) {
            buf.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            buf.order(ByteOrder.BIG_ENDIAN);
        }
        buf.putInt(messageLength);
        buf.put(remaining);
        buf.put(Helper.roundToMultipleX(insertor, 4));
        return buf.array();
    }

    private static String getMD5FromStr(String inStr) {
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
        char[] charArray = inStr.toCharArray();
        byte[] byteArray = new byte[charArray.length];
        for (int i = 0; i < charArray.length; ++i) {
            byteArray[i] = (byte)charArray[i];
        }
        byte[] md5Bytes = md5.digest(byteArray);
        StringBuffer hexValue = new StringBuffer();
        for (int i = 0; i < md5Bytes.length; ++i) {
            int val = md5Bytes[i] & 0xFF;
            if (val < 16) {
                hexValue.append("0");
            }
            hexValue.append(Integer.toHexString(val));
        }
        return hexValue.toString();
    }

    public static boolean msgExtractSysInfoReply(byte[] msg) {
        List<byte[]> tmp = Helper.splitByteArray(msg, 12);
        byte[] header = tmp.get(0);
        return SDBMessageHelper.extractSysInfoHeader(header);
    }

    private static boolean extractSysInfoHeader(byte[] header) {
        boolean endianConvert = false;
        byte[] headsByte = new byte[4];
        System.arraycopy(header, 4, headsByte, 0, 4);
        int eyeCatcher = Helper.byteToInt(headsByte);
        if (eyeCatcher == -66052) {
            endianConvert = false;
        } else if (eyeCatcher == -50462977) {
            endianConvert = true;
        } else {
            throw new BaseException("SDB_INVALIDARG", eyeCatcher);
        }
        return endianConvert;
    }

    public static void bsonEndianConvert(byte[] inBytes, int offset, int objSize, boolean l2r) {
        int begin = offset;
        SDBMessageHelper.arrayReverse(inBytes, offset, 4);
        offset += 4;
        while (offset < inBytes.length) {
            byte type = inBytes[offset];
            ++offset;
            if (type == 0) break;
            offset += SDBMessageHelper.getStrLength(inBytes, offset) + 1;
            switch (type) {
                case 1: {
                    SDBMessageHelper.arrayReverse(inBytes, offset, 8);
                    offset += 8;
                    break;
                }
                case 2: 
                case 13: 
                case 14: {
                    int length = Helper.byteToInt(inBytes, offset);
                    SDBMessageHelper.arrayReverse(inBytes, offset, 4);
                    int newLength = Helper.byteToInt(inBytes, offset);
                    offset += (l2r ? newLength : length) + 4;
                    break;
                }
                case 3: 
                case 4: {
                    int length = SDBMessageHelper.getBsonLength(inBytes, offset, l2r);
                    SDBMessageHelper.bsonEndianConvert(inBytes, offset, length, l2r);
                    offset += length;
                    break;
                }
                case 5: {
                    int length = Helper.byteToInt(inBytes, offset);
                    SDBMessageHelper.arrayReverse(inBytes, offset, 4);
                    int newLength = Helper.byteToInt(inBytes, offset);
                    offset += (l2r ? newLength : length) + 5;
                    break;
                }
                case -1: 
                case 6: 
                case 10: 
                case 127: {
                    break;
                }
                case 7: {
                    offset += 12;
                    break;
                }
                case 8: {
                    ++offset;
                    break;
                }
                case 9: {
                    SDBMessageHelper.arrayReverse(inBytes, offset, 8);
                    offset += 8;
                    break;
                }
                case 11: {
                    offset += SDBMessageHelper.getStrLength(inBytes, offset) + 1;
                    offset += SDBMessageHelper.getStrLength(inBytes, offset) + 1;
                    break;
                }
                case 12: {
                    int length = Helper.byteToInt(inBytes, offset += 12);
                    SDBMessageHelper.arrayReverse(inBytes, offset, 4);
                    int newLength = Helper.byteToInt(inBytes, offset);
                    offset += (l2r ? newLength : length) + 4;
                    offset += 12;
                    break;
                }
                case 15: {
                    SDBMessageHelper.arrayReverse(inBytes, offset, 4);
                    int length = Helper.byteToInt(inBytes, offset += 4);
                    SDBMessageHelper.arrayReverse(inBytes, offset, 4);
                    int newLength = Helper.byteToInt(inBytes, offset);
                    int objLength = SDBMessageHelper.getBsonLength(inBytes, offset += (l2r ? newLength : length) + 4, l2r);
                    SDBMessageHelper.bsonEndianConvert(inBytes, offset, objLength, l2r);
                    offset += objLength;
                    break;
                }
                case 16: {
                    SDBMessageHelper.arrayReverse(inBytes, offset, 4);
                    offset += 4;
                    break;
                }
                case 17: {
                    SDBMessageHelper.arrayReverse(inBytes, offset, 4);
                    SDBMessageHelper.arrayReverse(inBytes, offset += 4, 4);
                    offset += 4;
                    break;
                }
                case 18: {
                    SDBMessageHelper.arrayReverse(inBytes, offset, 8);
                    offset += 8;
                }
            }
        }
        if (offset - begin != objSize) {
            throw new BaseException("SDB_INVALIDSIZE", new Object[0]);
        }
    }

    private static int getBsonLength(byte[] inBytes, int offset, boolean endianConvert) {
        byte[] tmp = new byte[4];
        for (int i = 0; i < 4; ++i) {
            tmp[i] = inBytes[offset + i];
        }
        return Helper.byteToInt(tmp, endianConvert);
    }

    private static void arrayReverse(byte[] array, int begin, int length) {
        int i = begin;
        for (int j = begin + length - 1; i < j; ++i, --j) {
            byte tmp = array[i];
            array[i] = array[j];
            array[j] = tmp;
        }
    }

    private static int getStrLength(byte[] array, int begin) {
        int length = 0;
        while (array[begin] != 0) {
            ++length;
            ++begin;
        }
        return length;
    }

    public static void checkMessage(SDBMessage req, SDBMessage res) {
        SDBMessageHelper.checkMsgOpCode(req.getOperationCode(), res.getOperationCode());
    }

    public static void checkMsgOpCode(SequoiadbConstants.Operation reqOpCode, SequoiadbConstants.Operation resOpCode) {
        int resCode;
        int reqCode = reqOpCode.getOperationCode();
        if ((reqCode | Integer.MIN_VALUE) != (resCode = resOpCode.getOperationCode())) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", "request=" + (Object)((Object)reqOpCode) + " response=" + (Object)((Object)resOpCode));
        }
    }

    public static void checkMsgReqID(long reqID, long resID) {
        if (reqID != resID) {
            throw new BaseException("SDB_UNKNOWN_MESSAGE", "reqID is differentreqID=" + reqID + " resID=" + resID);
        }
    }

    private class ConvertHelpObject {
        private LinkedHashMap<String, Object> bsonMap;

        private ConvertHelpObject() {
        }

        public LinkedHashMap<String, Object> getBsonMap() {
            return this.bsonMap;
        }

        public void setBsonMap(LinkedHashMap<String, Object> bsonMap) {
            this.bsonMap = bsonMap;
        }
    }
}

