/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class logger {
    private static final int LOG_LEVEL_ERROR = 2;
    private static final int LOG_LEVEL_FATAL = 2;
    private static final int LOG_LEVEL_WARN = 3;
    private static final int LOG_LEVEL_INFO = 4;
    private static final int LOG_LEVEL_DEBUG = 5;
    private static logger instance;
    private static boolean Iswritelog;
    private String logpath;
    private int loglevel;
    private Map<Long, Object> thrid2outputstream = new HashMap<Long, Object>();

    public static synchronized logger getInstance() {
        if (instance == null) {
            instance = new logger();
        }
        return instance;
    }

    private logger() {
        BufferedInputStream in = null;
        try {
            String filepath = System.getProperty("user.dir") + "/sdbdriver.properties";
            System.out.println(filepath);
            File file = new File(filepath);
            if (!file.exists()) {
                return;
            }
            in = new BufferedInputStream(new FileInputStream(filepath));
            Iswritelog = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        if (in != null) {
            File file;
            Properties properties = null;
            try {
                properties = new Properties();
                properties.load(in);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            Enumeration<Object> em = properties.keys();
            while (em.hasMoreElements()) {
                String item = (String)em.nextElement();
                String itemvalue = (String)properties.get(item);
                if (item.trim().equals("logpath")) {
                    this.logpath = itemvalue.trim();
                    continue;
                }
                if (!item.trim().equals("loglevel")) continue;
                this.loglevel = Integer.parseInt(itemvalue.trim());
            }
            if (this.logpath != null && !(file = new File(this.logpath)).exists()) {
                file.mkdir();
            }
        }
    }

    public BufferedOutputStream open() {
        if (!Iswritelog) {
            return null;
        }
        BufferedOutputStream fout = null;
        try {
            if (this.thrid2outputstream.containsKey(Thread.currentThread().getId())) {
                fout = (BufferedOutputStream)this.thrid2outputstream.get(Thread.currentThread().getId());
                return fout;
            }
            String filenameSuffix = "." + Long.toString(Thread.currentThread().getId());
            String filename = this.logpath + "/sdbdriver";
            filename = filename + filenameSuffix;
            System.out.println(filename);
            File file = new File(filename);
            if (!file.exists()) {
                file.createNewFile();
            }
            fout = new BufferedOutputStream(new FileOutputStream(file, true));
            this.thrid2outputstream.put(Thread.currentThread().getId(), fout);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return fout;
    }

    public void info(String msg) {
        if (this.loglevel < 4) {
            return;
        }
    }

    public void warn(String msg) {
        if (this.loglevel < 3) {
            return;
        }
    }

    public void fatal(String msg) {
        if (this.loglevel < 2) {
            return;
        }
    }

    public void error(String msg) {
        if (this.loglevel < 2) {
            return;
        }
    }

    public void debug(int level, String msg) {
        if (!Iswritelog) {
            return;
        }
        if (this.loglevel < 5) {
            return;
        }
        BufferedOutputStream fout = this.open();
        try {
            for (int i = 0; i < level; ++i) {
                fout.write("-".getBytes());
            }
            fout.write(msg.getBytes());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        if (!Iswritelog) {
            return;
        }
        if (this.loglevel < 5) {
            return;
        }
        BufferedOutputStream fout = this.open();
        try {
            fout.close();
            this.thrid2outputstream.remove(Thread.currentThread().getId());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getStackMsg() {
        StackTraceElement[] stackArray = Thread.currentThread().getStackTrace();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < stackArray.length; ++i) {
            StackTraceElement element = stackArray[i];
            sb.append(element.toString() + "\n");
        }
        return sb.toString();
    }

    static {
        Iswritelog = false;
    }
}

