/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.common.util;

import com.solacesystems.common.ChainedException;
import com.solacesystems.common.util.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5 {
    private static final String DIGEST_INSTANCE = "MD5";
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String hexDigestFromFile(String filename) throws ChainedException {
        if (filename == null || filename.equals("")) {
            throw new ChainedException("Unable to load file since it's absolute path is empty or null");
        }
        File file = new File(filename);
        byte[] fileData = null;
        if (!file.exists()) {
            throw new ChainedException("Unable to load file '" + filename + "' because it does not exist anymore");
        }
        try {
            long len = file.length();
            FileInputStream is = CommonUtils.loadFile(filename);
            fileData = new byte[(int)len];
            is.read(fileData);
        }
        catch (IOException e) {
            throw new ChainedException("Could not read file: " + file, e);
        }
        return MD5.hexDigestFromBytes(fileData);
    }

    public static String hexDigestFromString(String contents) throws ChainedException {
        byte[] contentsInBytes = contents.getBytes();
        return MD5.hexDigestFromBytes(contentsInBytes);
    }

    public static String hexDigestFromBytes(byte[] contents) throws ChainedException {
        try {
            MessageDigest md = MessageDigest.getInstance(DIGEST_INSTANCE);
            md.update(contents);
            String retString = new String(MD5.encodeHex(md.digest()));
            return retString;
        }
        catch (NoSuchAlgorithmException ex) {
            throw new ChainedException("Incorrect digest instance used.", ex);
        }
    }

    public static char[] encodeHex(byte[] data) {
        int l = data.length;
        char[] out = new char[l << 1];
        int j = 0;
        for (int i = 0; i < l; ++i) {
            out[j++] = DIGITS[(0xF0 & data[i]) >>> 4];
            out[j++] = DIGITS[0xF & data[i]];
        }
        return out;
    }
}

