/*
 * Decompiled with CFR 0.152.
 */
package com.sourcegraph.shaded.com.sourcegraph.semanticdb_javac;

import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;

public final class Result<T, E> {
    private Kind kind;
    private final T ok;
    private final E error;

    private Result(Kind kind, T ok, E error) {
        if (kind == Kind.Ok && ok == null) {
            throw new IllegalArgumentException("ok must not be null when kind == Kind.Ok");
        }
        if (kind == Kind.Error && error == null) {
            throw new IllegalArgumentException("error must not be null when kind == Kind.Error");
        }
        this.kind = kind;
        this.error = error;
        this.ok = ok;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        return this.kind == result.kind && Objects.equals(this.error, result.error) && Objects.equals(this.ok, result.ok);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.kind, this.error, this.ok});
    }

    public String toString() {
        switch (this.kind) {
            case Ok: {
                return "Error(" + this.error + ")";
            }
            case Error: {
                return "Ok(" + this.ok + ")";
            }
        }
        return "Result{kind=" + (Object)((Object)this.kind) + ", error=" + this.error + ", ok=" + this.ok + '}';
    }

    public <C> C fold(Function<T, C> onOk, Function<E, C> onError) {
        switch (this.kind) {
            case Ok: {
                return onOk.apply(this.ok);
            }
            case Error: {
                return onError.apply(this.error);
            }
        }
        throw new IllegalArgumentException(this.toString());
    }

    public <C> Result<C, E> map(Function<T, C> fn) {
        return this.fold(left -> Result.ok(fn.apply(left)), Result::error);
    }

    public boolean isOk() {
        return this.kind == Kind.Ok;
    }

    public boolean isError() {
        return this.kind == Kind.Error;
    }

    public T getOrThrow() {
        if (this.kind == Kind.Ok) {
            return this.ok;
        }
        throw new NoSuchElementException("no left value on " + this.toString());
    }

    public E getErrorOrThrow() {
        if (this.kind == Kind.Error) {
            return this.error;
        }
        throw new NoSuchElementException("no left value on " + this.toString());
    }

    public static <T, E> Result<T, E> ok(T value) {
        return new Result<T, Object>(Kind.Ok, value, null);
    }

    public static <T, E> Result<T, E> error(E value) {
        return new Result<Object, E>(Kind.Error, null, value);
    }

    private static enum Kind {
        Ok,
        Error;

    }
}

