/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.analysis.latte;

import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.analysis.latte.CalleeLocatingGenIdListener;
import com.sourceclear.analysis.latte.CallerLocatingVisitor;
import com.sourceclear.analysis.latte.LocatePositionsKt;
import com.sourceclear.analysis.latte.Position;
import com.sourceclear.analysis.latte.Result;
import com.sourceclear.analysis.latte.dynamic.Coverage;
import com.sourceclear.analysis.latte.dynamic.CoverageCaller;
import com.sourceclear.analysis.latte.genids.Id;
import com.sourceclear.analysis.latte.genids.IdComponent;
import com.sourceclear.analysis.latte.genids.VisitorUtils;
import com.sourceclear.analysis.latte.parser.AstCache;
import com.sourceclear.analysis.latte.parser.JavaScriptParser;
import com.sourceclear.analysis.latte.parser.JavaScriptParsersKt;
import com.sourceclear.methods.CallSite;
import com.sourceclear.methods.JSMethodInfo;
import com.veracode.security.logging.SecureLogger;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.antlr.v4.runtime.tree.ParseTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010&\n\u0000\u001a \u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a0\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\t\u001a\u00020\u00062\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0007\u001a$\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u001a`\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00160\u0014\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u0017\"\u0004\b\u0002\u0010\u0016*\u0010\u0012\u0006\b\u0001\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00170\u00142\"\b\u0004\u0010\u0018\u001a\u001c\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00170\u001a\u0012\u0006\u0012\u0004\u0018\u0001H\u00160\u0019H\u0086\b\u00f8\u0001\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u001b"}, d2={"LOGGER", "Lcom/veracode/security/logging/SecureLogger;", "coverageToCallSites", "", "Lcom/sourceclear/methods/CallSite;", "coverage", "Ljava/nio/file/Path;", "cache", "Lcom/sourceclear/analysis/latte/parser/AstCache;", "projectRoot", "sites", "", "Lcom/sourceclear/analysis/latte/dynamic/Coverage;", "locateInFile", "Lcom/sourceclear/analysis/latte/Result;", "file", "", "ast", "Lcom/sourceclear/analysis/latte/parser/JavaScriptParser$ProgramContext;", "maybeMapValues", "", "K", "R", "V", "transform", "Lkotlin/Function1;", "", "vulnerable-methods"})
public final class LocatePositionsKt {
    @NotNull
    private static final SecureLogger LOGGER;

    @NotNull
    public static final Set<CallSite> coverageToCallSites(@NotNull Path coverage, @Nullable AstCache cache) {
        Intrinsics.checkNotNullParameter((Object)coverage, (String)"coverage");
        Path projectRoot = coverage.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)projectRoot, (String)"projectRoot");
        return LocatePositionsKt.coverageToCallSites(projectRoot, Coverage.Companion.deserialize(coverage), cache);
    }

    public static /* synthetic */ Set coverageToCallSites$default(Path path, AstCache astCache, int n, Object object) {
        if ((n & 2) != 0) {
            astCache = null;
        }
        return LocatePositionsKt.coverageToCallSites(path, astCache);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    @NotNull
    public static final Set<CallSite> coverageToCallSites(@NotNull Path projectRoot, @NotNull List<Coverage> sites, @Nullable AstCache cache) {
        void $this$associateTo$iv$iv$iv;
        void $this$associate$iv$iv;
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)projectRoot, (String)"projectRoot");
        Intrinsics.checkNotNullParameter(sites, (String)"sites");
        Set files2 = SequencesKt.toSet((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)sites), (Function1)coverageToCallSites.files.1.INSTANCE));
        LOGGER.debug("{} dynamic call sites across {} unique files", (Object)sites.size(), (Object)files2.size());
        Sequence sequence = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)files2), (Function1)((Function1)new Function1<String, Sequence<? extends Pair<? extends String, ? extends JavaScriptParser.ProgramContext>>>(cache){
            final /* synthetic */ AstCache $cache;
            {
                this.$cache = $cache;
                super(1);
            }

            @NotNull
            public final Sequence<Pair<String, JavaScriptParser.ProgramContext>> invoke(@NotNull String file) {
                Sequence sequence;
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                try {
                    JavaScriptParser.ProgramContext programContext;
                    JavaScriptParser.ProgramContext programContext2;
                    AstCache astCache = this.$cache;
                    if (astCache == null) {
                        programContext2 = null;
                    } else {
                        Path path = Paths.get(file, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(file)");
                        programContext2 = programContext = astCache.get(path);
                    }
                    if (programContext2 == null) {
                        Path path = Paths.get(file, new String[0]);
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(file)");
                        programContext = JavaScriptParsersKt.parse(path);
                    }
                    JavaScriptParser.ProgramContext ast = programContext;
                    Object[] objectArray = new Pair[]{TuplesKt.to((Object)file, (Object)((Object)ast))};
                    sequence = SequencesKt.sequenceOf((Object[])objectArray);
                }
                catch (Exception ex) {
                    LocatePositionsKt.access$getLOGGER$p().debug("unable to parse AST of {}; skipping that portion of call graph", (Object)file, (Object)ex);
                    sequence = SequencesKt.sequenceOf((Object[])new Pair[0]);
                }
                return sequence;
            }
        }));
        boolean $i$f$associate = false;
        void var7_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Pair $dstr$k$v = (Pair)element$iv$iv;
            boolean bl = false;
            String k = (String)$dstr$k$v.component1();
            JavaScriptParser.ProgramContext v = (JavaScriptParser.ProgramContext)((Object)$dstr$k$v.component2());
            Pair pair = TuplesKt.to((Object)k, (Object)((Object)v));
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map trees2 = destination$iv$iv;
        LOGGER.debug("got ASTs for {} files", (Object)trees2.keySet().size());
        Map $this$maybeMapValues$iv = trees2;
        boolean $i$f$maybeMapValues = false;
        destination$iv$iv = SequencesKt.flatMap((Sequence)MapsKt.asSequence((Map)$this$maybeMapValues$iv), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends JavaScriptParser.ProgramContext>, Sequence<? extends Pair<? extends String, ? extends Result>>>(sites){
            final /* synthetic */ List $sites$inlined;
            {
                this.$sites$inlined = list;
                super(1);
            }

            @NotNull
            public final Sequence<Pair<String, Result>> invoke(@NotNull Map.Entry<? extends String, ? extends JavaScriptParser.ProgramContext> it) {
                Sequence sequence;
                Result result;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Map.Entry<? extends String, ? extends JavaScriptParser.ProgramContext> it2 = it;
                boolean bl = false;
                try {
                    result = LocatePositionsKt.locateInFile(this.$sites$inlined, it2.getKey(), it2.getValue());
                }
                catch (Exception ex) {
                    LocatePositionsKt.access$getLOGGER$p().debug("unable to visit AST of {}; skipping that portion of call graph", (Object)it2.getKey(), (Object)ex);
                    result = null;
                }
                Result r = result;
                if (r == null) {
                    sequence = SequencesKt.sequenceOf((Object[])new Pair[0]);
                } else {
                    Object[] objectArray = new Pair[]{TuplesKt.to((Object)it.getKey(), (Object)r)};
                    sequence = SequencesKt.sequenceOf((Object[])objectArray);
                }
                return sequence;
            }
        }));
        boolean $i$f$associate2 = false;
        Iterator iterator = $this$associate$iv$iv;
        Map destination$iv$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo2 = false;
        for (Object element$iv$iv$iv : $this$associateTo$iv$iv$iv) {
            Map map = destination$iv$iv$iv;
            Pair $dstr$k$v$iv = (Pair)element$iv$iv$iv;
            boolean bl = false;
            Object k$iv = $dstr$k$v$iv.component1();
            Object v$iv = $dstr$k$v$iv.component2();
            Pair pair = TuplesKt.to((Object)k$iv, (Object)v$iv);
            map.put(pair.getFirst(), pair.getSecond());
        }
        Map results = destination$iv$iv$iv;
        LOGGER.debug("located ASTs for {} files", (Object)results.keySet().size());
        Set callSites2 = SequencesKt.toSet((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)sites), (Function1)((Function1)new Function1<Coverage, Sequence<? extends CallSite>>((Map<String, Result>)results, projectRoot){
            final /* synthetic */ Map<String, Result> $results;
            final /* synthetic */ Path $projectRoot;
            {
                this.$results = $results;
                this.$projectRoot = $projectRoot;
                super(1);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @NotNull
            public final Sequence<CallSite> invoke(@NotNull Coverage site) {
                Object object;
                Iterable iterable;
                block9: {
                    block8: {
                        boolean bl;
                        block7: {
                            void $this$any$iv;
                            Intrinsics.checkNotNullParameter((Object)site, (String)"site");
                            if (!this.$results.containsKey(site.getResource())) break block8;
                            iterable = site.getCallers();
                            Map<String, Result> map = this.$results;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    CoverageCaller it = (CoverageCaller)element$iv;
                                    boolean bl2 = false;
                                    boolean bl3 = !map.containsKey(it.getResource());
                                    if (!bl3) continue;
                                    bl = true;
                                    break block7;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) break block9;
                    }
                    object = SequencesKt.sequenceOf((Object[])new CallSite[0]);
                    return object;
                }
                try {
                    Id callee = (Id)MapsKt.getValue(((Result)MapsKt.getValue(this.$results, (Object)site.getResource())).getCallees(), (Object)new Position(site.getLine() + 1, site.getColumn() + 1));
                    iterable = SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)site.getCallers()), (Function1)((Function1)new Function1<CoverageCaller, Sequence<? extends CallSite>>(this.$results, this.$projectRoot, callee){
                        final /* synthetic */ Map<String, Result> $results;
                        final /* synthetic */ Path $projectRoot;
                        final /* synthetic */ Id $callee;
                        {
                            this.$results = $results;
                            this.$projectRoot = $projectRoot;
                            this.$callee = $callee;
                            super(1);
                        }

                        @NotNull
                        public final Sequence<CallSite> invoke(@NotNull CoverageCaller it) {
                            Sequence sequence;
                            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                            Id caller = ((Result)MapsKt.getValue(this.$results, (Object)it.getResource())).getCallers().get(new Position(it.getLine(), it.getColumn()));
                            if (caller == null) {
                                sequence = SequencesKt.sequenceOf((Object[])new CallSite[0]);
                            } else {
                                Pair<String, Id> callerPair = VisitorUtils.INSTANCE.toModuleRelative(this.$projectRoot, caller);
                                Pair<String, Id> calleePair = VisitorUtils.INSTANCE.toModuleRelative(this.$projectRoot, this.$callee);
                                Object[] objectArray = new CallSite[]{new CallSite(new JSMethodInfo((String)callerPair.getFirst(), (Id)callerPair.getSecond()), new JSMethodInfo((String)calleePair.getFirst(), (Id)calleePair.getSecond()), (String)VisitorUtils.INSTANCE.toModuleRelative(this.$projectRoot, it.getResource()).getSecond(), it.getLine())};
                                sequence = SequencesKt.sequenceOf((Object[])objectArray);
                            }
                            return sequence;
                        }
                    }));
                }
                catch (Exception e) {
                    LocatePositionsKt.access$getLOGGER$p().debug("unable to put together call site", e);
                    iterable = SequencesKt.sequenceOf((Object[])new CallSite[0]);
                }
                object = iterable;
                return object;
            }
        })));
        LOGGER.debug("found {} call sites", (Object)callSites2.size());
        return callSites2;
    }

    public static /* synthetic */ Set coverageToCallSites$default(Path path, List list, AstCache astCache, int n, Object object) {
        if ((n & 4) != 0) {
            astCache = null;
        }
        return LocatePositionsKt.coverageToCallSites(path, list, astCache);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Result locateInFile(@NotNull List<Coverage> sites, @NotNull String file, @NotNull JavaScriptParser.ProgramContext ast) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Object it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter(sites, (String)"sites");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)((Object)ast), (String)"ast");
        Iterable iterable = sites;
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Coverage)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)((Coverage)it).getResource(), (Object)file)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (Coverage)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Position(((Coverage)it).getLine() + 1, ((Coverage)it).getColumn() + 1));
        }
        Set calleePositions = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set callerPositions2 = SequencesKt.toSet((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)sites), (Function1)((Function1)new Function1<Coverage, Sequence<? extends Position>>(file){
            final /* synthetic */ String $file;
            {
                this.$file = $file;
                super(1);
            }

            @NotNull
            public final Sequence<Position> invoke(@NotNull Coverage it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)it.getCallers()), (Function1)((Function1)new Function1<CoverageCaller, Boolean>(this.$file){
                    final /* synthetic */ String $file;
                    {
                        this.$file = $file;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull CoverageCaller it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it.getResource(), (Object)this.$file);
                    }
                })), (Function1)locateInFile.callerPositions.2.INSTANCE);
            }
        })));
        CalleeLocatingGenIdListener calleeLocator = new CalleeLocatingGenIdListener(calleePositions);
        CallerLocatingVisitor callerVisitor = new CallerLocatingVisitor(callerPositions2, file, calleeLocator);
        callerVisitor.visit((ParseTree)ast);
        Iterable $this$forEach$iv = calleePositions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Position)element$iv;
            boolean bl = false;
            if (calleeLocator.getResult().containsKey(it)) continue;
            Map<Position, Id> map = calleeLocator.getResult();
            Object object = new String[]{"global"};
            object = new Id(file, CollectionsKt.listOf((Object)new IdComponent.Identifier((String)object)));
            map.put((Position)it, (Id)object);
            if (((Position)it).getLine() == 1 && ((Position)it).getColumn() == 1 || ((Position)it).getLine() == 1 && ((Position)it).getColumn() == 11) continue;
            LOGGER.debug("matched callee {} to global in {}", it, (Object)file);
        }
        $this$forEach$iv = callerPositions2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Id nearestId;
            it = (Position)element$iv;
            boolean bl = false;
            if (callerVisitor.getResult().containsKey(it) || (nearestId = callerVisitor.nearestId((Position)it)) == null) continue;
            callerVisitor.getResult().put((Position)it, nearestId);
            LOGGER.debug("matched caller {} to {}", it, (Object)nearestId);
        }
        $this$forEach$iv = callerPositions2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Position)element$iv;
            boolean bl = false;
            if (callerVisitor.getResult().containsKey(it)) continue;
            LOGGER.debug("unmatched caller {} in {}", it, (Object)file);
        }
        return new Result(callerVisitor.getResult(), calleeLocator.getResult());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <K, V, R> Map<K, R> maybeMapValues(@NotNull Map<? extends K, ? extends V> $this$maybeMapValues, @NotNull Function1<? super Map.Entry<? extends K, ? extends V>, ? extends R> transform) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$maybeMapValues, (String)"<this>");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        boolean $i$f$maybeMapValues = false;
        Sequence $this$associate$iv = SequencesKt.flatMap((Sequence)MapsKt.asSequence($this$maybeMapValues), (Function1)new Function1<Map.Entry<? extends K, ? extends V>, Sequence<? extends Pair<? extends K, ? extends R>>>(transform){
            final /* synthetic */ Function1<Map.Entry<? extends K, ? extends V>, R> $transform;
            {
                this.$transform = $transform;
                super(1);
            }

            @NotNull
            public final Sequence<Pair<K, R>> invoke(@NotNull Map.Entry<? extends K, ? extends V> it) {
                Sequence sequence;
                Intrinsics.checkNotNullParameter(it, (String)"it");
                Object r = this.$transform.invoke(it);
                if (r == null) {
                    sequence = SequencesKt.sequenceOf((Object[])new Pair[0]);
                } else {
                    Object[] objectArray = new Pair[]{TuplesKt.to(it.getKey(), (Object)r)};
                    sequence = SequencesKt.sequenceOf((Object[])objectArray);
                }
                return sequence;
            }
        });
        boolean $i$f$associate = false;
        Sequence sequence = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            Pair $dstr$k$v = (Pair)element$iv$iv;
            boolean bl = false;
            Object k = $dstr$k$v.component1();
            Object v = $dstr$k$v.component2();
            Pair pair = TuplesKt.to((Object)k, (Object)v);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }

    public static final /* synthetic */ SecureLogger access$getLOGGER$p() {
        return LOGGER;
    }

    static {
        SecureLogger secureLogger = SecureLogger.getLogger(Coverage.class);
        Intrinsics.checkNotNullExpressionValue((Object)secureLogger, (String)"getLogger(Coverage::class.java)");
        LOGGER = secureLogger;
    }
}

