/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.analysis.latte.genids;

import com.sourceclear.analysis.latte.genids.IdComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J#\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001J\u0006\u0010\u0014\u001a\u00020\u0003J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/sourceclear/analysis/latte/genids/Id;", "", "filename", "", "components", "", "Lcom/sourceclear/analysis/latte/genids/IdComponent;", "(Ljava/lang/String;Ljava/util/List;)V", "getComponents", "()Ljava/util/List;", "getFilename", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "idComponentsToString", "toString", "Companion", "common"})
public final class Id {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String filename;
    @NotNull
    private final List<IdComponent> components;
    @NotNull
    private static final String filenameDelimiter = ":";
    @NotNull
    public static final String nameDelimiter = ".";
    @NotNull
    public static final String classSuffix = "#";
    @NotNull
    public static final String functionSuffix = "()";
    @NotNull
    public static final String identifierSuffix = "*";
    @NotNull
    public static final String anonymousFunctionPrefix = "%";
    @NotNull
    private static final IdComponent.Identifier globalIdentifier;
    @NotNull
    private static final Regex jsIdentifierRegex;

    public Id(@NotNull String filename, @NotNull List<? extends IdComponent> components) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        this.filename = filename;
        this.components = components;
    }

    @NotNull
    public final String getFilename() {
        return this.filename;
    }

    @NotNull
    public final List<IdComponent> getComponents() {
        return this.components;
    }

    @NotNull
    public String toString() {
        return this.filename + ':' + this.idComponentsToString();
    }

    @NotNull
    public final String idComponentsToString() {
        return CollectionsKt.joinToString$default((Iterable)this.components, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
    }

    @NotNull
    public final String component1() {
        return this.filename;
    }

    @NotNull
    public final List<IdComponent> component2() {
        return this.components;
    }

    @NotNull
    public final Id copy(@NotNull String filename, @NotNull List<? extends IdComponent> components) {
        Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
        Intrinsics.checkNotNullParameter(components, (String)"components");
        return new Id(filename, components);
    }

    public static /* synthetic */ Id copy$default(Id id, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = id.filename;
        }
        if ((n & 2) != 0) {
            list = id.components;
        }
        return id.copy(string, list);
    }

    public int hashCode() {
        int result = this.filename.hashCode();
        result = result * 31 + ((Object)this.components).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Id)) {
            return false;
        }
        Id id = (Id)other;
        if (!Intrinsics.areEqual((Object)this.filename, (Object)id.filename)) {
            return false;
        }
        return Intrinsics.areEqual(this.components, id.components);
    }

    static {
        String[] stringArray = new String[]{"global"};
        globalIdentifier = new IdComponent.Identifier(stringArray);
        jsIdentifierRegex = new Regex("[_a-z-A-Z$][_a-zA-Z0-9$]*");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0015\u001a\u00020\u0004J\u001c\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/sourceclear/analysis/latte/genids/Id$Companion;", "", "()V", "anonymousFunctionPrefix", "", "classSuffix", "filenameDelimiter", "functionSuffix", "globalIdentifier", "Lcom/sourceclear/analysis/latte/genids/IdComponent$Identifier;", "getGlobalIdentifier", "()Lcom/sourceclear/analysis/latte/genids/IdComponent$Identifier;", "identifierSuffix", "jsIdentifierRegex", "Lkotlin/text/Regex;", "getJsIdentifierRegex", "()Lkotlin/text/Regex;", "nameDelimiter", "parse", "Ljava/util/Optional;", "Lcom/sourceclear/analysis/latte/genids/Id;", "signature", "parseIdComponents", "filename", "idList", "common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final IdComponent.Identifier getGlobalIdentifier() {
            return globalIdentifier;
        }

        @NotNull
        public final Regex getJsIdentifierRegex() {
            return jsIdentifierRegex;
        }

        @NotNull
        public final Optional<Id> parse(@NotNull String signature) {
            Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
            if (((CharSequence)((Object)StringsKt.trim((CharSequence)signature)).toString()).length() == 0) {
                Optional<Id> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
                return optional;
            }
            int index = StringsKt.indexOf$default((CharSequence)signature, (String)Id.filenameDelimiter, (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                Optional<Id> optional = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional, (String)"empty()");
                return optional;
            }
            Object object = signature;
            int n = 0;
            String string = ((String)object).substring(n, index);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String filename = string;
            if (StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)filename)).toString())) {
                object = Optional.empty();
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"empty()");
                return object;
            }
            String string2 = signature;
            int n2 = index + 1;
            String string3 = string2.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            String idList = string3;
            return this.parseIdComponents(filename, idList);
        }

        @NotNull
        public final Optional<Id> parseIdComponents(@NotNull String filename, @NotNull String idList) {
            Optional<Id> optional;
            Optional<Id> optional2;
            Intrinsics.checkNotNullParameter((Object)filename, (String)"filename");
            Intrinsics.checkNotNullParameter((Object)idList, (String)"idList");
            List idComponentList = new ArrayList();
            int start = 0;
            while (start < idList.length()) {
                IdComponent idComponent;
                Pair pair;
                Optional<Id> optional3;
                int n;
                String string;
                Object[] objectArray = new String[]{Id.classSuffix, Id.functionSuffix, Id.identifierSuffix};
                Pair result = StringsKt.findAnyOf$default((CharSequence)idList, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)start, (boolean)false, (int)4, null);
                if (result != null) {
                    string = idList;
                    n = ((Number)result.getFirst()).intValue() + ((String)result.getSecond()).length();
                    optional3 = string.substring(start, n);
                    Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    pair = TuplesKt.to((Object)optional3, (Object)(((Number)result.getFirst()).intValue() + ((String)result.getSecond()).length()));
                } else {
                    string = idList;
                    n = idList.length();
                    optional3 = string.substring(start, n);
                    Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    pair = TuplesKt.to((Object)optional3, (Object)idList.length());
                }
                Pair pair2 = pair;
                start = ((Number)pair2.getSecond()).intValue();
                String idStr = (String)pair2.getFirst();
                if (StringsKt.startsWith$default((String)idStr, (String)Id.anonymousFunctionPrefix, (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)idStr, (String)Id.functionSuffix, (boolean)false, (int)2, null)) {
                    idComponent = IdComponent.AnonymousFunction.Companion.parse(idStr);
                } else if (StringsKt.endsWith$default((String)idStr, (String)Id.classSuffix, (boolean)false, (int)2, null)) {
                    idComponent = IdComponent.Class.Companion.parse(idStr);
                } else if (StringsKt.endsWith$default((String)idStr, (String)Id.functionSuffix, (boolean)false, (int)2, null)) {
                    idComponent = IdComponent.Function.Companion.parse(idStr);
                } else if (StringsKt.endsWith$default((String)idStr, (String)Id.identifierSuffix, (boolean)false, (int)2, null)) {
                    idComponent = IdComponent.Identifier.Companion.parse(idStr);
                } else {
                    optional3 = Optional.empty();
                    Intrinsics.checkNotNullExpressionValue(optional3, (String)"empty()");
                    return optional3;
                }
                IdComponent component = idComponent;
                if (component == null) {
                    optional3 = Optional.empty();
                    Intrinsics.checkNotNullExpressionValue((Object)optional3, (String)"empty()");
                    return optional3;
                }
                idComponentList.add(component);
            }
            if (idComponentList.isEmpty()) {
                optional2 = Optional.empty();
                Intrinsics.checkNotNullExpressionValue(optional2, (String)"{\n        Optional.empty()\n      }");
                optional = optional2;
            } else {
                optional2 = Optional.of(new Id(filename, idComponentList));
                Intrinsics.checkNotNullExpressionValue(optional2, (String)"{\n        Optional.of(Id\u2026idComponentList))\n      }");
                optional = optional2;
            }
            return optional;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

