/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sourceclear.api.data.events.UserModel;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.LongUnaryOperator;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class UserModel_Builder {
    private long id;
    private String name = null;
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    UserModel_Builder() {
    }

    public static UserModel.Builder from(UserModel value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new UserModel.Builder().mergeFrom(value);
    }

    @JsonProperty(value="id")
    public UserModel.Builder setId(long id) {
        this.id = id;
        this._unsetProperties.remove((Object)Property.ID);
        return (UserModel.Builder)this;
    }

    public UserModel.Builder mapId(LongUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        return this.setId(mapper.applyAsLong(this.getId()));
    }

    public long getId() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.ID) ? 1 : 0) != 0, (Object)"id not set");
        return this.id;
    }

    public UserModel.Builder setName(String name) {
        this.name = Objects.requireNonNull(name);
        return (UserModel.Builder)this;
    }

    @JsonProperty(value="name")
    public UserModel.Builder setName(Optional<? extends String> name) {
        if (name.isPresent()) {
            return this.setName(name.get());
        }
        return this.clearName();
    }

    public UserModel.Builder setNullableName(@Nullable String name) {
        if (name != null) {
            return this.setName(name);
        }
        return this.clearName();
    }

    public UserModel.Builder mapName(UnaryOperator<String> mapper) {
        return this.setName(this.getName().map(mapper));
    }

    public UserModel.Builder clearName() {
        this.name = null;
        return (UserModel.Builder)this;
    }

    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public UserModel.Builder mergeFrom(UserModel value) {
        UserModel.Builder defaults = new UserModel.Builder();
        if (defaults._unsetProperties.contains((Object)Property.ID) || value.getId() != ((UserModel_Builder)defaults).getId()) {
            this.setId(value.getId());
        }
        value.getName().ifPresent(this::setName);
        return (UserModel.Builder)this;
    }

    public UserModel.Builder mergeFrom(UserModel.Builder template) {
        UserModel.Builder base = template;
        UserModel.Builder defaults = new UserModel.Builder();
        if (!base._unsetProperties.contains((Object)Property.ID) && (defaults._unsetProperties.contains((Object)Property.ID) || template.getId() != ((UserModel_Builder)defaults).getId())) {
            this.setId(template.getId());
        }
        template.getName().ifPresent(this::setName);
        return (UserModel.Builder)this;
    }

    public UserModel.Builder clear() {
        UserModel.Builder defaults = new UserModel.Builder();
        this.id = defaults.id;
        this.name = defaults.name;
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (UserModel.Builder)this;
    }

    public UserModel build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public UserModel buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final long id;
        private final String name;
        private final EnumSet<Property> _unsetProperties;

        Partial(UserModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            if (this._unsetProperties.contains((Object)Property.ID)) {
                throw new UnsupportedOperationException("id not set");
            }
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        @Override
        public UserModel.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((UserModel_Builder)builder).id = this.id;
            ((UserModel_Builder)builder).name = this.name;
            ((UserModel_Builder)builder)._unsetProperties.clear();
            ((UserModel_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return this.id == other.id && Objects.equals(this.name, other.name) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial UserModel{");
            String separator = "";
            if (!this._unsetProperties.contains((Object)Property.ID)) {
                result.append("id=").append(this.id);
                separator = ", ";
            }
            if (this.name != null) {
                result.append(separator).append("name=").append(this.name);
            }
            return result.append("}").toString();
        }

        private static class PartialBuilder
        extends UserModel.Builder {
            private PartialBuilder() {
            }

            @Override
            public UserModel build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final long id;
        private final String name;

        private Value(UserModel_Builder builder) {
            this.id = builder.id;
            this.name = builder.name;
        }

        @Override
        @JsonProperty(value="id")
        public long getId() {
            return this.id;
        }

        @Override
        @JsonProperty(value="name")
        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        @Override
        public UserModel.Builder toBuilder() {
            UserModel.Builder builder = new UserModel.Builder();
            ((UserModel_Builder)builder).id = this.id;
            ((UserModel_Builder)builder).name = this.name;
            ((UserModel_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return this.id == other.id && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return Objects.hash(this.id, this.name);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("UserModel{id=").append(this.id);
            if (this.name != null) {
                result.append(", name=").append(this.name);
            }
            return result.append("}").toString();
        }
    }

    private static abstract class Rebuildable
    implements UserModel {
        private Rebuildable() {
        }

        public abstract UserModel.Builder toBuilder();
    }

    private static enum Property {
        ID("id");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

