/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.evidence;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.sourceclear.api.data.evidence.LibraryInstanceHash;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

abstract class LibraryInstanceHash_Builder {
    private String sha1 = null;
    private String sha2 = null;
    private String bytecodeHash = null;
    private String filename = null;

    LibraryInstanceHash_Builder() {
    }

    public static LibraryInstanceHash.Builder from(LibraryInstanceHash value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new LibraryInstanceHash.Builder().mergeFrom(value);
    }

    public LibraryInstanceHash.Builder setSha1(String sha1) {
        this.sha1 = Objects.requireNonNull(sha1);
        return (LibraryInstanceHash.Builder)this;
    }

    @JsonProperty(value="sha1")
    public LibraryInstanceHash.Builder setSha1(Optional<? extends String> sha1) {
        if (sha1.isPresent()) {
            return this.setSha1(sha1.get());
        }
        return this.clearSha1();
    }

    public LibraryInstanceHash.Builder setNullableSha1(@Nullable String sha1) {
        if (sha1 != null) {
            return this.setSha1(sha1);
        }
        return this.clearSha1();
    }

    public LibraryInstanceHash.Builder mapSha1(UnaryOperator<String> mapper) {
        return this.setSha1(this.getSha1().map(mapper));
    }

    public LibraryInstanceHash.Builder clearSha1() {
        this.sha1 = null;
        return (LibraryInstanceHash.Builder)this;
    }

    public Optional<String> getSha1() {
        return Optional.ofNullable(this.sha1);
    }

    public LibraryInstanceHash.Builder setSha2(String sha2) {
        this.sha2 = Objects.requireNonNull(sha2);
        return (LibraryInstanceHash.Builder)this;
    }

    @JsonProperty(value="sha2")
    public LibraryInstanceHash.Builder setSha2(Optional<? extends String> sha2) {
        if (sha2.isPresent()) {
            return this.setSha2(sha2.get());
        }
        return this.clearSha2();
    }

    public LibraryInstanceHash.Builder setNullableSha2(@Nullable String sha2) {
        if (sha2 != null) {
            return this.setSha2(sha2);
        }
        return this.clearSha2();
    }

    public LibraryInstanceHash.Builder mapSha2(UnaryOperator<String> mapper) {
        return this.setSha2(this.getSha2().map(mapper));
    }

    public LibraryInstanceHash.Builder clearSha2() {
        this.sha2 = null;
        return (LibraryInstanceHash.Builder)this;
    }

    public Optional<String> getSha2() {
        return Optional.ofNullable(this.sha2);
    }

    public LibraryInstanceHash.Builder setBytecodeHash(String bytecodeHash) {
        this.bytecodeHash = Objects.requireNonNull(bytecodeHash);
        return (LibraryInstanceHash.Builder)this;
    }

    @JsonProperty(value="bytecodeHash")
    public LibraryInstanceHash.Builder setBytecodeHash(Optional<? extends String> bytecodeHash) {
        if (bytecodeHash.isPresent()) {
            return this.setBytecodeHash(bytecodeHash.get());
        }
        return this.clearBytecodeHash();
    }

    public LibraryInstanceHash.Builder setNullableBytecodeHash(@Nullable String bytecodeHash) {
        if (bytecodeHash != null) {
            return this.setBytecodeHash(bytecodeHash);
        }
        return this.clearBytecodeHash();
    }

    public LibraryInstanceHash.Builder mapBytecodeHash(UnaryOperator<String> mapper) {
        return this.setBytecodeHash(this.getBytecodeHash().map(mapper));
    }

    public LibraryInstanceHash.Builder clearBytecodeHash() {
        this.bytecodeHash = null;
        return (LibraryInstanceHash.Builder)this;
    }

    public Optional<String> getBytecodeHash() {
        return Optional.ofNullable(this.bytecodeHash);
    }

    public LibraryInstanceHash.Builder setFilename(String filename) {
        this.filename = Objects.requireNonNull(filename);
        return (LibraryInstanceHash.Builder)this;
    }

    @JsonProperty(value="filename")
    public LibraryInstanceHash.Builder setFilename(Optional<? extends String> filename) {
        if (filename.isPresent()) {
            return this.setFilename(filename.get());
        }
        return this.clearFilename();
    }

    public LibraryInstanceHash.Builder setNullableFilename(@Nullable String filename) {
        if (filename != null) {
            return this.setFilename(filename);
        }
        return this.clearFilename();
    }

    public LibraryInstanceHash.Builder mapFilename(UnaryOperator<String> mapper) {
        return this.setFilename(this.getFilename().map(mapper));
    }

    public LibraryInstanceHash.Builder clearFilename() {
        this.filename = null;
        return (LibraryInstanceHash.Builder)this;
    }

    public Optional<String> getFilename() {
        return Optional.ofNullable(this.filename);
    }

    public LibraryInstanceHash.Builder mergeFrom(LibraryInstanceHash value) {
        value.getSha1().ifPresent(this::setSha1);
        value.getSha2().ifPresent(this::setSha2);
        value.getBytecodeHash().ifPresent(this::setBytecodeHash);
        value.getFilename().ifPresent(this::setFilename);
        return (LibraryInstanceHash.Builder)this;
    }

    public LibraryInstanceHash.Builder mergeFrom(LibraryInstanceHash.Builder template) {
        template.getSha1().ifPresent(this::setSha1);
        template.getSha2().ifPresent(this::setSha2);
        template.getBytecodeHash().ifPresent(this::setBytecodeHash);
        template.getFilename().ifPresent(this::setFilename);
        return (LibraryInstanceHash.Builder)this;
    }

    public LibraryInstanceHash.Builder clear() {
        LibraryInstanceHash.Builder defaults = new LibraryInstanceHash.Builder();
        this.sha1 = defaults.sha1;
        this.sha2 = defaults.sha2;
        this.bytecodeHash = defaults.bytecodeHash;
        this.filename = defaults.filename;
        return (LibraryInstanceHash.Builder)this;
    }

    public LibraryInstanceHash build() {
        return new Value(this);
    }

    @VisibleForTesting
    public LibraryInstanceHash buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final String sha1;
        private final String sha2;
        private final String bytecodeHash;
        private final String filename;

        Partial(LibraryInstanceHash_Builder builder) {
            this.sha1 = builder.sha1;
            this.sha2 = builder.sha2;
            this.bytecodeHash = builder.bytecodeHash;
            this.filename = builder.filename;
        }

        @Override
        @JsonProperty(value="sha1")
        public Optional<String> getSha1() {
            return Optional.ofNullable(this.sha1);
        }

        @Override
        @JsonProperty(value="sha2")
        public Optional<String> getSha2() {
            return Optional.ofNullable(this.sha2);
        }

        @Override
        @JsonProperty(value="bytecodeHash")
        public Optional<String> getBytecodeHash() {
            return Optional.ofNullable(this.bytecodeHash);
        }

        @Override
        @JsonProperty(value="filename")
        public Optional<String> getFilename() {
            return Optional.ofNullable(this.filename);
        }

        @Override
        public LibraryInstanceHash.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((LibraryInstanceHash_Builder)builder).sha1 = this.sha1;
            ((LibraryInstanceHash_Builder)builder).sha2 = this.sha2;
            ((LibraryInstanceHash_Builder)builder).bytecodeHash = this.bytecodeHash;
            ((LibraryInstanceHash_Builder)builder).filename = this.filename;
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.sha1, other.sha1) && Objects.equals(this.sha2, other.sha2) && Objects.equals(this.bytecodeHash, other.bytecodeHash) && Objects.equals(this.filename, other.filename);
        }

        public int hashCode() {
            return Objects.hash(this.sha1, this.sha2, this.bytecodeHash, this.filename);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial LibraryInstanceHash{");
            String separator = "";
            if (this.sha1 != null) {
                result.append("sha1=").append(this.sha1);
                separator = ", ";
            }
            if (this.sha2 != null) {
                result.append(separator).append("sha2=").append(this.sha2);
                separator = ", ";
            }
            if (this.bytecodeHash != null) {
                result.append(separator).append("bytecodeHash=").append(this.bytecodeHash);
                separator = ", ";
            }
            if (this.filename != null) {
                result.append(separator).append("filename=").append(this.filename);
            }
            return result.append("}").toString();
        }

        private static class PartialBuilder
        extends LibraryInstanceHash.Builder {
            private PartialBuilder() {
            }

            @Override
            public LibraryInstanceHash build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final String sha1;
        private final String sha2;
        private final String bytecodeHash;
        private final String filename;

        private Value(LibraryInstanceHash_Builder builder) {
            this.sha1 = builder.sha1;
            this.sha2 = builder.sha2;
            this.bytecodeHash = builder.bytecodeHash;
            this.filename = builder.filename;
        }

        @Override
        @JsonProperty(value="sha1")
        public Optional<String> getSha1() {
            return Optional.ofNullable(this.sha1);
        }

        @Override
        @JsonProperty(value="sha2")
        public Optional<String> getSha2() {
            return Optional.ofNullable(this.sha2);
        }

        @Override
        @JsonProperty(value="bytecodeHash")
        public Optional<String> getBytecodeHash() {
            return Optional.ofNullable(this.bytecodeHash);
        }

        @Override
        @JsonProperty(value="filename")
        public Optional<String> getFilename() {
            return Optional.ofNullable(this.filename);
        }

        @Override
        public LibraryInstanceHash.Builder toBuilder() {
            LibraryInstanceHash.Builder builder = new LibraryInstanceHash.Builder();
            ((LibraryInstanceHash_Builder)builder).sha1 = this.sha1;
            ((LibraryInstanceHash_Builder)builder).sha2 = this.sha2;
            ((LibraryInstanceHash_Builder)builder).bytecodeHash = this.bytecodeHash;
            ((LibraryInstanceHash_Builder)builder).filename = this.filename;
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.sha1, other.sha1) && Objects.equals(this.sha2, other.sha2) && Objects.equals(this.bytecodeHash, other.bytecodeHash) && Objects.equals(this.filename, other.filename);
        }

        public int hashCode() {
            return Objects.hash(this.sha1, this.sha2, this.bytecodeHash, this.filename);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("LibraryInstanceHash{");
            String separator = "";
            if (this.sha1 != null) {
                result.append("sha1=").append(this.sha1);
                separator = ", ";
            }
            if (this.sha2 != null) {
                result.append(separator).append("sha2=").append(this.sha2);
                separator = ", ";
            }
            if (this.bytecodeHash != null) {
                result.append(separator).append("bytecodeHash=").append(this.bytecodeHash);
                separator = ", ";
            }
            if (this.filename != null) {
                result.append(separator).append("filename=").append(this.filename);
            }
            return result.append("}").toString();
        }
    }

    private static abstract class Rebuildable
    implements LibraryInstanceHash {
        private Rebuildable() {
        }

        public abstract LibraryInstanceHash.Builder toBuilder();
    }
}

