/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.match;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sourceclear.api.data.match.LibDeltaQuery_Builder;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;

@JsonDeserialize(builder=Builder.class)
public interface LibDeltaQuery {
    public Set<QueryPair> getQueryPairs();

    public static class Builder
    extends LibDeltaQuery_Builder {
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class QueryPair {
        @JsonProperty
        private String from;
        @JsonProperty
        private String to;
        @JsonProperty
        private long libraryId;

        QueryPair() {
        }

        public QueryPair(@Nonnull String from, @Nonnull String to, long libraryId) {
            this.from = from;
            this.to = to;
            this.libraryId = libraryId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            QueryPair queryPair = (QueryPair)o;
            return Objects.equals(this.from, queryPair.from) && Objects.equals(this.to, queryPair.to) && Objects.equals(this.libraryId, queryPair.libraryId);
        }

        public int hashCode() {
            return Objects.hash(this.from, this.to, this.libraryId);
        }

        public String toString() {
            return "QueryPair{from='" + this.from + '\'' + ", to='" + this.to + '\'' + ", libraryId='" + this.libraryId + '\'' + '}';
        }

        @Nonnull
        public String getFrom() {
            return this.from;
        }

        @Nonnull
        public String getTo() {
            return this.to;
        }

        public long getLibraryId() {
            return this.libraryId;
        }
    }
}

