/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.api.data.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.primitives.Longs;
import com.sourceclear.api.data.methods.InstanceVulnMethod;
import com.sourceclear.api.data.methods.MethodCallData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.BaseStream;

abstract class InstanceVulnMethod_Builder {
    private String libraryInstanceRef;
    private NavigableSet<Long> artifactIds = null;
    private List<MethodCallData> methods = ImmutableList.of();
    private final EnumSet<Property> _unsetProperties = EnumSet.allOf(Property.class);

    InstanceVulnMethod_Builder() {
    }

    public static InstanceVulnMethod.Builder from(InstanceVulnMethod value) {
        if (value instanceof Rebuildable) {
            return ((Rebuildable)value).toBuilder();
        }
        return new InstanceVulnMethod.Builder().mergeFrom(value);
    }

    @JsonProperty(value="libraryInstanceRef")
    public InstanceVulnMethod.Builder setLibraryInstanceRef(String libraryInstanceRef) {
        this.libraryInstanceRef = Objects.requireNonNull(libraryInstanceRef);
        this._unsetProperties.remove((Object)Property.LIBRARY_INSTANCE_REF);
        return (InstanceVulnMethod.Builder)this;
    }

    public InstanceVulnMethod.Builder mapLibraryInstanceRef(UnaryOperator<String> mapper) {
        Objects.requireNonNull(mapper);
        return this.setLibraryInstanceRef((String)mapper.apply(this.getLibraryInstanceRef()));
    }

    public String getLibraryInstanceRef() {
        Preconditions.checkState((!this._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF) ? 1 : 0) != 0, (Object)"libraryInstanceRef not set");
        return this.libraryInstanceRef;
    }

    protected InstanceVulnMethod.Builder setComparatorForArtifactIds(Comparator<? super Long> comparator) {
        Preconditions.checkState((this.artifactIds == null ? 1 : 0) != 0, (String)"Comparator already set for %s", this.artifactIds);
        this.artifactIds = comparator == null ? ImmutableSortedSet.of() : new ImmutableSortedSet.Builder(comparator).build();
        return (InstanceVulnMethod.Builder)this;
    }

    public InstanceVulnMethod.Builder addArtifactIds(long element) {
        if (this.artifactIds == null) {
            this.artifactIds = new TreeSet<Long>();
        } else if (this.artifactIds instanceof ImmutableSortedSet) {
            this.artifactIds = new TreeSet<Long>((SortedSet<Long>)this.artifactIds);
        }
        this.artifactIds.add(element);
        return (InstanceVulnMethod.Builder)this;
    }

    public InstanceVulnMethod.Builder addArtifactIds(long ... elements) {
        return this.addAllArtifactIds(Longs.asList((long[])elements));
    }

    public InstanceVulnMethod.Builder addAllArtifactIds(Spliterator<? extends Long> elements) {
        elements.forEachRemaining(this::addArtifactIds);
        return (InstanceVulnMethod.Builder)this;
    }

    public InstanceVulnMethod.Builder addAllArtifactIds(BaseStream<? extends Long, ?> elements) {
        return this.addAllArtifactIds(elements.spliterator());
    }

    @JsonProperty(value="artifactIds")
    public InstanceVulnMethod.Builder addAllArtifactIds(Iterable<? extends Long> elements) {
        elements.forEach(this::addArtifactIds);
        return (InstanceVulnMethod.Builder)this;
    }

    public InstanceVulnMethod.Builder removeArtifactIds(long element) {
        if (this.artifactIds == null) {
            this.artifactIds = new TreeSet<Long>();
        } else if (this.artifactIds instanceof ImmutableSortedSet) {
            this.artifactIds = new TreeSet<Long>((SortedSet<Long>)this.artifactIds);
        }
        this.artifactIds.remove(element);
        return (InstanceVulnMethod.Builder)this;
    }

    public InstanceVulnMethod.Builder mutateArtifactIds(Consumer<? super SortedSet<Long>> mutator) {
        if (this.artifactIds == null) {
            this.artifactIds = new TreeSet<Long>();
        } else if (this.artifactIds instanceof ImmutableSortedSet) {
            this.artifactIds = new TreeSet<Long>((SortedSet<Long>)this.artifactIds);
        }
        mutator.accept(this.artifactIds);
        return (InstanceVulnMethod.Builder)this;
    }

    public InstanceVulnMethod.Builder clearArtifactIds() {
        if (this.artifactIds instanceof ImmutableSortedSet) {
            if (!this.artifactIds.isEmpty()) {
                this.artifactIds = this.artifactIds.comparator() != null ? new ImmutableSortedSet.Builder(this.artifactIds.comparator()).build() : ImmutableSortedSet.of();
            }
        } else if (this.artifactIds != null) {
            this.artifactIds.clear();
        }
        return (InstanceVulnMethod.Builder)this;
    }

    public SortedSet<Long> getArtifactIds() {
        if (this.artifactIds == null) {
            this.artifactIds = new TreeSet<Long>();
        } else if (this.artifactIds instanceof ImmutableSortedSet) {
            this.artifactIds = new TreeSet<Long>((SortedSet<Long>)this.artifactIds);
        }
        return Collections.unmodifiableSortedSet(this.artifactIds);
    }

    public InstanceVulnMethod.Builder addMethods(MethodCallData element) {
        if (this.methods instanceof ImmutableList) {
            this.methods = new ArrayList<MethodCallData>(this.methods);
        }
        this.methods.add(Objects.requireNonNull(element));
        return (InstanceVulnMethod.Builder)this;
    }

    public InstanceVulnMethod.Builder addMethods(MethodCallData ... elements) {
        return this.addAllMethods(Arrays.asList(elements));
    }

    public InstanceVulnMethod.Builder addAllMethods(Spliterator<? extends MethodCallData> elements) {
        long elementsSize;
        if ((elements.characteristics() & 0x40) != 0 && (elementsSize = elements.estimateSize()) > 0L && elementsSize <= Integer.MAX_VALUE) {
            if (this.methods instanceof ImmutableList) {
                this.methods = new ArrayList<MethodCallData>(this.methods);
            }
            ((ArrayList)this.methods).ensureCapacity(this.methods.size() + (int)elementsSize);
        }
        elements.forEachRemaining(this::addMethods);
        return (InstanceVulnMethod.Builder)this;
    }

    public InstanceVulnMethod.Builder addAllMethods(BaseStream<? extends MethodCallData, ?> elements) {
        return this.addAllMethods(elements.spliterator());
    }

    @JsonProperty(value="methods")
    public InstanceVulnMethod.Builder addAllMethods(Iterable<? extends MethodCallData> elements) {
        return this.addAllMethods(elements.spliterator());
    }

    public InstanceVulnMethod.Builder mutateMethods(Consumer<? super List<MethodCallData>> mutator) {
        if (this.methods instanceof ImmutableList) {
            this.methods = new ArrayList<MethodCallData>(this.methods);
        }
        mutator.accept(this.methods);
        return (InstanceVulnMethod.Builder)this;
    }

    public InstanceVulnMethod.Builder clearMethods() {
        if (this.methods instanceof ImmutableList) {
            this.methods = ImmutableList.of();
        } else {
            this.methods.clear();
        }
        return (InstanceVulnMethod.Builder)this;
    }

    public List<MethodCallData> getMethods() {
        if (this.methods instanceof ImmutableList) {
            this.methods = new ArrayList<MethodCallData>(this.methods);
        }
        return Collections.unmodifiableList(this.methods);
    }

    public InstanceVulnMethod.Builder mergeFrom(InstanceVulnMethod value) {
        InstanceVulnMethod.Builder defaults = new InstanceVulnMethod.Builder();
        if (defaults._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF) || !Objects.equals(value.getLibraryInstanceRef(), ((InstanceVulnMethod_Builder)defaults).getLibraryInstanceRef())) {
            this.setLibraryInstanceRef(value.getLibraryInstanceRef());
        }
        if (value instanceof Value && (this.artifactIds == null || this.artifactIds instanceof ImmutableSortedSet && this.artifactIds.isEmpty() && Objects.equals(this.artifactIds.comparator(), value.getArtifactIds().comparator()))) {
            ImmutableSortedSet _temporary;
            this.artifactIds = _temporary = (ImmutableSortedSet)value.getArtifactIds();
        } else {
            this.addAllArtifactIds(value.getArtifactIds());
        }
        if (value instanceof Value && this.methods == ImmutableList.of()) {
            this.methods = ImmutableList.copyOf(value.getMethods());
        } else {
            this.addAllMethods(value.getMethods());
        }
        return (InstanceVulnMethod.Builder)this;
    }

    public InstanceVulnMethod.Builder mergeFrom(InstanceVulnMethod.Builder template) {
        InstanceVulnMethod.Builder base = template;
        InstanceVulnMethod.Builder defaults = new InstanceVulnMethod.Builder();
        if (!(base._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF) || !defaults._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF) && Objects.equals(template.getLibraryInstanceRef(), ((InstanceVulnMethod_Builder)defaults).getLibraryInstanceRef()))) {
            this.setLibraryInstanceRef(template.getLibraryInstanceRef());
        }
        if (base.artifactIds != null) {
            this.addAllArtifactIds(base.artifactIds);
        }
        this.addAllMethods(base.methods);
        return (InstanceVulnMethod.Builder)this;
    }

    public InstanceVulnMethod.Builder clear() {
        InstanceVulnMethod.Builder defaults = new InstanceVulnMethod.Builder();
        this.libraryInstanceRef = defaults.libraryInstanceRef;
        this.clearArtifactIds();
        this.clearMethods();
        this._unsetProperties.clear();
        this._unsetProperties.addAll(defaults._unsetProperties);
        return (InstanceVulnMethod.Builder)this;
    }

    public InstanceVulnMethod build() {
        Preconditions.checkState((boolean)this._unsetProperties.isEmpty(), (String)"Not set: %s", this._unsetProperties);
        return new Value(this);
    }

    @VisibleForTesting
    public InstanceVulnMethod buildPartial() {
        return new Partial(this);
    }

    private static final class Partial
    extends Rebuildable {
        private final String libraryInstanceRef;
        private final ImmutableSortedSet<Long> artifactIds;
        private final ImmutableList<MethodCallData> methods;
        private final EnumSet<Property> _unsetProperties;

        Partial(InstanceVulnMethod_Builder builder) {
            this.libraryInstanceRef = builder.libraryInstanceRef;
            this.artifactIds = builder.artifactIds == null ? ImmutableSortedSet.of() : (builder.artifactIds instanceof ImmutableSortedSet ? (ImmutableSortedSet)builder.artifactIds : ImmutableSortedSet.copyOfSorted((SortedSet)builder.artifactIds));
            this.methods = ImmutableList.copyOf((Collection)builder.methods);
            this._unsetProperties = builder._unsetProperties.clone();
        }

        @Override
        @JsonProperty(value="libraryInstanceRef")
        public String getLibraryInstanceRef() {
            if (this._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF)) {
                throw new UnsupportedOperationException("libraryInstanceRef not set");
            }
            return this.libraryInstanceRef;
        }

        @Override
        @JsonProperty(value="artifactIds")
        public SortedSet<Long> getArtifactIds() {
            return this.artifactIds;
        }

        @Override
        @JsonProperty(value="methods")
        public List<MethodCallData> getMethods() {
            return this.methods;
        }

        @Override
        public InstanceVulnMethod.Builder toBuilder() {
            PartialBuilder builder = new PartialBuilder();
            ((InstanceVulnMethod_Builder)builder).libraryInstanceRef = this.libraryInstanceRef;
            ((InstanceVulnMethod_Builder)builder).artifactIds = this.artifactIds;
            ((InstanceVulnMethod_Builder)builder).methods = this.methods;
            ((InstanceVulnMethod_Builder)builder)._unsetProperties.clear();
            ((InstanceVulnMethod_Builder)builder)._unsetProperties.addAll(this._unsetProperties);
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Partial)) {
                return false;
            }
            Partial other = (Partial)obj;
            return Objects.equals(this.libraryInstanceRef, other.libraryInstanceRef) && Objects.equals(this.artifactIds, other.artifactIds) && Objects.equals(this.methods, other.methods) && Objects.equals(this._unsetProperties, other._unsetProperties);
        }

        public int hashCode() {
            return Objects.hash(this.libraryInstanceRef, this.artifactIds, this.methods, this._unsetProperties);
        }

        public String toString() {
            StringBuilder result = new StringBuilder("partial InstanceVulnMethod{");
            if (!this._unsetProperties.contains((Object)Property.LIBRARY_INSTANCE_REF)) {
                result.append("libraryInstanceRef=").append(this.libraryInstanceRef).append(", ");
            }
            return result.append("artifactIds=").append(this.artifactIds).append(", methods=").append(this.methods).append("}").toString();
        }

        private static class PartialBuilder
        extends InstanceVulnMethod.Builder {
            private PartialBuilder() {
            }

            @Override
            public InstanceVulnMethod build() {
                return this.buildPartial();
            }
        }
    }

    private static final class Value
    extends Rebuildable {
        private final String libraryInstanceRef;
        private final ImmutableSortedSet<Long> artifactIds;
        private final ImmutableList<MethodCallData> methods;

        private Value(InstanceVulnMethod_Builder builder) {
            this.libraryInstanceRef = builder.libraryInstanceRef;
            this.artifactIds = builder.artifactIds == null ? ImmutableSortedSet.of() : (builder.artifactIds instanceof ImmutableSortedSet ? (ImmutableSortedSet)builder.artifactIds : ImmutableSortedSet.copyOfSorted((SortedSet)builder.artifactIds));
            this.methods = ImmutableList.copyOf((Collection)builder.methods);
        }

        @Override
        @JsonProperty(value="libraryInstanceRef")
        public String getLibraryInstanceRef() {
            return this.libraryInstanceRef;
        }

        @Override
        @JsonProperty(value="artifactIds")
        public SortedSet<Long> getArtifactIds() {
            return this.artifactIds;
        }

        @Override
        @JsonProperty(value="methods")
        public List<MethodCallData> getMethods() {
            return this.methods;
        }

        @Override
        public InstanceVulnMethod.Builder toBuilder() {
            InstanceVulnMethod.Builder builder = new InstanceVulnMethod.Builder();
            ((InstanceVulnMethod_Builder)builder).libraryInstanceRef = this.libraryInstanceRef;
            ((InstanceVulnMethod_Builder)builder).artifactIds = this.artifactIds;
            ((InstanceVulnMethod_Builder)builder).methods = this.methods;
            ((InstanceVulnMethod_Builder)builder)._unsetProperties.clear();
            return builder;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Value)) {
                return false;
            }
            Value other = (Value)obj;
            return Objects.equals(this.libraryInstanceRef, other.libraryInstanceRef) && Objects.equals(this.artifactIds, other.artifactIds) && Objects.equals(this.methods, other.methods);
        }

        public int hashCode() {
            return Objects.hash(this.libraryInstanceRef, this.artifactIds, this.methods);
        }

        public String toString() {
            return "InstanceVulnMethod{libraryInstanceRef=" + this.libraryInstanceRef + ", artifactIds=" + this.artifactIds + ", methods=" + this.methods + "}";
        }
    }

    private static abstract class Rebuildable
    implements InstanceVulnMethod {
        private Rebuildable() {
        }

        public abstract InstanceVulnMethod.Builder toBuilder();
    }

    private static enum Property {
        LIBRARY_INSTANCE_REF("libraryInstanceRef");

        private final String name;

        private Property(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

