/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class FeatureFlag {
    public static final String MAVEN_NATIVE_COLLECTOR_JGRAPHT = "MAVEN_NATIVE_COLLECTOR_JGRAPHT";
    public static final String GRADLE_NATIVE_COLLECTOR_JGRAPHT = "GRADLE_NATIVE_COLLECTOR_JGRAPHT";
    public static final String GEM_NATIVE_COLLECTOR_JGRAPHT = "GEM_NATIVE_COLLECTOR_JGRAPHT";
    public static final String NPM_NATIVE_COLLECTOR_JGRAPHT = "NPM_NATIVE_COLLECTOR_JGRAPHT";
    public static final String BOWER_NATIVE_COLLECTOR_JGRAPHT = "BOWER_NATIVE_COLLECTOR_JGRAPHT";
    public static final String JGRAPHT = "JGRAPHT";

    public static boolean featureIsOn(Flag flag, ImmutableMap<String, Object> attributes) {
        switch (flag) {
            case ENABLE_GEM_NATIVE_COLLECTOR_JGRAPHT: 
            case ENABLE_NPM_NATIVE_COLLECTOR_JGRAPHT: 
            case ENABLE_MAVEN_NATIVE_COLLECTOR_JGRAPHT: 
            case ENABLE_GRADLE_NATIVE_COLLECTOR_JGRAPHT: {
                return FeatureFlag.parseBoolean(Flag.ENABLE_JGRAPHT, attributes) || FeatureFlag.parseBoolean(flag, attributes);
            }
            case ENABLE_JGRAPHT: {
                return FeatureFlag.parseBoolean(flag, attributes);
            }
        }
        return false;
    }

    private static boolean parseBoolean(Flag flag, Map<String, Object> attributes) {
        return Boolean.valueOf(String.valueOf(attributes.get(flag.getDirective().toUpperCase())));
    }

    public static enum Flag {
        ENABLE_JGRAPHT("JGRAPHT"),
        ENABLE_BOWER_NATIVE_COLLECTOR_JGRAPHT("BOWER_NATIVE_COLLECTOR_JGRAPHT"),
        ENABLE_MAVEN_NATIVE_COLLECTOR_JGRAPHT("MAVEN_NATIVE_COLLECTOR_JGRAPHT"),
        ENABLE_GRADLE_NATIVE_COLLECTOR_JGRAPHT("GRADLE_NATIVE_COLLECTOR_JGRAPHT"),
        ENABLE_GEM_NATIVE_COLLECTOR_JGRAPHT("GEM_NATIVE_COLLECTOR_JGRAPHT"),
        ENABLE_NPM_NATIVE_COLLECTOR_JGRAPHT("NPM_NATIVE_COLLECTOR_JGRAPHT");

        private String directive;

        private Flag(String directive) {
            this.directive = directive;
        }

        public String getDirective() {
            return this.directive;
        }
    }
}

