/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.common;

import com.google.common.collect.ImmutableSet;
import com.sourceclear.engine.common.FileTypeVisitor;
import com.sourceclear.engine.common.FilenameVisitor;
import com.sourceclear.engine.common.StoredFileVisitor;
import com.veracode.security.logging.SecureLogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;

public class ProjectDLLUtils {
    private static final Set<String> ignoredDirectories = new HashSet<String>(Arrays.asList("tests", "test", "packages", "bin", "obj", ".git"));
    private static final String DLL_EXTENSION = ".dll";
    private static final SecureLogger LOGGER = SecureLogger.getLogger(ProjectDLLUtils.class);

    public static StoredFileVisitor visitorStartingAt(Path directory, Set<String> ignoredDirectories) throws IOException {
        MsBuildFileVisitor msBuildFileVisitor = new MsBuildFileVisitor(ignoredDirectories);
        Files.walkFileTree(directory, msBuildFileVisitor);
        ImmutableSet<Path> buildFiles = msBuildFileVisitor.getFiles();
        LOGGER.debug("Found msbuild files: {}", (Object)buildFiles);
        Set<String> projectDllsToLookFor = buildFiles.stream().map(buildFile -> FilenameUtils.removeExtension((String)buildFile.getFileName().toString()) + DLL_EXTENSION).collect(Collectors.toSet());
        FilenameVisitor dllVisitor = new FilenameVisitor(projectDllsToLookFor, Collections.emptySet());
        return dllVisitor;
    }

    public static StoredFileVisitor visitorStartingAt(Path directory) throws IOException {
        return ProjectDLLUtils.visitorStartingAt(directory, ignoredDirectories);
    }

    static class MsBuildFileVisitor
    extends FileTypeVisitor {
        private static final Set<String> extensions = new HashSet<String>(Arrays.asList(".csproj", ".fsproj", ".vbproj"));

        public MsBuildFileVisitor(Set<String> ignoredDirectories) {
            super(extensions, ignoredDirectories);
        }
    }
}

