/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.engine.methods;

import com.sourceclear.api.data.methods.MethodCallData;
import com.sourceclear.engine.common.logging.LogStream;
import com.sourceclear.engine.methods.BaseMethodsEngine;
import com.sourceclear.engine.methods.MethodScanBatcher;
import com.sourceclear.engine.methods.MethodsEngine;
import com.sourceclear.engine.methods.SimpleDirectoryMethodScanBatcher;
import com.sourceclear.methods.EntryPointResolver;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.PermissiveEntryPointResolver;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.methods.python.PythonMethodScannerFactory;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class PythonMethodsEngine
extends BaseMethodsEngine {
    private static final EntryPointResolver ENTRY_POINT_RESOLVER = new PermissiveEntryPointResolver();
    private final MethodScannerFactory methodScannerFactory = new PythonMethodScannerFactory();
    private Collection<MethodInfo> publicMethodStubs = Collections.emptySet();

    @Override
    public MethodsEngine.Result scanMethods(Path scanRoot, Collection<MethodCallData> inputMethodData, LogStream logStream) {
        try {
            return this.innerScanMethods(scanRoot, inputMethodData, logStream);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public MethodsEngine withPublicMethodStubs(Collection<MethodInfo> publicMethodStubs) {
        this.publicMethodStubs = publicMethodStubs;
        return this;
    }

    @Override
    public MethodsEngine withVulnMethodsConfig(VulnMethodsConfig config) {
        this.methodScannerFactory.withVulnMethodsConfig(config);
        return this;
    }

    @Override
    public Collection<MethodInfo> getPublicMethodStubs() {
        return this.publicMethodStubs;
    }

    @Override
    public VulnMethodsConfig.Builder defaultConfig() {
        return this.methodScannerFactory.defaultVulnMethodsConfig();
    }

    @Override
    MethodScanBatcher setupBatcher(Path scanRoot, LogStream logStream) {
        return new SimpleDirectoryMethodScanBatcher(this.methodScannerFactory);
    }
}

