/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.librarydiffs;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.MethodInfo;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;

public class HashedMethod
implements Comparable<HashedMethod> {
    @JsonProperty
    private MethodInfo method;
    @JsonProperty
    private String hash;
    @JsonProperty(access=JsonProperty.Access.WRITE_ONLY)
    private boolean publicAccess;

    public HashedMethod() {
    }

    public HashedMethod(MethodInfo method, String hash) {
        this.method = method;
        this.hash = hash;
        this.publicAccess = true;
    }

    public HashedMethod(MethodInfo method, String hash, boolean publicAccess) {
        this.method = method;
        this.hash = hash;
        this.publicAccess = publicAccess;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HashedMethod that = (HashedMethod)o;
        if (!this.method.equals(that.method)) {
            return false;
        }
        return this.hash.equals(that.hash);
    }

    public int hashCode() {
        int result = this.method.hashCode();
        result = 31 * result + this.hash.hashCode();
        return result;
    }

    public String toString() {
        return this.method.toString() + " " + this.hash;
    }

    @Override
    public int compareTo(HashedMethod other) {
        return ComparisonChain.start().compare((Object)this.method.getModuleName(), (Object)other.method.getModuleName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.method.getClassName(), (Object)other.method.getClassName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.method.getMethodName(), (Object)other.method.getMethodName(), (Comparator)Ordering.natural().nullsFirst()).compare((Object)this.method.getDesc(), (Object)other.method.getDesc(), (Comparator)Ordering.natural().nullsFirst()).compare((Comparable)((Object)this.hash), (Comparable)((Object)other.hash)).result();
    }

    @JsonSetter(value="public_access")
    public void setPublicAccess(boolean publicAccess) {
        this.publicAccess = publicAccess;
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public HashedMethod combine(HashedMethod hm) {
        if (!hm.method.equals(this.method)) {
            throw new IllegalArgumentException("may only be used on hashed methods with the same method");
        }
        if (hm.hash.equals(this.hash)) {
            return this;
        }
        try {
            Object[] objects = new String[]{hm.hash, this.hash};
            Arrays.sort(objects);
            String h = Utils.hashObjects((Serializable[])objects);
            return new HashedMethod(this.method, h, this.publicAccess);
        }
        catch (IOException e) {
            throw new IllegalStateException("hashing strings shouldn't involve any I/O");
        }
    }

    public boolean isPublic() {
        return this.publicAccess;
    }

    @VisibleForTesting
    public String getHash() {
        return this.hash;
    }
}

