/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.librarydiffs.delta;

import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.sourceclear.librarydiffs.delta.DeltaMethod;
import com.sourceclear.librarydiffs.delta.Op;
import com.sourceclear.librarydiffs.delta.ToDeltaMethod;
import com.sourceclear.methods.MethodInfo;
import java.util.Objects;

public class TaggedMethod
implements ToDeltaMethod {
    @JsonUnwrapped
    private final MethodInfo method;
    private final String tag;

    public TaggedMethod(MethodInfo m) {
        this(m, null);
    }

    public TaggedMethod(MethodInfo m, String tag) {
        this.method = m;
        this.tag = tag;
    }

    @Override
    public DeltaMethod coerce(Op op) {
        return new DeltaMethod(this.method, op, this.tag);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaggedMethod that = (TaggedMethod)o;
        return Objects.equals(this.method, that.method) && Objects.equals(this.tag, that.tag);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.tag);
    }

    public String toString() {
        return "TaggedMethod{method=" + this.method + ", tag='" + this.tag + '\'' + '}';
    }

    public MethodInfo getMethod() {
        return this.method;
    }

    public String getTag() {
        return this.tag;
    }
}

