/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.dotnet.v2;

import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.Cleaner;
import com.sourceclear.methods.EntryPointResolver;
import com.sourceclear.methods.MethodInfo;
import com.sourceclear.methods.MethodScanner;
import com.sourceclear.methods.MethodScannerFactory;
import com.sourceclear.methods.VulnMethodsConfig;
import com.sourceclear.methods.VulnerablePartsDetector;
import com.sourceclear.methods.dotnet.v2.DotNetCallGraphBuilderV2;
import io.vavr.control.Either;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class DotNetMethodScannerFactoryV2
extends MethodScannerFactory {
    @Override
    public VulnMethodsConfig.Builder defaultVulnMethodsConfig() {
        return VulnMethodsConfig.Builder.dotnet();
    }

    @Override
    public MethodScanner forArchiveStream(InputStream archiveStream, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        Either result = Utils.readDlls(archiveStream, dlls -> {
            try {
                return Either.right((Object)this.forFiles((Collection<Path>)dlls, vulnerableMethods, entryPointResolver));
            }
            catch (IOException e) {
                return Either.left((Object)e);
            }
        });
        if (result.isLeft()) {
            throw new IOException("Unable to create MethodScanner for archive stream with methods: " + vulnerableMethods, (Throwable)result.getLeft());
        }
        return (MethodScanner)result.get();
    }

    @Override
    public MethodScanner forFiles(Collection<Path> files2, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        DotNetCallGraphBuilderV2 callGraphBuilder = new DotNetCallGraphBuilderV2(files2, this.config.parallel());
        return new VulnerablePartsDetector(vulnerableMethods, entryPointResolver, callGraphBuilder, this.input, Cleaner.DO_NOTHING);
    }

    @Override
    public MethodScanner forDirectory(Path directory, Collection<MethodInfo> vulnerableMethods, EntryPointResolver entryPointResolver) throws IOException {
        Set<Path> paths = Files.walk(directory, new FileVisitOption[0]).filter(p -> p.toString().endsWith(".exe") || p.toString().endsWith(".dll")).collect(Collectors.toSet());
        DotNetCallGraphBuilderV2 callGraphBuilder = new DotNetCallGraphBuilderV2(paths, this.config.parallel());
        return new VulnerablePartsDetector(vulnerableMethods, entryPointResolver, callGraphBuilder, this.input, Cleaner.DO_NOTHING);
    }
}

