/*
 * Decompiled with CFR 0.152.
 */
package com.sourceclear.methods.java;

import com.google.common.base.Strings;
import com.sourceclear.analysis.utils.Utils;
import com.sourceclear.methods.MethodInfoImpl;
import com.sourceclear.methods.java.Constants;
import com.sourceclear.methods.java.MethodInvocation;
import java.util.Set;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

class ReflectionMethodVisitor
extends MethodVisitor {
    private final Set<Type> reflectedClasses;
    private final Set<String> reflectedMethodNames;
    private String currentLoadedString;

    ReflectionMethodVisitor(int version, Set<Type> reflectedClasses, Set<String> reflectedMethodNames) {
        super(version);
        this.reflectedClasses = reflectedClasses;
        this.reflectedMethodNames = reflectedMethodNames;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        MethodInvocation invocation = new MethodInvocation(opcode, new MethodInfoImpl(owner, name, Utils.stripReturnType(desc)));
        if (!Strings.isNullOrEmpty((String)this.currentLoadedString)) {
            if (Constants.GET_METHOD_INVOCATION.equals(invocation)) {
                this.reflectedMethodNames.add(this.currentLoadedString);
            } else if (Constants.FOR_NAME_METHOD_INVOCATION.equals(invocation)) {
                this.reflectedClasses.add(Type.getObjectType((String)Utils.classNameToInternalName(this.currentLoadedString)));
            }
            this.currentLoadedString = null;
        }
    }

    public void visitLdcInsn(Object arg) {
        if (arg instanceof Type) {
            Type type = (Type)arg;
            if (type.getSort() == 10) {
                this.reflectedClasses.add(type);
            }
        } else if (arg instanceof String) {
            this.currentLoadedString = (String)arg;
        }
    }
}

